module.exports = function(hg, done) {
	hg.event.observe('onCitationsLoaded', function(client) {
		var cols = null;
		var getSql = function(id) {
			return 'SELECT \'groups\' AS domain, g.gidNumber AS id, g.type AS group_type, g.cn AS cn, g.description AS title, coalesce(g.public_desc, \'\') AS body, CAST(concat(\'/groups/\', g.cn) AS CHAR) AS link, ' +
				'(SELECT CAST(group_concat(DISTINCT jto.tagid separator \'\\n\') AS CHAR) FROM jos_tags_object jto INNER JOIN jos_tags jt ON jt.id = jto.tagid WHERE jto.tbl = \'groups\' AND jto.objectid = g.gidNumber) AS tag_ids, ' + 
				'join_policy AS privacy, discoverability AS discoverability, plugins AS params, ' +
				'(SELECT COUNT(DISTINCT uidNumber) FROM jos_xgroups_members me WHERE me.gidNumber = g.gidNumber) AS member_count ' +
				'FROM jos_xgroups g WHERE g.type = 1 OR g.type = 3' + (id ? ' AND g.gidNumber = ' + (id*1) : '')
		};

		var query = function(client, cb, id) {
			if (!cols) {
				client.getColumnMap('jos_xgroups', function(c) {
					cols = c;
					query(client, cb, id);
				});
				return;
			}
			client.query(getSql(id), function(err, results) {
				if (err) {
					throw err;
				}
				cb(results);
			});
		};

		hg.groupPerms = {};

		var add = function(res) {
			var params = {};
			if (res.params) {
				res.params.split(/,\s*/).forEach(function(param) {
					var ma = param.match(/^([^=]+)=(.*)$/);
					if (ma) {
						params[ma[1]] = ma[2];
					}
				});
			}
			['members', 'wiki', 'resources', 'forum', 'blog', 'wishlist', 'usage', 'projects', 'calendar', 'announcements', 'collections'].forEach(function(plugin) {
				if (!params[plugin]) {
					params[plugin] = 'members';
				}
			});
			res.params = params;
			hg.add({'domain': 'aliases', 'id': 'group:' + res.id, 'title': res.title});
			hg.addWithCommonConnections(res);
			hg.groupPerms[res.id] = {'privacy': res.privacy, 'discoverability': res.discoverability, 'params': res.params};
		};

		query(client, function(results) {
			results.forEach(add);
			done();
			hg.event.emit('onGroupsLoaded', [client]);
		});

		hg.event.observe('onUpdateXgroups', function(client, row) {
			query(client, function(results) {
				if (results.length) {
					results.forEach(add);
				}
				else {
					hg.remove('groups', row.id);
				}
			}, row.id);
		});

		hg.event.observe('onInsertXgroups', function(client, row) {
			query(client, function(results) {
				results.forEach(add);
			}, row.id);
		});

		hg.event.observe('onDeleteXgroups', function(client, row) {
			hg.remove('groups', row.id);
		});
	});
};
