module.exports = function(hg, done) {
	hg.event.observe('onUsersLoaded', function(client) {
		var cols = null;
		var getSql = function(id) {
			var sql = 'SELECT ' +
				'\'citations\' AS domain, id, CASE WHEN booktitle IS NOT NULL THEN \'Book section\' ELSE \'Journal Article\' END AS type, CAST(CONCAT(year, \'/01/01\ 00:00:00\') AS CHAR) AS date, ' +
				'coalesce(booktitle, journal) AS publication_title, title, ';
			if (cols.abstract) {
				sql += 'CASE WHEN params LIKE \'%rollover=1%\' THEN ' +
						'CAST(CONCAT(COALESCE(abstract, \'\'), \' \', COALESCE(notes, \'\')) AS CHAR) ' +
					'ELSE ' +
						'COALESCE(notes, \'\') END ' +
					'AS body, ';
			}
			sql +=
				'notes, address, author AS authors, chapter, cite, edition, editor, isbn, location, number, pages, ' +
				'publisher, url AS link, volume, doi, ' +
				'(SELECT CAST(group_concat(DISTINCT tagid separator \'\\n\') AS CHAR) FROM jos_tags_object jto INNER JOIN jos_tags t ON t.id = jto.tagid WHERE jto.tbl = \'citations\' AND jto.objectid = c.id) AS tag_ids ' +
			'FROM jos_citations c '+
			'WHERE published AND CONCAT(journal, booktitle) NOT LIKE \'%\\\'%\'';
			return id ? sql + ' AND c.id = ' + (id * 1) : sql;
		};
		var query = function(cb, id) {
			if (!cols) {
				client.getColumnMap('jos_citations', function(c) {
					cols = c;
					query(cb);
				});
				return;
			}
			client.query(getSql(id), cb);	
		};
		var idx = 0;
		var add = function(res) {
			res.link = '/citations/view/' + res.id + (res.link ? "\n" + res.link : '');
			hg.addWithCommonConnections(res);
			hg.add({'domain': 'aliases', 'title': res.authors, 'id': 'authortext:' + res.authors});
			hg.connect('alias', 'aliases', 'authortext:' + res.authors, 'citations', res.id, 0.5);
			if (res.publication_title) {
				hg.add({'domain': 'aliases', 'title': res.publication_title, 'id': 'publication:' + res.publication_title});
				hg.connect('alias', 'aliases', 'publication:' + res.publication_title, 'citations', res.id, 0.5);
			}
		};
		query(function(err, results) {
			if (err) {
				throw err;
			}
			hg.log(results.length + ' citations');
			results.forEach(add);
			done();
			hg.event.emit('onCitationsLoaded', [client]);
		});

		hg.event.observe('onUpdateCitations', function(client, row) {
			var sql = getSql(row.id);
			client.query(sql, function(err, results) {
				if (err) {
					throw err;
				}
				if (!results.length) {
					hg.remove('citations', row.id);
				}
				else {
					results.forEach(add);
				}
			});
		});

		hg.event.observe('onInsertCitations', function(client, row) {
			var sql = getSql(row.id);
			client.query(sql, function(err, results) {
				if (err) {
					throw err;
				}
				results.forEach(add);
			});
		});

		hg.event.observe('onDeleteCitations', function(client, row) {
			hg.remove('citations', row.id);
		});
	});
};
