module.exports = function(hg, done) {
	hg.event.observe('onResourcesLoaded', function(client) {
		['group_cn', '`group`'].forEach(function(groupCol) {
			var sql = ['SELECT',
				'CASE WHEN xg.gidNumber IS NULL THEN \'topics\' ELSE \'wikis\' END AS domain, wp.id AS id, ',
				'wp.title, wv.pagetext AS body,',
				'CASE ',
					'WHEN wp.' + groupCol + ' LIKE \'pr-%\' THEN concat(\'index.php?option=com_projects&scope=\', wp.scope, \'&pagename=\', wp.pagename)',
					'WHEN wp.' + groupCol + ' THEN concat(\'index.php?option=com_groups&scope=\', wp.scope, \'&pagename=\', wp.pagename)',
					'ELSE concat(\'index.php?option=com_wiki&scope=\', wp.scope, \'&pagename=\', wp.pagename)',
				'END AS link,',
				'wv.created AS date, xg.description AS type, wp.access, xg.gidNumber AS group_ids,',
				'(SELECT CAST(group_concat(pa.user_id SEPARATOR \'\\n\') AS CHAR) FROM jos_wiki_page_author pa WHERE pa.page_id = wp.id) AS contributor_ids',
				'FROM jos_wiki_version wv',
				'INNER JOIN jos_wiki_page wp ON wp.id = wv.pageid',
				'LEFT JOIN jos_xgroups xg ON xg.cn = wp.' + groupCol, 
				'WHERE',
					'wp.state < 2 AND',
					'wv.id = (SELECT MAX(wv2.id) FROM jos_wiki_version wv2 WHERE wv2.pageid = wv.pageid AND wv2.approved)'
			].join("\n");

			client.query(sql, function(err, results) {                                                                                                                                                                                                                                   
				if (err) {
					if (err.message.indexOf('ER_BAD_FIELD_ERROR') == -1) {
						console.log(err.message);
						throw err;
					}
					console.log('skipping: ');
					console.log(err.message);
					return;
				}
				hg.log(results.length + ' wiki/topic pages');
				results.forEach(hg.addWithCommonConnections);
				done();
				hg.event.emit('onWikiLoaded', [client]);
			});
		});
	
		hg.event.observe('onUpdateWikiPage', function(client, row) {
		});

		hg.event.observe('onInsertWikiPage', function(client, row) {
		});

		hg.event.observe('onDeleteWikiPage', function(client, row) {
			hg.remove('topics', row.id);
			hg.remove('group wiki', row.id);
		});


		hg.event.observe('onUpdateWikiVersion', function(client, row) {
		});

		hg.event.observe('onInsertWikiVersion', function(client, row) {
		});

		hg.event.observe('onDeleteWikiVersion', function(client, row) {
			hg.remove('topics', row.id);
			hg.remove('group wiki', row.id);
		});


		hg.event.observe('onUpdateWikiPageAuthor', function(client, row) {
		});

		hg.event.observe('onInsertWikiPageAuthor', function(client, row) {
		});

		hg.event.observe('onDeleteWikiPageAuthor', function(client, row) {
			hg.remove('topics', row.id);
			hg.remove('group wiki', row.id);
		});

	});
};
