module.exports = function(hg, done) {
	if (!hg.conf.hubgraph.thesaurus) {
		done();
		return;
	}
	hg.event.observe('onResourcesComplete', function() {
		hg.log('loading synonyms');
		var letter = '';
		require('line-reader').eachLine(hg.conf.hubgraph.thesaurus, function(line) {
			var words = line.split(',');
			if (words[0][0].toLowerCase() != letter) {
				letter = words[0][0].toLowerCase();
			}
			var stems = [];
			words.forEach(function(word) {
				if (hg.getWordCount(word)) {
					stems.push(word);
				}
			});
			for (var idx = 0; idx < stems.length; ++idx) {
				for (var jdx = 0; jdx < stems.length; ++jdx) {
					hg.connect('synonym', 'text', stems[idx], 'text', stems[jdx]);
				}
			}
		}).then(function() {
			done();
			hg.log('synonyms complete');
		});
		
	});
};
/*
var hg = require('hubgraph');
require('../stdlib.js').bind(hg);
module.exports(hg);
hg.event.emit('onResourcesComplete');
*/
