module.exports = function(hg, done) {
	var getSql = function(id) {
		var sql = 'SELECT \'events\' AS domain, e.id, e.title, e.scope_id AS group_ids, e.content AS body, CAST(concat(\'/events/details/\', e.id) AS CHAR) AS link, publish_up AS date, ' +
			'(SELECT CAST(group_concat(DISTINCT jto.tagid separator \'\\n\') AS CHAR) FROM jos_tags_object jto INNER JOIN jos_tags jt ON jt.id = jto.tagid WHERE jto.tbl = \'events\' AND jto.objectid = e.id) AS tag_ids ' +
			'FROM jos_events e WHERE approved';
		return id ? sql + ' AND e.id = ' + (id*1) : sql;
	};
	hg.event.observe('onWishlistsLoaded', function(client) {
		var sql = getSql();
		client.query(sql, function(err, results) {
			if (err) {
				throw err;
			}
			results.forEach(hg.addWithCommonConnections);
			done();
			hg.event.emit('onEventsComplete', [client]);
		});
	});
	
	hg.event.observe('onUpdateEvents', function(client, row) {
		var sql = getSql(row.id);
		client.query(sql, function(err, results) {
			if (err) {
				throw err;
			}
			if (!results.length) {
				hg.remove('events', row.id);
			}
			else {
				results.forEach(hg.addWithCommonConnections);
			}
		});
	});

	hg.event.observe('onInsertEvents', function(client, row) {
		var sql = getSql(row.id);
		client.query(sql, function(err, results) {
			if (err) {
				throw err;
			}
			results.forEach(hg.addWithCommonConnections);
		});
	});

	hg.event.observe('onDeleteEvents', function(client, row) {
		hg.remove('events', row.id);
	});
};
