module.exports = function(opts) {
	var out = opts && opts.out || function(str) {
		console.log(str);
	},
		hg = opts && opts.hg || require('hubgraph-ext')(),
		fs = require('fs'),
		tables = {},
		base = hg.conf.hubgraph.root + '/lib/resources',
		idName = {
			'xprofiles'    : 'uidNumber',
			'xprofiles_bio': 'uidNumber',
			'xgroups'      : 'gidNumber'
		},
		notes = {
			'vote_log': {'table': 'category', 'id': 'referenceid'},
			'wishlist_vote': {'wish_id': 'wishid'},
			'faq_categories': {'alias': 'alias'},
			'wiki_page_authors': {'page_id': 'page_id', 'user_id': 'user_id'},
			'resource_taxonomy_audience': {'resource_id': 'rid'},
			'resource_assoc': {'parent_id': 'parent_id', 'child_id': 'child_id'},
			'wiki_version': {'page_id': 'pageid'},
			'forum_categories': {'alias': 'alias'},
			'forum_sections': {'alias': 'alias'},
			'categories': {'alias': 'alias'},
			'answers_responses': {'question_id': 'question_id'},
			'tags_object': {'other_id': 'objectid', 'table': 'tbl'},
			'author_assoc': {'other_id': 'subid', 'table': 'subtable'},
			'document_resource_rel': {'other_id': 'resource_id'},
			'xgroups_members': {'group_id': 'gidNumber', 'user_id': 'uidNumber'}
		}
		;
	opts = hg.conf;
	opts.host = opts.host || hg.conf.mysql.host || 'localhost';
	opts.port = opts.port || hg.conf.mysql.port || hg.conf.mysql.port || 3306;
	opts.database = opts.database || hg.conf.mysql.database;
	opts.user = opts.user || hg.conf.mysql.user;
	opts.password = opts.password || hg.conf.mysql.password;

	if (parseInt(opts.port) != opts.port) {
		opts.socketPath = opts.port;
		delete opts.host;
		delete opts.port;
	}
	fs.readdirSync(base).filter(function(file) {
		return /[.]js$/.test(file);
	}).forEach(function(file) {
		var ma = fs.readFileSync(base + '/' + file).toString().match(/jos_[a-z0-9_]+/g);
		if (ma) {
			ma.forEach(function(tbl) {
				var baseName = tbl.replace(/^jos_/, '');
				tables[tbl] = idName[baseName] || 'id';
			});
		}
	});
	if (opts && opts.list) {
		return tables;
	}
	out('DELIMITER ***');

	var dbh = require('mysql').createConnection(opts);

	out('DROP PROCEDURE IF EXISTS hg_update_schema***');
	out(['CREATE PROCEDURE hg_update_schema()',
	'BEGIN',
	'	DECLARE existsFlag int;',
	'	SET existsFlag = 0;',
	'	DROP TABLE IF EXISTS hg_update_queue;',
	'	CREATE TABLE hg_update_queue(action ENUM(\'INSERT\', \'UPDATE\', \'DELETE\') NOT NULL, table_name varchar(50) NOT NULL, id INT NOT NULL, other_id INT NULL, note text);',
	'	SELECT 1 INTO existsFlag',
	'		FROM information_schema.COLUMNS', 
	'		WHERE TABLE_SCHEMA = DATABASE()',
	'		AND TABLE_NAME = \'jos_resource_assoc\'', 
	'		AND COLUMN_NAME = \'id\';',
	'	IF (existsFlag = 0) THEN',
	'		ALTER TABLE jos_resource_assoc ADD COLUMN id SERIAL NOT NULL PRIMARY KEY;',
	'	END IF;',
	'	SET existsFlag = 0;',
	'	SELECT 1 INTO existsFlag',
	'		FROM information_schema.COLUMNS', 
	'		WHERE TABLE_SCHEMA = DATABASE()',
	'		AND TABLE_NAME = \'jos_xgroups_members\'', 
	'		AND COLUMN_NAME = \'id\';',
	'	IF (existsFlag = 0) THEN',
	'		ALTER TABLE jos_xgroups_members DROP PRIMARY KEY;',
	'		CREATE UNIQUE INDEX jos_xgroups_members_gidnumber_uidnumber_uidx ON jos_xgroups_members(gidNumber, uidNumber);',
	'		ALTER TABLE jos_xgroups_members ADD COLUMN id SERIAL NOT NULL PRIMARY KEY;',
	'	END IF;',
	'	SET existsFlag = 0;',
	'	SELECT 1 INTO existsFlag',
	'		FROM information_schema.COLUMNS',
	'		WHERE TABLE_SCHEMA = DATABASE()',
	'		AND TABLE_NAME = \'jos_author_assoc\'', 
	'		AND COLUMN_NAME = \'id\';',
	'	IF (existsFlag = 0) THEN',
	'		ALTER TABLE jos_author_assoc DROP PRIMARY KEY;',
	'		CREATE UNIQUE INDEX jos_author_assoc_subtable_subid_authorid_uidx ON jos_author_assoc(subtable, subid, authorid);',
	'		ALTER TABLE jos_author_assoc ADD COLUMN id SERIAL NOT NULL PRIMARY KEY;',
	'	END IF;',
	'END***'].join("\n"));
	out('CALL hg_update_schema()***');
	out('DROP PROCEDURE hg_update_schema***');
	for (var tbl in tables) {
		(function(tbl) {
			var baseName = tbl.replace(/^jos_/, '');
			dbh.query('SELECT COUNT(*) AS count FROM information_schema.TABLES where table_name = \'' + tbl + '\' AND table_schema = database()', function(err, res) {
				if (err) {
					throw err;
				}
				if (res[0].count == 1) {
					out('DROP TRIGGER IF EXISTS hg_' + tbl + '_insert_trigger***');
					out('CREATE TRIGGER hg_' + tbl + '_insert_trigger AFTER INSERT ON ' + tbl + "\n" +
						'FOR EACH ROW BEGIN ' + "\n" +
							'INSERT INTO hg_update_queue(action, table_name, id) VALUES (\'INSERT\', \'' + baseName + '\', NEW.' + tables[tbl] + ');' + "\n" +
						'END;' + "\n" + 
						'***'
					);
					out('DROP TRIGGER IF EXISTS hg_' + tbl + '_update_trigger***');
					out('CREATE TRIGGER hg_' + tbl + '_update_trigger AFTER UPDATE ON ' + tbl + "\n" +
						'FOR EACH ROW BEGIN ' + "\n" +
							'INSERT INTO hg_update_queue(action, table_name, id) VALUES (\'UPDATE\', \'' + baseName + '\', NEW.' + tables[tbl] + ');' + "\n" +
						'END;' + "\n" + 
						'***'
					);	
					var note = notes[baseName], noteConcat = [];
					if (note) {
						for (var k in note) {
							noteConcat.push('"' + k + '": "\', OLD.' + note[k] + ', \'"');
						}
						noteConcat = 'concat(\'{' + noteConcat.join(', ') + '}\')';
					}
					out('DROP TRIGGER IF EXISTS hg_' + tbl + '_delete_trigger***');
					out('CREATE TRIGGER hg_' + tbl + '_delete_trigger BEFORE DELETE ON ' + tbl + "\n" +
						'FOR EACH ROW BEGIN ' + "\n" +
							'INSERT INTO hg_update_queue(action, table_name, id' + (note ? ', note' : '') + ') VALUES (\'DELETE\', \'' + baseName + '\', OLD.' + tables[tbl] + (note ? ', ' + noteConcat : '') +
							');' + "\n" +
						'END;' + "\n" + 
						'***'
					);	
				}
			});
		})(tbl);
	}
	dbh.end();
};

