/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.util.Collections;

class VncCanvas
extends Canvas
implements KeyListener,
MouseListener,
MouseMotionListener,
Repaintable,
Runnable {
    VncViewer viewer;
    RfbProto rfb;
    ColorModel cm8;
    ColorModel cm24;
    int bytesPixel;
    int maxWidth = 0;
    int maxHeight = 0;
    int scalingFactor;
    int scaledWidth;
    int scaledHeight;
    Image memImage;
    Graphics memGraphics;
    RawDecoder rawDecoder;
    RREDecoder rreDecoder;
    CoRREDecoder correDecoder;
    ZlibDecoder zlibDecoder;
    HextileDecoder hextileDecoder;
    ZRLEDecoder zrleDecoder;
    TightDecoder tightDecoder;
    CopyRectDecoder copyRectDecoder;
    RawDecoder[] decoders = null;
    long statStartTime;
    long statNumUpdates;
    long statNumTotalRects;
    long statNumPixelRects;
    long statNumRectsTight;
    long statNumRectsTightJPEG;
    long statNumRectsZRLE;
    long statNumRectsHextile;
    long statNumRectsRaw;
    long statNumRectsCopy;
    long statNumBytesEncoded;
    long statNumBytesDecoded;
    boolean inputEnabled;
    boolean isFirstSizeAutoUpdate = true;
    long lastMouseEventSendTime = System.currentTimeMillis();
    long mouseMaxFreq = 20L;
    boolean showSoftCursor = false;
    MemoryImageSource softCursorSource;
    MemoryImageSource localCursorSource;
    Image softCursor;
    Image localCursorImage;
    Cursor invisibleCursor;
    Cursor localCursor;
    MouseEvent mouseEvent = null;
    boolean needToSendMouseEvent = false;
    int cursorX = 0;
    int cursorY = 0;
    int cursorWidth;
    int cursorHeight;
    int origCursorWidth;
    int origCursorHeight;
    int hotX;
    int hotY;
    int origHotX;
    int origHotY;
    private boolean inSelectionMode;
    private Point selectionStart;
    private Point selectionEnd;
    private Cursor savedCursor;

    public VncCanvas(VncViewer vncViewer, int n, int n2) throws IOException {
        this.viewer = vncViewer;
        this.maxWidth = n;
        this.maxHeight = n2;
        this.rfb = this.viewer.rfb;
        this.scalingFactor = this.viewer.options.scalingFactor;
        this.cm8 = new DirectColorModel(8, 7, 56, 192);
        this.cm24 = new DirectColorModel(24, 0xFF0000, 65280, 255);
        this.invisibleCursor = Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().createImage(new byte[4]), new Point(0, 0), "invisible");
        if (!this.viewer.showLocalCursor) {
            this.setCursor(this.invisibleCursor);
        }
        this.setFocusTraversalKeysEnabled(false);
        this.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.setFocusTraversalKeys(1, Collections.EMPTY_SET);
        RfbInputStream rfbInputStream = new RfbInputStream(this.rfb);
        RecordOutputStream recordOutputStream = new RecordOutputStream(this.rfb);
        this.rawDecoder = new RawDecoder(this.memGraphics, rfbInputStream);
        this.rreDecoder = new RREDecoder(this.memGraphics, rfbInputStream);
        this.correDecoder = new CoRREDecoder(this.memGraphics, rfbInputStream);
        this.hextileDecoder = new HextileDecoder(this.memGraphics, rfbInputStream);
        this.tightDecoder = new TightDecoder(this.memGraphics, rfbInputStream);
        this.zlibDecoder = new ZlibDecoder(this.memGraphics, rfbInputStream);
        this.zrleDecoder = new ZRLEDecoder(this.memGraphics, rfbInputStream);
        this.copyRectDecoder = new CopyRectDecoder(this.memGraphics, rfbInputStream);
        this.hextileDecoder.setRepainableControl(this);
        this.tightDecoder.setRepainableControl(this);
        this.decoders = new RawDecoder[8];
        this.decoders[0] = this.rawDecoder;
        this.decoders[1] = this.rreDecoder;
        this.decoders[2] = this.correDecoder;
        this.decoders[3] = this.hextileDecoder;
        this.decoders[4] = this.zlibDecoder;
        this.decoders[5] = this.tightDecoder;
        this.decoders[6] = this.zrleDecoder;
        this.decoders[7] = this.copyRectDecoder;
        for (int i = 0; i < this.decoders.length; ++i) {
            this.decoders[i].setDataOutputStream(recordOutputStream);
        }
        this.setPixelFormat();
        this.resetSelection();
        this.inputEnabled = false;
        if (!this.viewer.options.viewOnly) {
            this.enableInput(true);
        }
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        Thread thread = new Thread(this);
        thread.start();
    }

    public VncCanvas(VncViewer vncViewer) throws IOException {
        this(vncViewer, 0, 0);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.scaledWidth, this.scaledHeight);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.scaledWidth, this.scaledHeight);
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.scaledWidth, this.scaledHeight);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        int n;
        int n2;
        Rectangle rectangle;
        Image image = this.memImage;
        synchronized (image) {
            if (this.rfb.framebufferWidth == this.scaledWidth) {
                graphics.drawImage(this.memImage, 0, 0, null);
            } else {
                this.paintScaledFrameBuffer(graphics);
            }
        }
        if (this.viewer.showRemoteCursor && this.showSoftCursor && (rectangle = new Rectangle(n2 = this.cursorX - this.hotX, n = this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight)).intersects(graphics.getClipBounds())) {
            graphics.drawImage(this.softCursor, n2, n, null);
        }
        if (this.isInSelectionMode()) {
            Rectangle rectangle2 = this.getSelection(true);
            if (rectangle2.width > 0 && rectangle2.height > 0) {
                --rectangle2.width;
                --rectangle2.height;
                graphics.setXORMode(Color.yellow);
                graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
        }
    }

    public void paintScaledFrameBuffer(Graphics graphics) {
        graphics.drawImage(this.memImage, 0, 0, this.scaledWidth, this.scaledHeight, null);
    }

    public synchronized void enableInput(boolean bl) {
        if (bl && !this.inputEnabled) {
            this.inputEnabled = true;
            if (this.viewer.showControls) {
                this.viewer.buttonPanel.enableRemoteAccessControls(true);
            }
            this.createSoftCursor();
        } else if (!bl && this.inputEnabled) {
            this.inputEnabled = false;
            if (this.viewer.showControls) {
                this.viewer.buttonPanel.enableRemoteAccessControls(false);
            }
            this.createSoftCursor();
        }
    }

    public void setPixelFormat() throws IOException {
        if (this.viewer.options.eightBitColors) {
            this.rfb.writeSetPixelFormat(8, 8, false, true, 7, 7, 3, 0, 3, 6);
            this.bytesPixel = 1;
        } else {
            this.rfb.writeSetPixelFormat(32, 24, false, true, 255, 255, 255, 16, 8, 0);
            this.bytesPixel = 4;
        }
        this.updateFramebufferSize();
    }

    void setScalingFactor(int n) {
        this.scalingFactor = n;
        this.updateFramebufferSize();
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFramebufferSize() {
        int n = this.rfb.framebufferWidth;
        int n2 = this.rfb.framebufferHeight;
        if (this.viewer.options.autoScale) {
            if (this.viewer.inAnApplet) {
                this.maxWidth = this.viewer.getWidth();
                this.maxHeight = this.viewer.getHeight();
            } else if (this.viewer.vncFrame != null) {
                if (this.isFirstSizeAutoUpdate) {
                    this.isFirstSizeAutoUpdate = false;
                    Dimension dimension = this.viewer.vncFrame.getToolkit().getScreenSize();
                    this.maxWidth = (int)dimension.getWidth() - 100;
                    this.maxHeight = (int)dimension.getHeight() - 100;
                    this.viewer.vncFrame.setSize(this.maxWidth, this.maxHeight);
                } else {
                    this.viewer.desktopScrollPane.doLayout();
                    this.maxWidth = this.viewer.desktopScrollPane.getWidth();
                    this.maxHeight = this.viewer.desktopScrollPane.getHeight();
                }
            } else {
                this.maxWidth = n;
                this.maxHeight = n2;
            }
            int n3 = this.maxWidth * 100 / n;
            int n4 = this.maxHeight * 100 / n2;
            this.scalingFactor = Math.min(n3, n4);
            if (this.scalingFactor > 100) {
                this.scalingFactor = 100;
            }
            System.out.println("Scaling desktop at " + this.scalingFactor + "%");
        }
        this.scaledWidth = (n * this.scalingFactor + 50) / 100;
        this.scaledHeight = (n2 * this.scalingFactor + 50) / 100;
        if (this.memImage == null) {
            this.memImage = this.viewer.vncContainer.createImage(n, n2);
            this.memGraphics = this.memImage.getGraphics();
        } else if (this.memImage.getWidth(null) != n || this.memImage.getHeight(null) != n2) {
            Image image = this.memImage;
            synchronized (image) {
                this.memImage = this.viewer.vncContainer.createImage(n, n2);
                this.memGraphics = this.memImage.getGraphics();
            }
        }
        if (this.decoders != null) {
            for (int i = 0; i < this.decoders.length; ++i) {
                this.decoders[i].setBPP(this.bytesPixel);
                this.decoders[i].setFrameBufferSize(n, n2);
                this.decoders[i].setGraphics(this.memGraphics);
                this.decoders[i].update();
            }
        }
        if (this.viewer.inSeparateFrame) {
            if (this.viewer.desktopScrollPane != null) {
                if (!this.viewer.options.autoScale) {
                    this.resizeDesktopFrame();
                } else {
                    this.setSize(this.scaledWidth, this.scaledHeight);
                    this.viewer.desktopScrollPane.setSize(this.maxWidth + 200, this.maxHeight + 200);
                }
            }
        } else {
            this.setSize(this.scaledWidth, this.scaledHeight);
        }
        this.viewer.forceSize();
        this.viewer.moveFocusToDesktop();
    }

    void resizeDesktopFrame() {
        Dimension dimension;
        this.setSize(this.scaledWidth, this.scaledHeight);
        Insets insets = this.viewer.desktopScrollPane.getInsets();
        this.viewer.desktopScrollPane.setSize(this.scaledWidth + 2 * Math.min(insets.left, insets.right), this.scaledHeight + 2 * Math.min(insets.top, insets.bottom));
        this.viewer.vncFrame.pack();
        Dimension dimension2 = this.viewer.vncFrame.getToolkit().getScreenSize();
        Dimension dimension3 = dimension = this.viewer.vncFrame.getSize();
        dimension2.height -= 30;
        dimension2.width -= 30;
        boolean bl = false;
        if (dimension.height > dimension2.height) {
            dimension3.height = dimension2.height;
            bl = true;
        }
        if (dimension.width > dimension2.width) {
            dimension3.width = dimension2.width;
            bl = true;
        }
        if (bl) {
            this.viewer.vncFrame.setSize(dimension3);
        }
        this.viewer.desktopScrollPane.doLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void processNormalProtocol() throws Exception {
        this.viewer.checkRecordingStatus();
        this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, false);
        if (this.viewer.options.continuousUpdates) {
            this.rfb.tryEnableContinuousUpdates(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight);
        }
        this.resetStats();
        var1_1 = false;
        block23: while (true) {
            var2_2 = this.rfb.readServerMessageType();
            switch (var2_2) {
                case 0: {
                    if (this.statNumUpdates == (long)this.viewer.debugStatsExcludeUpdates && !var1_1) {
                        this.resetStats();
                        var1_1 = true;
                    } else if (this.statNumUpdates == (long)this.viewer.debugStatsMeasureUpdates && var1_1) {
                        this.viewer.disconnect();
                    }
                    this.rfb.readFramebufferUpdate();
                    ++this.statNumUpdates;
                    var3_3 = false;
                    for (var4_4 = 0; var4_4 < this.rfb.updateNRects; ++var4_4) {
                        this.rfb.readFramebufferUpdateRectHdr();
                        ++this.statNumTotalRects;
                        var5_5 = this.rfb.updateRectX;
                        var6_7 = this.rfb.updateRectY;
                        var7_10 = this.rfb.updateRectW;
                        var8_13 = this.rfb.updateRectH;
                        if (this.rfb.updateRectEncoding == -224) break;
                        if (this.rfb.updateRectEncoding == -223) {
                            if (this.viewer.setServerSize) {
                                if (var7_10 == this.rfb.framebufferWidth && var8_13 == this.rfb.framebufferHeight) {
                                    System.out.println("SetServerSize: New size is right.");
                                    this.viewer.setServerSize = false;
                                } else {
                                    System.out.println("SetServerSize: Requesting server resize.");
                                    this.viewer.requestResize(this.rfb.framebufferWidth, this.rfb.framebufferHeight);
                                    break;
                                }
                            }
                            this.rfb.setFramebufferSize(var7_10, var8_13);
                            this.updateFramebufferSize();
                            break;
                        }
                        if (this.rfb.updateRectEncoding == -240) ** GOTO lbl46
                        if (this.rfb.updateRectEncoding != -239) ** GOTO lbl48
lbl46:
                        // 2 sources

                        this.handleCursorShapeUpdate(this.rfb.updateRectEncoding, var5_5, var6_7, var7_10, var8_13);
                        continue;
lbl48:
                        // 1 sources

                        if (this.rfb.updateRectEncoding == -232) {
                            this.softCursorMove(var5_5, var6_7);
                            var3_3 = true;
                            continue;
                        }
                        var9_14 = this.rfb.getNumBytesRead();
                        this.rfb.startTiming();
                        switch (this.rfb.updateRectEncoding) {
                            case 0: {
                                ++this.statNumRectsRaw;
                                this.handleRawRect(var5_5, var6_7, var7_10, var8_13);
                                break;
                            }
                            case 1: {
                                ++this.statNumRectsCopy;
                                this.handleCopyRect(var5_5, var6_7, var7_10, var8_13);
                                break;
                            }
                            case 2: {
                                this.handleRRERect(var5_5, var6_7, var7_10, var8_13);
                                break;
                            }
                            case 4: {
                                this.handleCoRRERect(var5_5, var6_7, var7_10, var8_13);
                                break;
                            }
                            case 5: {
                                ++this.statNumRectsHextile;
                                this.handleHextileRect(var5_5, var6_7, var7_10, var8_13);
                                break;
                            }
                            case 16: {
                                ++this.statNumRectsZRLE;
                                this.handleZRLERect(var5_5, var6_7, var7_10, var8_13);
                                break;
                            }
                            case 6: {
                                this.handleZlibRect(var5_5, var6_7, var7_10, var8_13);
                                break;
                            }
                            case 7: {
                                if (this.tightDecoder != null) {
                                    this.statNumRectsTightJPEG = this.tightDecoder.getNumJPEGRects();
                                }
                                ++this.statNumRectsTight;
                                this.handleTightRect(var5_5, var6_7, var7_10, var8_13);
                                break;
                            }
                            default: {
                                throw new Exception("Unknown RFB rectangle encoding " + this.rfb.updateRectEncoding);
                            }
                        }
                        this.rfb.stopTiming();
                        ++this.statNumPixelRects;
                        this.statNumBytesDecoded += (long)(var7_10 * var8_13 * this.bytesPixel);
                        this.statNumBytesEncoded += (long)((int)(this.rfb.getNumBytesRead() - var9_14));
                    }
                    var4_4 = 0;
                    if (this.viewer.checkRecordingStatus()) {
                        var4_4 = 1;
                    }
                    if (this.viewer.deferUpdateRequests > 0 && this.rfb.available() == 0 && !var3_3) {
                        var5_6 = this.rfb;
                        synchronized (var5_6) {
                            try {
                                this.rfb.wait(this.viewer.deferUpdateRequests);
                            }
                            catch (InterruptedException var6_8) {
                                // empty catch block
                            }
                        }
                    }
                    this.viewer.autoSelectEncodings();
                    if (this.viewer.options.eightBitColors != (this.bytesPixel == 1)) {
                        if (!this.rfb.continuousUpdatesAreActive()) {
                            this.setPixelFormat();
                            var4_4 = 1;
                        } else {
                            this.rfb.tryDisableContinuousUpdates();
                            continue block23;
                        }
                    }
                    if ((var5_5 = (int)this.viewer.options.continuousUpdates) != this.rfb.continuousUpdatesAreActive()) {
                        if (var5_5 != 0) {
                            this.rfb.tryEnableContinuousUpdates(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight);
                        } else {
                            this.rfb.tryDisableContinuousUpdates();
                        }
                    }
                    if (var4_4 != 0) {
                        this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, false);
                        continue block23;
                    }
                    if (this.rfb.continuousUpdatesAreActive()) continue block23;
                    this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, true);
                    continue block23;
                }
                case 1: {
                    throw new Exception("Can't handle SetColourMapEntries message");
                }
                case 2: {
                    Toolkit.getDefaultToolkit().beep();
                    continue block23;
                }
                case 3: {
                    var6_9 = this.rfb.readServerCutText();
                    this.viewer.clipboard.setCutText(var6_9);
                    continue block23;
                }
                case 150: {
                    if (!this.rfb.continuousUpdatesAreActive()) continue block23;
                    this.rfb.endOfContinuousUpdates();
                    var7_11 = true;
                    if (this.viewer.options.eightBitColors != (this.bytesPixel == 1)) {
                        this.setPixelFormat();
                        var7_11 = false;
                    }
                    this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, var7_11);
                    continue block23;
                }
                case 32: {
                    var7_12 = this.rfb.readClientAction();
                    this.viewer.clientAction(var7_12);
                    continue block23;
                }
            }
            break;
        }
        throw new Exception("Unknown RFB message type " + var2_2);
    }

    void handleRawRect(int n, int n2, int n3, int n4) throws IOException, Exception {
        this.handleRawRect(n, n2, n3, n4, true);
    }

    void handleRawRect(int n, int n2, int n3, int n4, boolean bl) throws IOException, Exception {
        this.rawDecoder.handleRect(n, n2, n3, n4);
        if (bl) {
            this.scheduleRepaint(n, n2, n3, n4);
        }
    }

    void handleCopyRect(int n, int n2, int n3, int n4) throws IOException {
        this.copyRectDecoder.handleRect(n, n2, n3, n4);
        this.scheduleRepaint(n, n2, n3, n4);
    }

    void handleRRERect(int n, int n2, int n3, int n4) throws IOException {
        this.rreDecoder.handleRect(n, n2, n3, n4);
        this.scheduleRepaint(n, n2, n3, n4);
    }

    void handleCoRRERect(int n, int n2, int n3, int n4) throws IOException {
        this.correDecoder.handleRect(n, n2, n3, n4);
        this.scheduleRepaint(n, n2, n3, n4);
    }

    void handleHextileRect(int n, int n2, int n3, int n4) throws IOException, Exception {
        this.hextileDecoder.handleRect(n, n2, n3, n4);
    }

    void handleZRLERect(int n, int n2, int n3, int n4) throws Exception {
        this.zrleDecoder.handleRect(n, n2, n3, n4);
        this.scheduleRepaint(n, n2, n3, n4);
    }

    void handleZlibRect(int n, int n2, int n3, int n4) throws Exception {
        this.zlibDecoder.handleRect(n, n2, n3, n4);
        this.scheduleRepaint(n, n2, n3, n4);
    }

    void handleTightRect(int n, int n2, int n3, int n4) throws Exception {
        this.tightDecoder.handleRect(n, n2, n3, n4);
        this.scheduleRepaint(n, n2, n3, n4);
    }

    public void scheduleRepaint(int n, int n2, int n3, int n4) {
        if (this.rfb.framebufferWidth == this.scaledWidth) {
            this.repaint(this.viewer.deferScreenUpdates, n, n2, n3, n4);
        } else {
            int n5 = n * this.scalingFactor / 100;
            int n6 = n2 * this.scalingFactor / 100;
            int n7 = ((n + n3) * this.scalingFactor + 49) / 100 - n5 + 1;
            int n8 = ((n2 + n4) * this.scalingFactor + 49) / 100 - n6 + 1;
            this.repaint(this.viewer.deferScreenUpdates, n5, n6, n7, n8);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.processLocalKeyEvent(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.processLocalKeyEvent(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.processLocalMouseEvent(mouseEvent, false);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.processLocalMouseEvent(mouseEvent, false);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.processLocalMouseEvent(mouseEvent, true);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.processLocalMouseEvent(mouseEvent, true);
    }

    private synchronized void trySendPointerEvent() {
        if (this.needToSendMouseEvent && this.mouseEvent != null) {
            this.sendMouseEvent(this.mouseEvent);
            this.needToSendMouseEvent = false;
            this.lastMouseEventSendTime = System.currentTimeMillis();
        }
    }

    public void run() {
        while (true) {
            this.trySendPointerEvent();
            try {
                Thread.sleep(1000L / this.mouseMaxFreq);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLocalKeyEvent(KeyEvent keyEvent) {
        if (this.viewer.rfb != null && this.rfb.inNormalProtocol) {
            if (!this.inputEnabled) {
                if ((keyEvent.getKeyChar() == 'r' || keyEvent.getKeyChar() == 'R') && keyEvent.getID() == 401) {
                    try {
                        this.rfb.writeFramebufferUpdateRequest(0, 0, this.rfb.framebufferWidth, this.rfb.framebufferHeight, false);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            } else {
                RfbProto rfbProto = this.rfb;
                synchronized (rfbProto) {
                    try {
                        this.rfb.writeKeyEvent(keyEvent);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    this.rfb.notify();
                }
            }
        }
        keyEvent.consume();
    }

    private void processLocalMouseEvent(MouseEvent mouseEvent, boolean bl) {
        if (this.viewer.rfb != null && this.rfb.inNormalProtocol) {
            if (!this.inSelectionMode) {
                if (this.inputEnabled) {
                    if (!bl) {
                        this.sendMouseEvent(mouseEvent);
                    } else {
                        this.softCursorMove(mouseEvent.getX(), mouseEvent.getY());
                        this.mouseEvent = mouseEvent;
                        this.needToSendMouseEvent = true;
                    }
                }
            } else {
                this.handleSelectionMouseEvent(mouseEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMouseEvent(MouseEvent mouseEvent) {
        if (this.rfb.framebufferWidth != this.scaledWidth) {
            int n = (mouseEvent.getX() * 100 + this.scalingFactor / 2) / this.scalingFactor;
            int n2 = (mouseEvent.getY() * 100 + this.scalingFactor / 2) / this.scalingFactor;
            mouseEvent.translatePoint(n - mouseEvent.getX(), n2 - mouseEvent.getY());
        }
        RfbProto rfbProto = this.rfb;
        synchronized (rfbProto) {
            try {
                this.rfb.writePointerEvent(mouseEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.rfb.notify();
            this.lastMouseEventSendTime = System.currentTimeMillis();
        }
    }

    void resetStats() {
        this.statStartTime = System.currentTimeMillis();
        this.statNumUpdates = 0L;
        this.statNumTotalRects = 0L;
        this.statNumPixelRects = 0L;
        this.statNumRectsTight = 0L;
        this.statNumRectsTightJPEG = 0L;
        this.statNumRectsZRLE = 0L;
        this.statNumRectsHextile = 0L;
        this.statNumRectsRaw = 0L;
        this.statNumRectsCopy = 0L;
        this.statNumBytesEncoded = 0L;
        this.statNumBytesDecoded = 0L;
        if (this.tightDecoder != null) {
            this.tightDecoder.setNumJPEGRects(0);
            this.tightDecoder.setNumTightRects(0);
        }
    }

    synchronized void handleCursorShapeUpdate(int n, int n2, int n3, int n4, int n5) throws IOException {
        this.softCursorFree();
        if (n4 * n5 == 0) {
            return;
        }
        if (this.viewer.options.ignoreCursorUpdates) {
            int n6 = (n4 + 7) / 8;
            int n7 = n6 * n5;
            if (n == -240) {
                this.rfb.skipBytes(6 + n7 * 2);
            } else {
                this.rfb.skipBytes(n4 * n5 * this.bytesPixel + n7);
            }
            return;
        }
        this.softCursorSource = this.decodeCursorShape(n, n4, n5);
        this.origCursorWidth = n4;
        this.origCursorHeight = n5;
        this.origHotX = n2;
        this.origHotY = n3;
        this.createSoftCursor();
        this.localCursor = this.localCursorImage != null ? Toolkit.getDefaultToolkit().createCustomCursor(this.localCursorImage, new Point(n2, n3), "java") : Cursor.getDefaultCursor();
        if (this.viewer.showLocalCursor) {
            this.setCursor(this.localCursor);
        }
        this.showSoftCursor = true;
        if (this.viewer.showRemoteCursor) {
            this.repaint(this.viewer.deferCursorUpdates, this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
        }
    }

    synchronized MemoryImageSource decodeCursorShape(int n, int n2, int n3) throws IOException {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Object[] objectArray;
        Object object;
        int n9 = (n2 + 7) / 8;
        int n10 = n9 * n3;
        int[] nArray = new int[n2 * n3];
        if (n == -240) {
            object = new byte[6];
            this.rfb.readFully((byte[])object);
            objectArray = new int[]{0xFF000000 | (object[3] & 0xFF) << 16 | (object[4] & 0xFF) << 8 | object[5] & 0xFF, 0xFF000000 | (object[0] & 0xFF) << 16 | (object[1] & 0xFF) << 8 | object[2] & 0xFF};
            byte[] byArray = new byte[n10];
            this.rfb.readFully(byArray);
            byte[] byArray2 = new byte[n10];
            this.rfb.readFully(byArray2);
            int n11 = 0;
            for (n8 = 0; n8 < n3; ++n8) {
                int n12;
                for (n7 = 0; n7 < n2 / 8; ++n7) {
                    n6 = byArray[n8 * n9 + n7];
                    n5 = byArray2[n8 * n9 + n7];
                    for (n4 = 7; n4 >= 0; --n4) {
                        n12 = (n5 >> n4 & 1) != 0 ? objectArray[n6 >> n4 & 1] : 0;
                        nArray[n11++] = n12;
                    }
                }
                for (n4 = 7; n4 >= 8 - n2 % 8; --n4) {
                    n12 = (byArray2[n8 * n9 + n7] >> n4 & 1) != 0 ? objectArray[byArray[n8 * n9 + n7] >> n4 & 1] : 0;
                    nArray[n11++] = n12;
                }
            }
        } else {
            object = new byte[n2 * n3 * this.bytesPixel];
            this.rfb.readFully((byte[])object);
            objectArray = new byte[n10];
            this.rfb.readFully((byte[])objectArray);
            n4 = 0;
            for (n5 = 0; n5 < n3; ++n5) {
                for (n6 = 0; n6 < n2 / 8; ++n6) {
                    byte by = objectArray[n5 * n9 + n6];
                    for (n7 = 7; n7 >= 0; --n7) {
                        n8 = (by >> n7 & 1) != 0 ? (this.bytesPixel == 1 ? this.cm8.getRGB(object[n4]) : 0xFF000000 | (object[n4 * 4 + 2] & 0xFF) << 16 | (object[n4 * 4 + 1] & 0xFF) << 8 | object[n4 * 4] & 0xFF) : 0;
                        nArray[n4++] = n8;
                    }
                }
                for (n7 = 7; n7 >= 8 - n2 % 8; --n7) {
                    n8 = (objectArray[n5 * n9 + n6] >> n7 & 1) != 0 ? (this.bytesPixel == 1 ? this.cm8.getRGB(object[n4]) : 0xFF000000 | (object[n4 * 4 + 2] & 0xFF) << 16 | (object[n4 * 4 + 1] & 0xFF) << 8 | object[n4 * 4] & 0xFF) : 0;
                    nArray[n4++] = n8;
                }
            }
        }
        object = Toolkit.getDefaultToolkit().getBestCursorSize(n2, n3);
        if (object.width >= n2 && object.height >= n3) {
            objectArray = new int[object.width * object.height];
            int n13 = 0;
            n6 = 0;
            for (int i = 0; i < n3; ++i) {
                System.arraycopy(nArray, n13, objectArray, n6, n2);
                n13 += n2;
                n6 += object.width;
            }
            this.localCursorSource = new MemoryImageSource(object.width, object.height, (int[])objectArray, 0, object.width);
        } else {
            this.localCursorSource = null;
        }
        return new MemoryImageSource(n2, n3, nArray, 0, n2);
    }

    synchronized void createSoftCursor() {
        if (this.softCursorSource == null) {
            return;
        }
        int n = this.viewer.options.scaleCursor;
        if (n == 0 || !this.inputEnabled) {
            n = 100;
        }
        int n2 = this.cursorX - this.hotX;
        int n3 = this.cursorY - this.hotY;
        int n4 = this.cursorWidth;
        int n5 = this.cursorHeight;
        this.cursorWidth = (this.origCursorWidth * n + 50) / 100;
        this.cursorHeight = (this.origCursorHeight * n + 50) / 100;
        this.hotX = (this.origHotX * n + 50) / 100;
        this.hotY = (this.origHotY * n + 50) / 100;
        this.softCursor = Toolkit.getDefaultToolkit().createImage(this.softCursorSource);
        this.localCursorImage = this.localCursorSource != null ? Toolkit.getDefaultToolkit().createImage(this.localCursorSource) : null;
        if (n != 100) {
            this.softCursor = this.softCursor.getScaledInstance(this.cursorWidth, this.cursorHeight, 4);
        }
        if (this.viewer.showRemoteCursor && this.showSoftCursor) {
            n2 = Math.min(n2, this.cursorX - this.hotX);
            n3 = Math.min(n3, this.cursorY - this.hotY);
            n4 = Math.max(n4, this.cursorWidth);
            n5 = Math.max(n5, this.cursorHeight);
            this.repaint(this.viewer.deferCursorUpdates, n2, n3, n4, n5);
        }
    }

    synchronized void softCursorMove(int n, int n2) {
        int n3 = this.cursorX;
        int n4 = this.cursorY;
        this.cursorX = n;
        this.cursorY = n2;
        if (this.viewer.showRemoteCursor && this.showSoftCursor) {
            this.repaint(this.viewer.deferCursorUpdates, n3 - this.hotX, n4 - this.hotY, this.cursorWidth, this.cursorHeight);
            this.repaint(this.viewer.deferCursorUpdates, this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
        }
    }

    synchronized void softCursorFree() {
        if (this.showSoftCursor) {
            this.showSoftCursor = false;
            this.softCursor = null;
            this.softCursorSource = null;
            if (this.viewer.showRemoteCursor) {
                this.repaint(this.viewer.deferCursorUpdates, this.cursorX - this.hotX, this.cursorY - this.hotY, this.cursorWidth, this.cursorHeight);
            }
        }
    }

    private synchronized void resetSelection() {
        this.inSelectionMode = false;
        this.selectionStart = new Point(0, 0);
        this.selectionEnd = new Point(0, 0);
        this.savedCursor = this.getCursor();
    }

    public boolean isInSelectionMode() {
        return this.inSelectionMode;
    }

    private synchronized Rectangle getSelection(boolean bl) {
        int n;
        int n2 = this.selectionStart.x;
        int n3 = this.selectionEnd.x;
        int n4 = this.selectionStart.y;
        int n5 = this.selectionEnd.y;
        if (n3 < n2) {
            n = n2;
            n2 = n3;
            n3 = n;
        }
        if (n5 < n4) {
            n = n4;
            n4 = n5;
            n5 = n;
        }
        if (n2 != n3 && n4 != n5) {
            ++n3;
            ++n5;
        }
        if (this.rfb.framebufferWidth != this.scaledWidth) {
            n2 = (n2 * 100 + this.scalingFactor / 2) / this.scalingFactor;
            n4 = (n4 * 100 + this.scalingFactor / 2) / this.scalingFactor;
            n3 = (n3 * 100 + this.scalingFactor / 2) / this.scalingFactor;
            n5 = (n5 * 100 + this.scalingFactor / 2) / this.scalingFactor;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n3 > this.rfb.framebufferWidth) {
            n3 = this.rfb.framebufferWidth;
        }
        if (n5 > this.rfb.framebufferHeight) {
            n5 = this.rfb.framebufferHeight;
        }
        n = (n3 - n2 + 8) / 16;
        if (this.selectionStart.x <= this.selectionEnd.x) {
            n3 = n2 + n * 16;
            if (n3 > this.rfb.framebufferWidth) {
                n3 -= 16;
            }
        } else {
            n2 = n3 - n * 16;
            if (n2 < 0) {
                n2 += 16;
            }
        }
        int n6 = (n5 - n4 + 4) / 8;
        if (this.selectionStart.y <= this.selectionEnd.y) {
            n5 = n4 + n6 * 8;
            if (n5 > this.rfb.framebufferHeight) {
                n5 -= 8;
            }
        } else {
            n4 = n5 - n6 * 8;
            if (n4 < 0) {
                n4 += 8;
            }
        }
        if (bl && this.rfb.framebufferWidth != this.scaledWidth) {
            n2 = (n2 * this.scalingFactor + 50) / 100;
            n4 = (n4 * this.scalingFactor + 50) / 100;
            n3 = (n3 * this.scalingFactor + 50) / 100;
            n5 = (n5 * this.scalingFactor + 50) / 100;
        }
        return new Rectangle(n2, n4, n3 - n2, n5 - n4);
    }

    public synchronized void enableSelection(boolean bl) {
        if (bl && !this.inSelectionMode) {
            this.inSelectionMode = true;
            this.savedCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(1));
            this.repaint();
        } else if (!bl && this.inSelectionMode) {
            this.inSelectionMode = false;
            this.setCursor(this.savedCursor);
            this.repaint();
        }
    }

    private synchronized void handleSelectionMouseEvent(MouseEvent mouseEvent) {
        boolean bl;
        int n = mouseEvent.getID();
        boolean bl2 = bl = (mouseEvent.getModifiers() & 0x10) != 0;
        if (n == 501 && bl) {
            this.selectionStart = this.selectionEnd = mouseEvent.getPoint();
            this.repaint();
        }
        if (n == 506 && bl) {
            this.selectionEnd = mouseEvent.getPoint();
            this.repaint();
        }
        if (n == 502 && bl) {
            try {
                this.rfb.trySendVideoSelection(this.getSelection(false));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

