<?php
/**
 * HUBzero CMS
 *
 * Copyright 2005-2015 HUBzero Foundation, LLC.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * HUBzero is a registered trademark of Purdue University.
 *
 * @package   hubzero-cms
 * @copyright Copyright 2005-2015 HUBzero Foundation, LLC.
 * @license   http://opensource.org/licenses/MIT MIT
 */

// No direct access
defined('_HZEXEC_') or die();
$this->css('search-enhanced');
$this->js('handlebars','system');
$this->js('moment.min', 'system');
$this->js('search1');

?>

<!-- start component output -->
<header id="content-header">
	<h2>Search</h2>
</header><!-- / #content-header -->

<section class="options section">
	<form action="/search/" method="get" class="container data-entry">
		<input class="entry-search-submit" type="submit" value="Search" />
		<fieldset class="entry-search">
			<legend>Search site</legend>
			<label for="terms">Search terms</label>
			<input type="text" name="terms" id="terms" value="<?php echo isset($this->terms) ? $this->terms : ''; ?>" placeholder="Enter keyword or phrase" />
		</fieldset>
	</form>

	<nav>
		<ul class="result-views">
			<li class="active"><a href="#">Content</a></li>
			<li><a href="#">Map</a></li>
		</ul>
	</nav>
</section>
<section class="main section">
	<div class="section-inner">
		<nav class="aside">
			<div class="container facet">
				<h3>Category</h3>
				<ul class="type-facets">
					<li>
						<a id="type-facet-all" class="active" href="/search/?type=all">All Categories <span class="item-count">0</span></a>
					</li>
					<div id="filters">
					</div>
				<script id="filter-template" type="text/x-handlebars-template">
					{{#each filters}}
						{{#if count}}
							<li>
								<a id="type-facet-{{type}}" href="{{{filter-apply type}}}">{{name}}<span class="item-count">{{count}}</span></a>
							</li>
					{{/if}}
					{{/each}}
				</script>
				</ul>
			</div><!-- / .container -->
		</nav><!-- / .aside -->

		<div class="subject">
			<div class="container">
				<div id="results" class="results list"><!-- add "tiled" to class for tiled view -->
				<script id="result-template" type="text/x-handlebars-template">
					{{#each results}}
					<div class="result">
						<div class="result-body">
							<h3 class="result-title">{{link url title}}</h3>
							<div class="result-extras">
								{{#if hubtype}}
									<span class="result-category">{{hubtype}}</span>
								{{/if}}
								{{#if date}}
									<span class="result-timestamp"><time datetime="{{date}}">{{formatDate date}}</time></span>
								{{/if}}

								{{#if author}}
									<span class="result-authors">
										<!-- generated by handlebars -->
										<!-- <span class="result-author">author</span> -->
										{{authorList author}}
									</span>
								{{/if}}
							</div><!-- /.result-extras -->

							<div class="result-snippet">
								{{{ snippet }}}
							</div>

							<div class="result-url">{{{link url url}}}</div>
							{{#if tags}}
							<ul class="tags">
									<!-- generated by handlebars -->
									<!-- <li><a class="tag" href="#">paleozoic</a></li> -->
									{{{tagcloud tags}}}
							</ul>
							{{/if}}
					<?php if (User::authorise('core.admin', 'com_users')): ?>
						<div class="adminbar">
							<a href="/search/manage/spam/{{id}}" class="mark-spam">mark as spam</a>
							<a href="/search/manage/suggestion/{{id}}" class="suggestion">report error</a>
						</div>
					<?php endif; ?>
						</div>
					</div>
					{{/each}}
				</script>
				</div>

				<form action="/search/" method="get">
					<nav class="pagination">
						<ul class="list-footer">
							<li class="counter">Results 1 - 2 of 2</li>
							<li class="pagination-start start">
								<span class="pagenav">Start</span>
							</li>
							<li class="pagination-prev prev">
								<span class="pagenav">Prev</span>
							</li>
							<li class="page"><strong>1</strong></li>
							<li class="pagination-next next">
								<span class="pagenav">Next</span>
							</li>
							<li class="pagination-end end">
								<span class="pagenav">End</span>
							</li>
						</ul>
						<input type="hidden" name="limitstart" value="0" />
					</nav>
					<input type="hidden" id="paginate-terms" name="terms" value="paleontology" />
					<input type="hidden" id="type" name="type" value="<?php echo $this->type; ?>"/>
					<div class="clearfix"></div>
				</form>
			</div><!-- / .container -->
		</div><!-- / .subject -->
	</div>
</section><!-- / .main section -->

<!-- end component output -->
