<?php
/**
 * HUBzero CMS
 *
 * Copyright 2005-2015 HUBzero Foundation, LLC.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * HUBzero is a registered trademark of Purdue University.
 *
 * @package   hubzero-cms
 * @copyright Copyright 2005-2015 HUBzero Foundation, LLC.
 * @license   http://opensource.org/licenses/MIT MIT
 */

namespace Bootstrap\Files;

use Hubzero\Base\Middleware;
use Hubzero\Http\Request;
use Hubzero\Content\Moderator;

/**
 * Token based authentication service provider
 */
class AuthServiceProvider extends Middleware
{
	/**
	 * Handle request in stack
	 * 
	 * @param   object  $request  Request
	 * @return  mixed
	 */
	public function handle(Request $request)
	{
		$response = $this->next($request);

		// Get the referer to parse for the applicable app
		$referer = $request->header('referer');
		$app     = Request::create($referer)->segment(1, 'site');
		$app     = (in_array($app, ['site', 'administrator'])) ? $app : 'site';

		// Get secret and session name manually
		$secret      = $this->app['config']->get('secret');
		$cookie_name = md5(md5($secret . $app));
		$session_id  = $request->getVar($cookie_name, false, 'COOKIE');

		// Build moderator
		$identifier = $request->segment(2);
		$moderator  = new Moderator($identifier, $session_id, $secret);

		if (!$moderator->validateToken())
		{
			header('HTTP/1.1 401 You don\'t have permission to do this');
			exit();
		}

		$this->app['moderator'] = $moderator;

		return $response;
	}
}
