/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;

public class HextileDecoder
extends RawDecoder {
    static final int EncodingHextile = 5;
    static final int HextileRaw = 1;
    static final int HextileBackgroundSpecified = 2;
    static final int HextileForegroundSpecified = 4;
    static final int HextileAnySubrects = 8;
    static final int HextileSubrectsColoured = 16;
    private Color hextile_bg;
    private Color hextile_fg;
    private Repaintable repainableControl = null;

    public HextileDecoder(Graphics graphics, RfbInputStream rfbInputStream) {
        super(graphics, rfbInputStream);
    }

    public HextileDecoder(Graphics graphics, RfbInputStream rfbInputStream, int n, int n2) {
        super(graphics, rfbInputStream, n, n2);
    }

    public void setRepainableControl(Repaintable repaintable) {
        this.repainableControl = repaintable;
    }

    public void handleRect(int n, int n2, int n3, int n4) throws IOException, Exception {
        if (this.dos != null) {
            this.dos.writeInt(5);
        }
        this.hextile_bg = new Color(0);
        this.hextile_fg = new Color(0);
        for (int i = n2; i < n2 + n4; i += 16) {
            int n5 = 16;
            if (n2 + n4 - i < 16) {
                n5 = n2 + n4 - i;
            }
            for (int j = n; j < n + n3; j += 16) {
                int n6 = 16;
                if (n + n3 - j < 16) {
                    n6 = n + n3 - j;
                }
                this.handleHextileSubrect(j, i, n6, n5);
            }
            if (this.repainableControl == null) continue;
            this.repainableControl.scheduleRepaint(n, n2, n3, n4);
        }
        if (this.repainableControl != null) {
            this.repainableControl.scheduleRepaint(n, n2, n3, n4);
        }
    }

    private void handleHextileSubrect(int n, int n2, int n3, int n4) throws IOException, Exception {
        int n5 = this.rfbis.readU8();
        if (this.dos != null) {
            this.dos.writeByte((byte)n5);
        }
        if ((n5 & 1) != 0) {
            super.enableEncodingRecordWritting(false);
            super.handleRect(n, n2, n3, n4);
            super.handleUpdatedPixels(n, n2, n3, n4);
            super.enableEncodingRecordWritting(true);
            return;
        }
        byte[] byArray = new byte[this.bytesPerPixel];
        if ((n5 & 2) != 0) {
            this.rfbis.readFully(byArray);
            this.hextile_bg = this.bytesPerPixel == 1 ? this.getColor256()[byArray[0] & 0xFF] : new Color(byArray[2] & 0xFF, byArray[1] & 0xFF, byArray[0] & 0xFF);
            if (this.dos != null) {
                this.dos.write(byArray);
            }
        }
        this.graphics.setColor(this.hextile_bg);
        this.graphics.fillRect(n, n2, n3, n4);
        if ((n5 & 4) != 0) {
            this.rfbis.readFully(byArray);
            this.hextile_fg = this.bytesPerPixel == 1 ? this.getColor256()[byArray[0] & 0xFF] : new Color(byArray[2] & 0xFF, byArray[1] & 0xFF, byArray[0] & 0xFF);
            if (this.dos != null) {
                this.dos.write(byArray);
            }
        }
        if ((n5 & 8) == 0) {
            return;
        }
        int n6 = this.rfbis.readU8();
        int n7 = n6 * 2;
        if ((n5 & 0x10) != 0) {
            n7 += n6 * this.bytesPerPixel;
        }
        byte[] byArray2 = new byte[n7];
        this.rfbis.readFully(byArray2);
        if (this.dos != null) {
            this.dos.writeByte((byte)n6);
            this.dos.write(byArray2);
        }
        int n8 = 0;
        if ((n5 & 0x10) == 0) {
            this.graphics.setColor(this.hextile_fg);
            for (int i = 0; i < n6; ++i) {
                int n9 = byArray2[n8++] & 0xFF;
                int n10 = byArray2[n8++] & 0xFF;
                int n11 = n + (n9 >> 4);
                int n12 = n2 + (n9 & 0xF);
                int n13 = (n10 >> 4) + 1;
                int n14 = (n10 & 0xF) + 1;
                this.graphics.fillRect(n11, n12, n13, n14);
            }
        } else if (this.bytesPerPixel == 1) {
            for (int i = 0; i < n6; ++i) {
                this.hextile_fg = this.getColor256()[byArray2[n8++] & 0xFF];
                int n15 = byArray2[n8++] & 0xFF;
                int n16 = byArray2[n8++] & 0xFF;
                int n17 = n + (n15 >> 4);
                int n18 = n2 + (n15 & 0xF);
                int n19 = (n16 >> 4) + 1;
                int n20 = (n16 & 0xF) + 1;
                this.graphics.setColor(this.hextile_fg);
                this.graphics.fillRect(n17, n18, n19, n20);
            }
        } else {
            for (int i = 0; i < n6; ++i) {
                this.hextile_fg = new Color(byArray2[n8 + 2] & 0xFF, byArray2[n8 + 1] & 0xFF, byArray2[n8] & 0xFF);
                n8 += 4;
                int n21 = byArray2[n8++] & 0xFF;
                int n22 = byArray2[n8++] & 0xFF;
                int n23 = n + (n21 >> 4);
                int n24 = n2 + (n21 & 0xF);
                int n25 = (n22 >> 4) + 1;
                int n26 = (n22 & 0xF) + 1;
                this.graphics.setColor(this.hextile_fg);
                this.graphics.fillRect(n23, n24, n25, n26);
            }
        }
    }
}

