<?php
/**
 * HUBzero CMS
 *
 * Copyright 2005-2015 HUBzero Foundation, LLC.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * HUBzero is a registered trademark of Purdue University.
 *
 * @package   hubzero-cms
 * @author    Shawn Rice <zooley@purdue.edu>
 * @copyright Copyright 2005-2015 HUBzero Foundation, LLC.
 * @license   http://opensource.org/licenses/MIT MIT
 */

// No direct access
defined('_HZEXEC_') or die();

/**
 * Members Plugin class for courses
 */
class plgGroupsCourses extends \Hubzero\Plugin\Plugin
{
	/**
	 * Affects constructor behavior. If true, language files will be loaded automatically.
	 *
	 * @var    boolean
	 */
	protected $_autoloadLanguage = true;

	/**
	 * Return the alias and name for this category of content
	 *
	 * @return     array
	 */
	public function &onGroupAreas()
	{
		$area = array(
			'name'             => $this->_name,
			'title'            => Lang::txt('PLG_GROUPS_COURSES'),
			'default_access'   => $this->params->get('plugin_access', 'anyone'),
			'display_menu_tab' => $this->params->get('display_tab', 1),
			'icon'             => 'f09c'
		);
		return $area;
	}

	/**
	 * Return data on a group view (this will be some form of HTML)
	 *
	 * @param      object  $group      Current group
	 * @param      string  $option     Name of the component
	 * @param      string  $authorized User's authorization level
	 * @param      integer $limit      Number of records to pull
	 * @param      integer $limitstart Start of records to pull
	 * @param      string  $action     Action to perform
	 * @param      array   $access     What can be accessed
	 * @param      array   $areas      Active area(s)
	 * @return     array
	 */
	public function onGroup($group, $option, $authorized, $limit=0, $limitstart=0, $action='', $access, $areas=null)
	{
		$return = 'html';
		$active = $this->_name;
		$active_real = 'discussion';

		// The output array we're returning
		$arr = array(
			'html'=>'',
			'name' => $active
		);

		//get this area details
		$this_area = $this->onGroupAreas();

		// Check if our area is in the array of areas we want to return results for
		if (is_array($areas) && $limit)
		{
			if (!in_array($this_area['name'], $areas))
			{
				$return = 'metadata';
			}
		}

		$this->group    = $group;
		$this->database = App::get('db');

		require_once(PATH_CORE . DS . 'components' . DS . 'com_courses' . DS . 'models' . DS . 'courses.php');
		$model = \Components\Courses\Models\Courses::getInstance();

		$filters = array(
			'group'    => $group->get('cn'),
			'group_id' => $group->get('gidNumber'),
			'count'    => true
		);

		$arr['metadata']['count'] = $model->courses($filters);

		// Build the HTML
		if ($return == 'html')
		{
			$view = $this->view('default', 'display');
			$view->option = $option;
			$view->group  = $group;

			$view->filters = $filters;
			$view->filters['count'] = false;
			$view->filters['limit'] = Request::getState(
				$option . '.plugin.courses.limit',
				'limit',
				Config::get('list_limit'),
				'int'
			);
			$view->filters['start'] = Request::getState(
				$option . '.plugin.courses.limitstart',
				'limitstart',
				0,
				'int'
			);
			$view->filters['sortby'] = Request::getState(
				$option . '.plugin.courses.sortby',
				'sortby',
				''
			);
			$view->filters['search'] = Request::getState(
				$option . '.plugin.courses.search',
				'search',
				''
			);
			$view->filters['index'] = '';
			$view->filters['tag'] = '';

			if (!in_array($view->filters['sortby'], array('alias', 'title', 'popularity')))
			{
				$view->filters['sortby'] = 'title';
			}
			switch ($view->filters['sortby'])
			{
				case 'popularity':
					$view->filters['sort']  = 'students';
					$view->filters['sort_Dir'] = 'DESC';
				break;
				case 'title':
				case 'alias':
				default:
					$view->filters['sort']  = $view->filters['sortby'];
					$view->filters['sort_Dir'] = 'ASC';
				break;
			}

			$view->total   = $arr['metadata']['count'];
			$view->results = $model->courses($view->filters);

			$arr['html'] = $view->loadTemplate();
		}

		return $arr;
	}
}
