<?php
/**
 * HUBzero CMS
 *
 * Copyright 2005-2015 Purdue University. All rights reserved.
 *
 * This file is part of: The HUBzero(R) Platform for Scientific Collaboration
 *
 * The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
 * software: you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * HUBzero is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * HUBzero is a registered trademark of Purdue University.
 *
 * @package   hubzero-cms
 * @author    Shawn Rice <zooley@purdue.edu>
 * @copyright Copyright 2005-2015 Purdue University. All rights reserved.
 * @license   http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
 */

// No direct access
defined('_HZEXEC_') or die();

$sef = Route::url('index.php?option=' . $this->option . '&id=' . $this->resource->id . '&active=reviews');

$message  = Lang::txt('PLG_RESOURCES_REVIEWS_SOMEONE_POSTED_REVIEW') . "\r\n\r\n";
$message .= '----------------------------' . "\r\n";
$message .= Lang::txt('Resource:') . ' #' . $this->resource->id . ' - ' . stripslashes($this->resource->title) . "\r\n";
$message .= Lang::txt('Review posted on:') . ' ' . Date::of($this->review->created)->toLocal(Lang::txt('DATE_FORMAT_HZ1')) . "\r\n";
$message .= '----------------------------' . "\r\n\r\n";
$message .= preg_replace('#<br[\s/]?>#', "\r", strip_tags($this->review->comment)) . "\r\n\r\n";
$message .= Lang::txt('PLG_RESOURCES_REVIEWS_TO_VIEW_COMMENT') . "\r\n";
$message .= rtrim(Request::base(), '/') . '/' . ltrim($sef, '/') . "\r\n";

echo $message;
