<?php
/**
 * HUBzero CMS
 *
 * Copyright 2005-2015 Purdue University. All rights reserved.
 *
 * This file is part of: The HUBzero(R) Platform for Scientific Collaboration
 *
 * The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
 * software: you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * HUBzero is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * HUBzero is a registered trademark of Purdue University.
 *
 * @package   hubzero-cms
 * @author    Shawn Rice <zooley@purdue.edu>
 * @copyright Copyright 2005-2015 Purdue University. All rights reserved.
 * @license   http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
 */

defined('_HZEXEC_') or die();

?>
<table class="adminlist">
	<thead>
		<tr>
			<th scope="col">
				<?php echo Lang::txt('MOD_LATEST_LATEST_ITEMS'); ?>
			</th>
			<th scope="col">
				<?php echo Lang::txt('JSTATUS'); ?>
			</th>
			<th scope="col">
				<?php echo Lang::txt('MOD_LATEST_CREATED'); ?>
			</th>
			<th scope="col">
				<?php echo Lang::txt('MOD_LATEST_CREATED_BY');?>
			</th>
		</tr>
	</thead>
<?php if (count($list)) : ?>
	<tbody>
	<?php foreach ($list as $i => $item) : ?>
		<tr>
			<th scope="row">
				<?php if ($item->checked_out) : ?>
					<?php echo Html::grid('checkedout', $i, $item->editor, $item->checked_out_time); ?>
				<?php endif; ?>

				<?php if ($item->link) : ?>
					<a href="<?php echo $item->link; ?>">
						<?php echo $this->escape($item->title); ?>
					</a>
				<?php else :
					echo $this->escape($item->title);
				endif; ?>
			</th>
			<td class="center">
				<?php echo Html::grid('published', $item->state, $i, '', false); ?>
			</td>
			<td class="center">
				<time datetime="<?php echo $item->created; ?>"><?php echo Date::of($item->created)->toLocal('Y-m-d H:i:s'); ?></time>
			</td>
			<td class="center">
				<?php echo $item->author_name; ?>
			</td>
		</tr>
		<?php endforeach; ?>
	</tbody>
<?php else : ?>
	<tbody>
		<tr>
			<td colspan="4">
				<p class="noresults"><?php echo Lang::txt('MOD_LATEST_NO_MATCHING_RESULTS'); ?></p>
			</td>
		</tr>
	</tbody>
<?php endif; ?>
</table>
