<?php
/**
 * @package		HUBzero CMS
 * @author		Alissa Nedossekina <alisa@purdue.edu>
 * @copyright	Copyright 2005-2009 by Purdue Research Foundation, West Lafayette, IN 47906
 * @license		http://www.gnu.org/licenses/gpl-2.0.html GPLv2
 *
 * Copyright 2005-2009 by Purdue Research Foundation, West Lafayette, IN 47906.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License,
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
// no direct access
defined('_HZEXEC_') or die();

$this->css('introduction.css', 'system')
     ->css()
     ->js();
?>
<header id="content-header">
	<h2><?php echo $this->title; ?></h2>

	<nav id="content-header-extra">
		<ul id="useroptions">
			<li><a class="btn icon-browse" href="<?php echo Route::url('index.php?option=' . $this->option . '&task=browse'); ?>"><?php echo Lang::txt('COM_PUBLICATIONS_BROWSE') . ' ' . Lang::txt('COM_PUBLICATIONS_PUBLICATIONS'); ?></a></li>
		</ul>
	</nav><!-- / #content-header-extra -->
</header><!-- / #content-header -->

<?php if ($this->getError()) { ?>
	<div class="status-msg">
		<?php
		// Display error or success message
		echo '<p class="witherror">' . $this->getError() . '</p>';
		?>
	</div>
<?php } ?>

<section class="section intropage">
	<div class="grid">
		<div class="col <?php echo (!User::isGuest() && $this->contributable) ? 'span4' : 'span6';  ?>">
			<h3><?php echo Lang::txt('Recent Publications'); ?></h3>
			<?php
			if ($this->results && count($this->results) > 0)
			{
				// Display List of items
				$this->view('_list')
				     ->set('results', $this->results)
				     ->set('config', $this->config)
				     ->display();
			}
			else
			{
				echo '<p class="noresults">' . Lang::txt('COM_PUBLICATIONS_NO_RELEVANT_PUBS_FOUND') . '</p>';
			}
			?>
		</div>
		<div class="col <?php echo (!User::isGuest() && $this->contributable) ? 'span4' : 'span6 omega';  ?>">
			<h3><?php echo Lang::txt('COM_PUBLICATIONS_PUPULAR'); ?></h3>
			<?php
			if ($this->best && count($this->best) > 0)
			{
					// Display List of items
					$this->view('_list')
					     ->set('results', $this->best)
					     ->set('config', $this->config)
					     ->display();
			}
			else
			{
				echo '<p class="noresults">' . Lang::txt('COM_PUBLICATIONS_NO_RELEVANT_PUBS_FOUND') . '</p>';
			}
			?>
		</div>
		<?php  if (!User::isGuest() && $this->contributable) { ?>
			<div class="col span4 omega">
				<h3><?php echo Lang::txt('COM_PUBLICATIONS_WHO_CAN_SUBMIT'); ?></h3>
				<p><?php echo Lang::txt('COM_PUBLICATIONS_WHO_CAN_SUBMIT_ANYONE'); ?></p>
				<p><a href="<?php echo Route::url('index.php?option=com_publications&task=submit'); ?>" class="btn"><?php echo Lang::txt('COM_PUBLICATIONS_START_PUBLISHING'); ?> &raquo;</a></p>
			</div>
		<?php } ?>
	</div>
</section><!-- / .section -->
