<?php
/**
 * HUBzero CMS
 *
 * Copyright 2005-2015 Purdue University. All rights reserved.
 *
 * This file is part of: The HUBzero(R) Platform for Scientific Collaboration
 *
 * The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
 * software: you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * HUBzero is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * HUBzero is a registered trademark of Purdue University.
 *
 * @package   hubzero-cms
 * @author    Nicholas J. Kisseberth <nkissebe@purdue.edu>
 * @copyright Copyright 2005-2015 Purdue University. All rights reserved.
 * @license   http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
 */

// No direct access
defined('_HZEXEC_') or die();

$this->css('register');
?>
<header id="content-header">
	<h2>Racial and Ethnic Heritage Identification</h2>
</header>

<section class="main section">
	<p>We are committed to supporting diversity and underrepresented minorities in science education, and this information helps us better demonstrate success toward that goal, allowing us to continue providing this service to you.  Please provide this information if you feel comfortable doing so.</p>
	<p><strong>This information will not affect the level of service you receive!</strong></p>
	<p><strong>All users are asked to clarify if they are of Hispanic origin or descent, but only United States citizens and Permanent Resident Visa holders need answer the Racial Background section.</strong></p>
	<ul>
		<li>
			Hispanic or Latino<br />
			Persons of Cuban, Mexican, Puerto Rican, Central or South American, or other Spanish culture of origin, regardless of race.  Ethnic subgroups are listed here for selection, or you may enter another subgroup if your culture is not listed.
		</li>
		<li>
			American Indian or Alaska Native<br />
			Persons having origins in any of the original peoples of North and South America (including Central America), and who maintains cultural identification through tribal affiliation or community recognition.
		</li>
		<li>
			Asian<br />
			Persons having origins in any of the original peoples of the Far East, Southeast Asia or the Indian subcontinent, including for example, Cambodia, China, India, Japan, Korea, Malaysia, Pakistan, the Philippine Islands, Thailand, and Vietnam.
		</li>
		<li>
			Black or African American<br />
			Persons having origins in any of the black racial groups of Africa.
		</li>
		<li>
			Native Hawaiian or Other Pacific Islander<br />
			Persons having origins in any of the original peoples of Hawaii, Guam, Samoa, or other Pacific Islands.
		</li>
		<li>
			White<br />
			Persons having origins in any of the original peoples of Europe, the Middle East, or North Africa.
		</li>
		<li>
			Do not wish to reveal<br />
			You may select this if you would prefer to not disclose this information.
		</li>
	</ul>
</section>
