<?php
/**
 * HUBzero CMS
 *
 * Copyright 2005-2015 Purdue University. All rights reserved.
 *
 * This file is part of: The HUBzero(R) Platform for Scientific Collaboration
 *
 * The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
 * software: you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * HUBzero is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * HUBzero is a registered trademark of Purdue University.
 *
 * @package   hubzero-cms
 * @author    Shawn Rice <zooley@purdue.edu>
 * @copyright Copyright 2005-2015 Purdue University. All rights reserved.
 * @license   http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
 */

namespace Components\Citations\Download;

/**
 * Abstract class for citations download
 */
abstract class Downloadable
{
	/**
	 * Mime type
	 *
	 * @var string
	 */
	protected $_mime = '';

	/**
	 * File extension
	 *
	 * @var string
	 */
	protected $_extension = '';

	/**
	 * Set the mime type
	 *
	 * @param      string $mime Value to set
	 * @return     void
	 */
	public function setMimeType($mime)
	{
		$this->_mime = trim($mime);
	}

	/**
	 * Get the mime type
	 *
	 * @return     string
	 */
	public function getMimeType()
	{
		return $this->_mime;
	}

	/**
	 * Set the file extension
	 *
	 * @param      string $ext Value to set
	 * @return     void
	 */
	public function setExtension($ext)
	{
		$this->_extension = trim($ext);
	}

	/**
	 * Get the file extension
	 *
	 * @return     string
	 */
	public function getExtension()
	{
		return $this->_extension;
	}

	/**
	 * Format the file
	 *
	 * @return     string
	 */
	public function format($row)
	{
		return '';
	}
}

