<?php
/**
 * HUBzero CMS
 *
 * Copyright 2005-2015 Purdue University. All rights reserved.
 *
 * This file is part of: The HUBzero(R) Platform for Scientific Collaboration
 *
 * The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
 * software: you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * HUBzero is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * HUBzero is a registered trademark of Purdue University.
 *
 * @package   hubzero-cms
 * @author    Shawn Rice <zooley@purdue.edu>
 * @copyright Copyright 2005-2015 Purdue University. All rights reserved.
 * @license   http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
 */

// No direct access
defined('_HZEXEC_') or die();

$this->css()
     ->js()
     ->js('vote.js');

if (!$this->filters['filterby'])
{
	$this->filters['filterby'] = 'all';
}
if (!$this->filters['filterby'] == 'none')
{
	$this->filters['filterby'] = 'all';
}
$sortdir = $this->filters['sort_Dir'] == 'DESC' ? 'ASC' : 'DESC';

?>
<header id="content-header">
	<h2><?php echo $this->title; ?></h2>

	<?php if (User::authorise('core.create', $this->option)) { ?>
	<div id="content-header-extra">
		<p>
			<a class="icon-add add btn" href="<?php echo Route::url('index.php?option=' . $this->option . '&task=new'); ?>">
				<span><?php echo Lang::txt('COM_ANSWERS_NEW_QUESTION'); ?></span>
			</a>
		</p>
	</div><!-- / #content-header-extra -->
	<?php } ?>
</header>

<section class="main section">
	<div class="section-inner">
		<div class="subject">
			<form method="get" action="<?php echo Route::url('index.php?option=' . $this->option); ?>">

				<div class="container data-entry">
					<input class="entry-search-submit" type="submit" value="<?php echo Lang::txt('COM_ANSWERS_SEARCH'); ?>" />
					<fieldset class="entry-search">
						<input type="text" name="q" value="<?php echo $this->escape($this->filters['q']); ?>" placeholder="<?php echo Lang::txt('COM_ANSWERS_SEARCH_PLACEHOLDER'); ?>" />
						<input type="hidden" name="option" value="<?php echo $this->option; ?>" />
						<input type="hidden" name="area" value="<?php echo $this->escape($this->filters['area']); ?>" />
						<input type="hidden" name="sortby" value="<?php echo $this->escape($this->filters['sortby']); ?>" />
						<input type="hidden" name="sortdir" value="<?php echo $this->escape($this->filters['sort_Dir']); ?>" />
						<input type="hidden" name="filterby" value="<?php echo $this->escape($this->filters['filterby']); ?>" />
						<input type="hidden" name="task" value="<?php echo $this->escape($this->task); ?>" />
					</fieldset>
				</div><!-- / .container -->

				<div class="container">
					<?php if (!User::isGuest()) { ?>
						<nav class="entries-filters">
							<ul class="entries-menu user-options">
								<li>
									<a<?php echo ($this->filters['area'] == '') ? ' class="active"' : ''; ?> href="<?php echo Route::url('index.php?option=' . $this->option . '&task=search&filterby=' . urlencode($this->filters['filterby']).'&sortby=' . urlencode($this->filters['sortby'])); ?>">
										<?php echo Lang::txt('COM_ANSWERS_FILTER_EVERYTHING'); ?>
									</a>
								</li>
								<li>
									<a<?php echo ($this->filters['area'] == 'mine') ? ' class="active"' : ''; ?> href="<?php echo Route::url('index.php?option=' . $this->option . '&task=search&area=mine&filterby=' . urlencode($this->filters['filterby']).'&sortby=' . urlencode($this->filters['sortby'])); ?>">
										<?php echo Lang::txt('COM_ANSWERS_QUESTIONS_I_ASKED'); ?>
									</a>
								</li>
								<li>
									<a<?php echo ($this->filters['area'] == 'assigned') ? ' class="active"' : ''; ?> href="<?php echo Route::url('index.php?option=' . $this->option . '&task=search&area=assigned&filterby=' . urlencode($this->filters['filterby']).'&sortby=' . urlencode($this->filters['sortby'])); ?>">
										<?php echo Lang::txt('COM_ANSWERS_QUESTIONS_RELATED_TO_CONTRIBUTIONS'); ?>
									</a>
								</li>
								<li>
									<a<?php echo ($this->filters['area'] == 'interest') ? ' class="active"' : ''; ?> href="<?php echo Route::url('index.php?option=' . $this->option . '&task=search&area=interest&filterby=' . urlencode($this->filters['filterby']).'&sortby=' . urlencode($this->filters['sortby'])); ?>">
										<?php echo Lang::txt('COM_ANSWERS_QUESTIONS_TAGGED_WITH_MY_INTERESTS'); ?>
									</a>
								</li>
							</ul>
						</nav>
					<?php } ?>
					<nav class="entries-filters">
						<ul class="entries-menu order-options" data-label="<?php echo Lang::txt('COM_ANSWERS_SORT'); ?>">
						<?php if ($this->config->get('banking')) { ?>
							<li>
								<a<?php echo ($this->filters['sortby'] == 'rewards') ? ' class="active"' : ''; ?> href="<?php echo Route::url('index.php?option=' . $this->option . '&task=search&area=' . urlencode($this->filters['area']).'&filterby=' . urlencode($this->filters['filterby']).'&sortby=rewards&sortdir=' . $sortdir); ?>" title="<?php echo Lang::txt('COM_ANSWERS_SORT_REWARDS_TITLE'); ?>">
									<?php echo Lang::txt('COM_ANSWERS_SORT_REWARDS'); ?>
								</a>
							</li>
						<?php } ?>
							<li>
								<a<?php echo ($this->filters['sortby'] == 'votes') ? ' class="active"' : ''; ?> href="<?php echo Route::url('index.php?option=' . $this->option . '&task=search&area=' . urlencode($this->filters['area']).'&filterby=' . urlencode($this->filters['filterby']).'&sortby=votes&sortdir=' . $sortdir); ?>" title="<?php echo Lang::txt('COM_ANSWERS_SORT_POPULAR_TITLE'); ?>">
									<?php echo Lang::txt('COM_ANSWERS_SORT_POPULAR'); ?>
								</a>
							</li>
							<li>
								<a<?php echo ($this->filters['sortby'] == 'date') ? ' class="active"' : ''; ?> href="<?php echo Route::url('index.php?option=' . $this->option . '&task=search&area=' . urlencode($this->filters['area']).'&filterby=' . urlencode($this->filters['filterby']).'&sortby=date&sortdir=' . $sortdir); ?>" title="<?php echo Lang::txt('COM_ANSWERS_SORT_RECENT_TITLE'); ?>">
									<?php echo Lang::txt('COM_ANSWERS_SORT_RECENT'); ?>
								</a>
							</li>
						</ul>

						<ul class="entries-menu filter-options" data-label="<?php echo Lang::txt('COM_ANSWERS_FILTER'); ?>">
							<li>
								<a<?php echo ($this->filters['filterby'] == 'all' || $this->filters['filterby'] == '') ? ' class="active"' : ''; ?> href="<?php echo Route::url('index.php?option=' . $this->option . '&task=search&area=' . urlencode($this->filters['area']).'&filterby=all&sortby=' . urlencode($this->filters['sortby'])); ?>" title="<?php echo Lang::txt('COM_ANSWERS_FILTER_ALL_TITLE'); ?>">
									<?php echo Lang::txt('COM_ANSWERS_FILTER_ALL'); ?>
								</a>
							</li>
							<li>
								<a<?php echo ($this->filters['filterby'] == 'open') ? ' class="active"' : ''; ?> href="<?php echo Route::url('index.php?option=' . $this->option . '&task=search&area=' . urlencode($this->filters['area']).'&filterby=open&sortby=' . urlencode($this->filters['sortby'])); ?>" title="<?php echo Lang::txt('COM_ANSWERS_FILTER_OPEN_TITLE'); ?>">
									<?php echo Lang::txt('COM_ANSWERS_FILTER_OPEN'); ?>
								</a>
							</li>
							<li>
								<a<?php echo ($this->filters['filterby'] == 'closed') ? ' class="active"' : ''; ?> href="<?php echo Route::url('index.php?option=' . $this->option . '&task=search&area=' . urlencode($this->filters['area']).'&filterby=closed&sortby=' . urlencode($this->filters['sortby'])); ?>" title="<?php echo Lang::txt('COM_ANSWERS_FILTER_CLOSED_TITLE'); ?>">
									<?php echo Lang::txt('COM_ANSWERS_FILTER_CLOSED'); ?>
								</a>
							</li>
						</ul>
					</nav>

					<table class="questions entries">
						<caption>
							<?php
								$s = ($this->total > 0) ? $this->filters['start']+1 : $this->filters['start'];
								$e = ($this->total > ($this->filters['start'] + $this->filters['limit'])) ? ($this->filters['start'] + $this->filters['limit']) : $this->total;
								if ($this->filters['q'] != '')
								{
									echo Lang::txt('COM_ANSWERS_SEARCH_FOR', $this->escape($this->filters['q']), Lang::txt('COM_ANSWERS_FILTER_' . strtoupper($this->filters['filterby'])));
								}
								else
								{
									echo Lang::txt('COM_ANSWERS_FILTER_' . strtoupper($this->filters['filterby']));
								}
							?>
							<span>(<?php echo Lang::txt('COM_ANSWERS_RESULTS_TOTAL', $s, $e, $this->total); ?>)</span>
						</caption>
						<tbody>
				<?php if (count($this->results) > 0) { ?>
					<?php
					foreach ($this->results as $row)
					{
						// author name
						$name = Lang::txt('COM_ANSWERS_ANONYMOUS');
						if (!$row->get('anonymous'))
						{
							$name = $this->escape(stripslashes($row->creator('name', $name)));
							if ($row->creator('public'))
							{
								$name = '<a href="' . Route::url($row->creator()->getLink()) . '">' . $name . '</a>';
							}
						}
						$cls  = ($row->isclosed())   ? 'answered' : '';
						$cls  = ($row->isReported()) ? 'flagged'  : $cls;
						$cls .= ($row->get('created_by') == User::get('id')) ? ' mine' : '';
						?>
							<tr<?php echo ($cls) ? ' class="'.$cls.'"' : ''; ?>>
								<th class="priority-5" scope="row">
									<span class="entry-id"><?php echo $row->get('id'); ?></span>
								</th>
								<td>
									<?php if (!$row->isReported()) { ?>
										<a class="entry-title" href="<?php echo Route::url($row->link()); ?>">
											<?php echo $this->escape($row->subject('clean')); ?>
										</a><br />
									<?php } else { ?>
										<span class="entry-title">
											<?php echo Lang::txt('COM_ANSWERS_QUESTION_UNDER_REVIEW'); ?>
										</span><br />
									<?php } ?>
									<span class="entry-details">
										<?php echo Lang::txt('COM_ANSWERS_ASKED_BY', $name) . ' '; ?>
										<span class="entry-date-at"><?php echo Lang::txt('COM_ANSWERS_DATETIME_AT'); ?> </span>
										<span class="entry-time"><time datetime="<?php echo $row->created(); ?>"><?php echo $row->created('time'); ?></time> </span>
										<span class="entry-date-on"><?php echo Lang::txt('COM_ANSWERS_DATETIME_ON'); ?> </span>
										<span class="entry-date"><time datetime="<?php echo $row->created(); ?>"><?php echo $row->created('date'); ?></time> </span>
										<span class="entry-details-divider">&bull;</span>
										<span class="entry-state">
											<?php echo ($row->get('state')==1) ? Lang::txt('COM_ANSWERS_STATE_CLOSED') : Lang::txt('COM_ANSWERS_STATE_OPEN'); ?>
										</span>
										<span class="entry-details-divider">&bull;</span>
										<span class="entry-comments">
											<a href="<?php echo Route::url($row->link() . '#answers'); ?>" title="<?php echo Lang::txt('COM_ANSWERS_RESPONSES_TO_THIS_QUESTION', $row->get('rcount')); ?>">
												<?php echo $row->get('rcount'); ?>
											</a>
										</span>
									</span>
								</td>
								<?php if ($this->config->get('banking')) { ?>
									<td class="priority-3 reward">
										<?php if ($row->get('reward')) { ?>
											<span class="entry-reward">
												<?php echo $row->get('points'); ?>
												<a href="<?php echo $this->config->get('infolink'); ?>" title="<?php echo Lang::txt('COM_ANSWERS_THERE_IS_A_REWARD_FOR_ANSWERING', $row->get('points')); ?>">
													<?php echo Lang::txt('COM_ANSWERS_POINTS'); ?>
												</a>
											</span>
										<?php } ?>
									</td>
								<?php } ?>
								<td class="priority-4 voting">
									<span class="vote-like">
										<?php if (User::isGuest()) { ?>
											<span class="vote-button <?php echo ($row->get('helpful') > 0) ? 'like' : 'neutral'; ?> tooltips" title="<?php echo Lang::txt('COM_ANSWERS_VOTE_LIKE_LOGIN'); ?>">
												<?php echo $row->get('helpful', 0); ?><span> <?php echo Lang::txt('COM_ANSWERS_VOTE_LIKE'); ?></span>
											</span>
										<?php } else { ?>
											<a class="vote-button <?php echo ($row->get('helpful') > 0) ? 'like' : 'neutral'; ?> tooltips" href="<?php echo Route::url('index.php?option=com_answers&task=vote&id=' . $row->get('id') . '&vote=1'); ?>" title="<?php echo Lang::txt('COM_ANSWERS_VOTE_LIKE_TITLE', $row->get('helpful')); ?>">
												<?php echo $row->get('helpful', 0); ?><span> <?php echo Lang::txt('COM_ANSWERS_VOTE_LIKE'); ?></span>
											</a>
										<?php } ?>
									</span>
								</td>
							</tr>
					<?php } // end foreach ?>
				<?php } else { ?>
							<tr class="noresults">
								<td>
									<?php echo Lang::txt('COM_ANSWERS_NO_RESULTS'); ?>
								</td>
							</tr>
				<?php } // end if (count($this->results) > 0) { ?>
						</tbody>
					</table>
					<?php
					// Initiate paging
					$pageNav = $this->pagination(
						$this->total,
						$this->filters['start'],
						$this->filters['limit']
					);
					$pageNav->setAdditionalUrlParam('q', $this->filters['q']);
					$pageNav->setAdditionalUrlParam('filterby', $this->filters['filterby']);
					$pageNav->setAdditionalUrlParam('sortby', $this->filters['sortby']);
					$pageNav->setAdditionalUrlParam('area', $this->filters['area']);
					$pageNav->setAdditionalUrlParam('sortdir', $this->filters['sort_Dir']);
					echo $pageNav->render();
					?>
					<div class="clearfix"></div>
				</div><!-- / .container -->
			</form>
		</div><!-- / .subject -->
		<aside class="aside">
			<div class="container">
				<h3><?php echo Lang::txt('COM_ANSWERS_NEED_AN_ANSWER'); ?></h3>
				<p>
					<?php echo Lang::txt('COM_ANSWERS_CANT_FIND_ANSWER', '<a href="' . Route::url('index.php?option=com_kb') . '">' . Lang::txt('COM_ANSWERS_KNOWLEDGE_BASE') . '</a>', Config::get('sitename')); ?>
				</p>
			</div><!-- / .container -->
			<div class="container">
				<h3><?php echo Lang::txt('COM_ANSWERS_GET_STARTED'); ?></h3>
				<p>
					<?php echo Lang::txt('COM_ANSWERS_GET_STARTED_HELP', Route::url('index.php?option=com_help&component=answers&page=index')); ?>
				</p>
			</div><!-- / .container -->
			<?php if ($this->config->get('banking')) { ?>
				<div class="container">
					<h3><?php echo Lang::txt('COM_ANSWERS_EARN_POINTS'); ?></h3>
					<p>
						<?php echo Lang::txt('COM_ANSWERS_START_EARNING_POINTS'); ?> <a href="<?php echo $this->config->get('infolink'); ?>"><?php echo Lang::txt('COM_ANSWERS_LEARN_MORE'); ?></a>.
					</p>
				</div><!-- / .container -->
			<?php } ?>
		</aside><!-- / .aside -->
	</div><!-- / .section-inner -->
</section><!-- / .main section -->
