#
# @package      hubzero-cms
# @file         installation/sql/mysql/hz_sample_data.sql
# @author       Nicholas J. Kisseberth <nkissebe@purdue.edu>
# @copyright    Copyright (c) 2010-2013 Purdue University. All rights reserved.
# @license      http://www.gnu.org/licenses/gpl2.html GPLv2
#
# Copyright (c) 2010-2013 Purdue University
# All rights reserved.
#
# This file is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation, either version 2 of the License, or (at your
# option) any later version.
#
# This file is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of Purdue University.
#

#
# IMPORTANT - THIS FILE MUST BE SAVED WITH UTF-8 ENCODING ONLY. BEWARE IF EDITING!
#

UPDATE `#__extensions` SET enabled='0' WHERE `type`='component' AND `element` IN ('com_banners','com_weblinks','com_contacts','com_search','com_wrapper','com_mailto','com_massmail');
UPDATE `#__extensions` SET params='{"show_headings":"1","show_name":"1","show_articles":"1","show_link":"1","show_cat_description":"1","show_cat_items":"1","show_feed_image":"1","show_feed_description":"1","show_item_description":"1","feed_word_count":"0"}' WHERE `type`='component' AND `element`='com_newsfeeds';
UPDATE `#__extensions` SET params='{"upload_extensions":"bmp,csv,doc,epg,gif,ico,jpg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,EPG,GIF,ICO,JPG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS","upload_maxsize":"10000000","file_path":"site/media","image_path":"site/media/images","restrict_uploads":"1","allowed_media_usergroup":"3","check_mime":"1","image_extensions":"bmp, gif, jpg, png","ignore_extensions":"","upload_mime":"image/jpeg, image/gif, image/png, image/bmp, application/x-shockwave-flash, application/msword, application/excel, application/pdf, application/powerpoint, text/plain, application/x-zip","upload_mime_illegal":"text/html","enable_flash":"0"}' WHERE `type`='component' AND `element`='com_media';
UPDATE `#__extensions` SET params='{"show_noauth":"0","show_title":"1","link_titles":"0","show_intro":"1","show_section":"0","link_section":"0","show_category":"0","link_category":"0","show_author":"0","show_create_date":"0","show_modify_date":"0","show_item_navigation":"0","show_readmore":"1","show_vote":"0","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","feed_summary":"0","filter_tags":"","filter_attritbutes":""}' WHERE `type`='component' AND `element`='com_content';
UPDATE `#__extensions` SET params='{"allowUserRegistration":"1","new_usertype":"Registered","useractivation":"1","frontend_userparams":"1","allow_duplicate_emails":"0"}' WHERE `type`='component' AND `element`='com_users';


UPDATE `#__modules` SET position='user3' WHERE title='Main Menu';
UPDATE `#__modules` SET showtitle='0' WHERE title='Main Menu';
UPDATE `#__modules` SET params= '{"menutype":"mainmenu","menu_style":"list","startLevel":"0","endLevel":"0","showAllChildren":"1","window_open":"","show_whitespace":"0","cache":"1","tag_id":"","class_sfx":"","moduleclass_sfx":"_menu","maxdepth":"10","menu_images":"0","menu_images_align":"0","menu_images_link":"0","expand_menu":"0","activate_parent":"0","full_active_id":"0","indent_image":"0","indent_image1":"","indent_image2":"","indent_image3":"","indent_image4":"","indent_image5":"","indent_image6":"","spacer":"","end_spacer":""}';
UPDATE `#__modules` SET published='0' WHERE title='Quick Icons';
UPDATE `#__modules` SET module='mod_hubmenu' WHERE title='Admin Menu';

--
-- HUBzero sample data for table `hosttype`
--

INSERT INTO `hosttype` (`name`, `value`, `description`) VALUES ('workspace',1,'Workspace host');
INSERT INTO `hosttype` (`name`, `value`, `description`) VALUES ('fileserver',2,'Fileserver host');
INSERT INTO `hosttype` (`name`, `value`, `description`) VALUES ('pubnet',4,'Public host');
INSERT INTO `hosttype` (`name`, `value`, `description`) VALUES ('sessions',8,'Normal jobs');
INSERT INTO `hosttype` (`name`, `value`, `description`) VALUES ('openvz',16,'OpenVZ');

--
-- HUBzero sample data for table `#__assets`
--

REPLACE INTO `#__assets` VALUES (1,0,0,191,0,'root.1','Root Asset','{"core.login.site":{"1":1,"6":1,"2":1},"core.login.admin":{"6":1},"core.login.offline":{"6":1},"core.admin":{"8":1},"core.manage":{"7":1},"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}');
REPLACE INTO `#__assets` VALUES (2,1,75,76,1,'com_admin','com_admin','{}');
REPLACE INTO `#__assets` VALUES (3,1,77,80,1,'com_banners','com_banners','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
REPLACE INTO `#__assets` VALUES (4,1,81,82,1,'com_cache','com_cache','{"core.admin":{"7":1},"core.manage":{"7":1}}');
REPLACE INTO `#__assets` VALUES (5,1,83,84,1,'com_checkin','com_checkin','{"core.admin":{"7":1},"core.manage":{"7":1}}');
REPLACE INTO `#__assets` VALUES (6,1,85,86,1,'com_config','com_config','{"core.admin":{"7":1},"core.manage":{"7":1},"core.create":{"7":1},"core.delete":{"7":1},"core.edit":{"7":1},"core.edit.state":{"7":1}}');
REPLACE INTO `#__assets` VALUES (7,1,87,90,1,'com_contact','com_contact','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}');
REPLACE INTO `#__assets` VALUES (8,1,91,144,1,'com_content','com_content','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}');
REPLACE INTO `#__assets` VALUES (9,1,145,146,1,'com_cpanel','com_cpanel','{}');
REPLACE INTO `#__assets` VALUES (10,1,147,148,1,'com_installer','com_installer','{"core.admin":[],"core.manage":{"7":0},"core.delete":{"7":0},"core.edit.state":{"7":0}}');
REPLACE INTO `#__assets` VALUES (11,1,149,150,1,'com_languages','com_languages','{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
REPLACE INTO `#__assets` VALUES (12,1,151,152,1,'com_login','com_login','{}');
REPLACE INTO `#__assets` VALUES (13,1,153,154,1,'com_mailto','com_mailto','{"core.admin":{"7":1},"core.manage":{"7":1},"core.create":{"7":1},"core.delete":{"7":1},"core.edit":{"7":1},"core.edit.state":{"7":1}}');
REPLACE INTO `#__assets` VALUES (14,1,155,156,1,'com_massmail','com_massmail','{"core.admin":{"7":1},"core.manage":{"7":1},"core.create":{"7":1},"core.delete":{"7":1},"core.edit":{"7":1},"core.edit.state":{"7":1}}');
REPLACE INTO `#__assets` VALUES (15,1,157,158,1,'com_media','com_media','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":{"5":1}}');
REPLACE INTO `#__assets` VALUES (16,1,159,160,1,'com_menus','com_menus','{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
REPLACE INTO `#__assets` VALUES (17,1,161,162,1,'com_messages','com_messages','{"core.admin":{"7":1},"core.manage":{"7":1}}');
REPLACE INTO `#__assets` VALUES (18,1,163,164,1,'com_modules','com_modules','{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
REPLACE INTO `#__assets` VALUES (19,1,165,168,1,'com_newsfeeds','com_newsfeeds','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}');
REPLACE INTO `#__assets` VALUES (20,1,169,170,1,'com_plugins','com_plugins','{"core.admin":{"7":1},"core.manage":[],"core.edit":[],"core.edit.state":[]}');
REPLACE INTO `#__assets` VALUES (21,1,171,172,1,'com_redirect','com_redirect','{"core.admin":{"7":1},"core.manage":[]}');
REPLACE INTO `#__assets` VALUES (22,1,173,174,1,'com_search','com_search','{"core.admin":{"7":1},"core.manage":{"6":1}}');
REPLACE INTO `#__assets` VALUES (23,1,175,176,1,'com_templates','com_templates','{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
REPLACE INTO `#__assets` VALUES (24,1,177,180,1,'com_users','com_users','{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
REPLACE INTO `#__assets` VALUES (25,1,181,184,1,'com_weblinks','com_weblinks','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}');
REPLACE INTO `#__assets` VALUES (26,1,185,186,1,'com_wrapper','com_wrapper','{}');
REPLACE INTO `#__assets` VALUES (27,8,134,143,2,'com_content.category.2','Uncategorised','{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}');
REPLACE INTO `#__assets` VALUES (28,3,78,79,2,'com_banners.category.3','Uncategorised','{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
REPLACE INTO `#__assets` VALUES (29,7,88,89,2,'com_contact.category.4','Uncategorised','{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}');
REPLACE INTO `#__assets` VALUES (30,19,166,167,2,'com_newsfeeds.category.5','Uncategorised','{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}');
REPLACE INTO `#__assets` VALUES (31,25,182,183,2,'com_weblinks.category.6','Uncategorised','{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}');
REPLACE INTO `#__assets` VALUES (32,24,178,179,2,'com_users.category.7','Uncategorised','{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
REPLACE INTO `#__assets` VALUES (33,1,187,188,1,'com_finder','com_finder','{"core.admin":{"7":1},"core.manage":{"6":1}}');
REPLACE INTO `#__assets` VALUES (34,1,189,190,1,'com_joomlaupdate','com_joomlaupdate','{"core.admin":[],"core.manage":[],"core.delete":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (35,1,69,70,1,'com_answers','com_answers','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (36,1,67,68,1,'com_billboards','com_billboards','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (37,1,65,66,1,'com_blog','com_blog','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (38,1,33,34,1,'com_citations','com_citations','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (39,1,31,32,1,'com_courses','com_courses','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (40,1,29,30,1,'com_cron','com_cron','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (41,1,19,28,1,'com_events','com_events','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (42,1,17,18,1,'com_features','com_features','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (43,1,15,16,1,'com_feedback','com_feedback','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (44,1,13,14,1,'com_forum','com_forum','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (45,1,73,74,1,'com_groups','com_groups','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (46,1,11,12,1,'com_help','com_help','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (47,1,9,10,1,'com_jobs','com_jobs','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (48,1,7,8,1,'com_kb','com_kb','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (49,1,5,6,1,'com_members','com_members','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (50,1,3,4,1,'com_newsletter','com_newsletter','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (51,1,35,36,1,'com_poll','com_poll','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (52,1,37,38,1,'com_projects','com_projects','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (53,1,39,40,1,'com_register','com_register','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (54,1,63,64,1,'com_resources','com_resources','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (55,1,61,62,1,'com_services','com_services','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (56,1,59,60,1,'com_store','com_store','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (57,1,57,58,1,'com_support','com_support','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (58,1,55,56,1,'com_system','com_system','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (59,1,53,54,1,'com_tags','com_tags','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (60,1,71,72,1,'com_tools','com_tools','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (61,1,51,52,1,'com_topics','com_topics','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (62,1,49,50,1,'com_usage','com_usage','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (63,1,47,48,1,'com_user','com_user','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (64,1,45,46,1,'com_whatsnew','com_whatsnew','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (65,1,43,44,1,'com_wiki','com_wiki','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (66,1,41,42,1,'com_wishlist','com_wishlist','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (67,1,1,2,1,'com_ysearch','com_ysearch','{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (68,8,92,107,2,'com_content.category.8','com_content','{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (69,8,108,125,2,'com_content.category.9','com_content','{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (70,8,126,127,2,'com_content.category.10','com_content','{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (71,8,128,129,2,'com_content.category.11','com_content','{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (72,41,20,21,2,'com_events.category.12','com_events','{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (73,41,22,23,2,'com_events.category.13','com_events','{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (74,41,24,25,2,'com_events.category.14','com_events','{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (75,41,26,27,2,'com_events.category.15','com_events','{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (76,77,131,132,3,'com_content.category.16','com_content','{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (77,8,130,133,2,'com_content.category.17','com_content','{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (78,27,135,136,3,'com_content.article.1','Home','{"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (79,68,93,94,3,'com_content.article.2','Our Cyberinfrastructure','{"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (80,68,95,96,3,'com_content.article.3','About Us','{"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (81,68,97,98,3,'com_content.article.4','Contact Us','{"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (82,68,99,100,3,'com_content.article.5','Quotes','{"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (83,68,101,102,3,'com_content.article.6','Usage','{"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (84,68,103,104,3,'com_content.article.7','Copyrights','{"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (85,68,105,106,3,'com_content.article.8','Feedback','{"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (86,69,109,110,3,'com_content.article.11','Terms of Use','{"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (87,69,111,112,3,'com_content.article.12','Intellectual Property Considerations','{"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (88,69,113,114,3,'com_content.article.13','Creative Commons','{"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (89,69,115,116,3,'com_content.article.14','Submitting Content','{"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (90,27,137,138,3,'com_content.article.22','Discover','{"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (91,27,139,140,3,'com_content.article.32','Congratulations','{"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (92,69,117,118,3,'com_content.article.27','Privacy Policy','{"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (93,69,119,120,3,'com_content.article.28','Abuse Policy','{"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (94,69,121,122,3,'com_content.article.29','Legal','{"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (95,69,123,124,3,'com_content.article.30','HUBzero Accessibility Statement','{"core.delete":[],"core.edit":[],"core.edit.state":[]}');
INSERT INTO `#__assets` VALUES (96,27,141,142,3,'com_content.article.31','Community','{"core.delete":[],"core.edit":[],"core.edit.state":[]}');

--
-- HUBzero sample data for table `#__auth_domain`
--

INSERT INTO `#__auth_domain` VALUES ('facebook','',1,'','authentication');
INSERT INTO `#__auth_domain` VALUES ('google','',2,'','authentication');
INSERT INTO `#__auth_domain` VALUES ('linkedin','',3,'','authentication');
INSERT INTO `#__auth_domain` VALUES ('pucas','',4,'','authentication');

--
-- HUBzero sample data for table `#__categories`
--

INSERT INTO `#__categories` VALUES (8,68,1,1,2,1,'about','com_content','about','about','','',1,0,'0000-00-00 00:00:00',1,'','','','',0,'0000-00-00 00:00:00',0,'0000-00-00 00:00:00',0,'');
INSERT INTO `#__categories` VALUES (9,69,1,3,4,1,'legal','com_content','legal','legal','','',1,0,'0000-00-00 00:00:00',1,'','','','',0,'0000-00-00 00:00:00',0,'0000-00-00 00:00:00',0,'');
INSERT INTO `#__categories` VALUES (10,70,1,5,6,1,'browse','com_content','browse','browse','','',1,0,'0000-00-00 00:00:00',1,'','','','',0,'0000-00-00 00:00:00',0,'0000-00-00 00:00:00',0,'');
INSERT INTO `#__categories` VALUES (11,71,1,7,8,1,'presenters','com_content','presenters','presenters','','',1,0,'0000-00-00 00:00:00',1,'','','','',0,'0000-00-00 00:00:00',0,'0000-00-00 00:00:00',0,'');
INSERT INTO `#__categories` VALUES (12,72,1,9,10,1,'meeting','com_events','Meeting','meeting','','',1,0,'0000-00-00 00:00:00',1,'','','','',0,'0000-00-00 00:00:00',0,'0000-00-00 00:00:00',0,'');
INSERT INTO `#__categories` VALUES (13,73,1,11,12,1,'seminar','com_events','Seminar','seminar','','',1,0,'0000-00-00 00:00:00',1,'','','','',0,'0000-00-00 00:00:00',0,'0000-00-00 00:00:00',0,'');
INSERT INTO `#__categories` VALUES (14,74,1,13,14,1,'workshop','com_events','Workshop','workshop','','',1,0,'0000-00-00 00:00:00',1,'','','','',0,'0000-00-00 00:00:00',0,'0000-00-00 00:00:00',0,'');
INSERT INTO `#__categories` VALUES (15,75,1,15,16,1,'general','com_events','General','general','','',1,0,'0000-00-00 00:00:00',1,'','','','',0,'0000-00-00 00:00:00',0,'0000-00-00 00:00:00',0,'');
INSERT INTO `#__categories` VALUES (16,76,17,18,19,2,'features/frontpage','com_content','frontpage','frontpage','','',1,0,'0000-00-00 00:00:00',1,'','','','',0,'0000-00-00 00:00:00',0,'0000-00-00 00:00:00',0,'');
INSERT INTO `#__categories` VALUES (17,77,1,17,20,1,'features','com_content','features','features','','',1,0,'0000-00-00 00:00:00',1,'','','','',0,'0000-00-00 00:00:00',0,'0000-00-00 00:00:00',0,'');

--
-- HUBzero sample data for table `#__citations_types`
--

INSERT INTO `#__citations_types` VALUES (1,'journal','Journal','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (2,'article','Article','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (3,'book','Book','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (4,'booklet','Booklet','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (5,'conference','Conference','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (6,'inbook','In Book','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (7,'incollection','In Collection','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (8,'inproceedings','In Proceedings','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (9,'magazine','Magazine','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (10,'manual','Manual','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (11,'mastersthesis','Masters Thesis','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (12,'misc','Misc','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (13,'phdthesis','PhD Thesis','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (14,'proceedings','Proceedings','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (15,'techreport','Tech Report','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (16,'unpublished','Unpublished','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (17,'patent','Patent','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (18,'chapter','Chapter','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (19,'notes','Text Snippet/Notes','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (20,'letter','Letter','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (21,'xarchive','XArchive','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (22,'manuscript','Manuscript','',NULL,NULL);
INSERT INTO `#__citations_types` VALUES (23,'paper','Paper',NULL,NULL,NULL);
INSERT INTO `#__citations_types` VALUES (24,'presentation','Presentation',NULL,NULL,NULL);
INSERT INTO `#__citations_types` VALUES (25,'publication','Publication',NULL,NULL,NULL);
INSERT INTO `#__citations_types` VALUES (26,'researchreport','Research Report',NULL,NULL,NULL);
INSERT INTO `#__citations_types` VALUES (27,'annualreport','Annual Report',NULL,NULL,NULL);
INSERT INTO `#__citations_types` VALUES (28,'governmentreport','Government report',NULL,NULL,NULL);
INSERT INTO `#__citations_types` VALUES (29,'poster','Poster',NULL,NULL,NULL);

--
-- HUBzero sample data for table `#__content`
--

INSERT INTO `#__content` VALUES (1,78,'Home','home','','{xhub:include type=\"stylesheet\" filename=\"pages/home.css\"}\r\n\r\n<div id=\"features\">\r\n	<div class=\"wrap\">\r\n		<h2>Features</h2>\r\n		<div class=\"three columns first\">\r\n			<div class=\"resource\">\r\n				{xhub:module position=\"featureLeft\"}\r\n			</div>\r\n		</div>\r\n		<div class=\"three columns second\">\r\n			<div class=\"poll\">\r\n				{xhub:module position=\"featureMiddle\"}\r\n			</div>\r\n		</div>\r\n		<div class=\"three columns third\">\r\n			<div class=\"tool\">\r\n				{xhub:module position=\"featureRight\"}\r\n			</div>\r\n		</div>\r\n		<div class=\"clear\"></div>\r\n	</div>\r\n</div>\r\n\r\n<div class=\"highlight-section\">\r\n	<p>\r\n		Welcome to our community for scientific and educational collaboration.\r\n	</p>\r\n</div><!-- / .highlight-section -->\r\n\r\n<div class=\"events-section\">\r\n	<div class=\"wrap\">\r\n		<div class=\"four columns first\">\r\n			<h2>News &amp; Events</h2>\r\n			<p>\r\n				Find out what\'s happening and what\'s new. Find information about the many public meetings and scientific symposia.\r\n			</p>\r\n		</div>\r\n		<div class=\"four columns second third fourth\">\r\n			<div class=\"two columns first\">\r\n				{xhub:module position=\"eventsLeft\"}\r\n			</div>\r\n			<div class=\"two columns second\">\r\n				{xhub:module position=\"eventsRight\"}\r\n			</div>\r\n			<div class=\"clear\"></div>\r\n		</div>\r\n		<div class=\"clear\"></div>\r\n	</div>\r\n</div><!-- / .inner -->\r\n\r\n<div class=\"resources-section wrap\">\r\n	<div class=\"four columns first\">\r\n		<h2>Resources</h2>\r\n		<p>\r\n			Browse our continually expanding user-submitted content that covers a broad range of topics.\r\n		</p>\r\n	</div>\r\n	<div class=\"four columns second third fourth\">\r\n		<div class=\"two columns first\">\r\n			<h3>Search</h3>\r\n			<form action=\"/search/\" method=\"get\" class=\"search\">\r\n				<fieldset>\r\n					<label for=\"rsearchword\">Keyword or phrase:</label>\r\n					<input type=\"text\" name=\"terms\" id=\"rsearchword\" value=\"\" />\r\n					<input type=\"hidden\" name=\"domains[]\" value=\"resources\" />\r\n					<input type=\"submit\" value=\"Search\" />\r\n				</fieldset>\r\n			</form>\r\n		</div>\r\n		<div class=\"two columns second\">\r\n			<h3>Upload</h3>\r\n			<p>\r\n				Become a contributor and share your work with the community! <a href=\"/resources/new\" class=\"contributelink\">Get started &rarr;</a>\r\n			</p>\r\n		</div>\r\n		<div class=\"clear\"></div>\r\n\r\n		<div class=\"two columns first\">\r\n			<h3>Categories</h3>\r\n			<ul>\r\n				<li><a href=\"/resources/courses\">Courses</a></li>\r\n				<li><a href=\"/resources/othermaterials\">Other Materials</a></li>\r\n				<li><a href=\"/resources/presentations\">Presentations</a></li>\r\n				<li><a href=\"/resources/publications\">Publications</a></li>\r\n				<li><a href=\"/resources/seminars\">Seminars</a></li>\r\n				<li><a href=\"/resources/tools\">Tools</a></li>\r\n			</ul>\r\n		</div>\r\n		<div class=\"two columns second\">\r\n			{xhub:module position=\"toptags\"}\r\n		</div>\r\n		<div class=\"clear\"></div>\r\n	</div>\r\n	<div class=\"clear\"></div>\r\n</div><!-- / .inner -->', '', '1', '0', '0', '2', '2010-03-25 02:26:40', '62', '', '2012-09-07 19:18:38', '1008', '0', '0000-00-00 00:00:00', '2010-03-25 02:26:40', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"0\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_vote\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',20,0,1,'','',1,1645,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (2,79,'Our Cyberinfrastructure','hubzero','','<p>\r\n<img src=\"/media/system/images/hubzero-logo-2012.png\" align=\"right\"/>\r\nOur web site is powered by the <a href=\"http://hubzero.org\">HUBzero&reg;\r\nPlatform for Scientific Collaboration</a> originally developed at <a href=\"http://www.purdue.edu\">Purdue University</a>.\r\nHUBzero was specifically designed to help a scientific community share\r\nresources and work together with one another.  Users can upload their own\r\ncontent--including tutorials, courses, publications, and animations--and\r\nshare them with the rest of the community.  But each hub is more than\r\njust a repository of information.  It is a place where researchers and\r\neducators can collaborate in private spaces to build simulation/modeling tools, gather datasets, and share them online.  Users can launch\r\ncomputations and view results with an ordinary web browser--without\r\nhaving to download, compile, or install any code.  The tools they access\r\nare not just web forms, but powerful graphical tools that support visualization\r\nand comparison of results.\r\n</p>\r\n<h3>How Does a Hub Differ From a Web Site?</h3>\r\n<p>\r\nAt its core, a hub is a web site built with many familiar open source\r\npackages--the Linux operating system, an Apache web server, a MySQL\r\ndatabase, PHP web scripting, and the Joomla content management\r\nsystem.  The HUBzero software builds upon that infrastructure to create\r\nan environment in which researchers, educators, and students can access\r\nsimulation tools and share information.  Specifically, we define a \"hub\"\r\nas a web-based collaboration environment with the following features:\r\n<ul>\r\n	<li>Interactive simulation tools, hosted on the hub cluster and delivered to your browser</li>\r\n	<li>Simulation tool development area, including source code control and bug tracking</li>\r\n	<li>Videos and other supporting media for classes, tutorials, and documentation</li>\r\n	<li>Groups and projects for private collaboration</li>\r\n	<li>Mechanism for uploading and sharing resources</li>\r\n	<li>5-star ratings and user feedback for resources</li>\r\n	<li>User support area, with question-and-answer forum</li>\r\n	<li>Statistics about users and usage patterns</li>\r\n</ul>\r\n</p><p>\r\nYou can use this software to <a href=\"http://hubzero.org/getstarted\">start a hub</a> for your own scientific community.  Join others in the <a href=\"http://hubzero.org/about/foundation\">HUBzero Foundation</a> and help to develop the platform.  Visit <a href=\"http://hubzero.org\">HUBzero.org</a> to learn more.\r\n</p>','',1,1,0,8,'2010-03-25 02:26:40',62,'','0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00','2010-03-25 02:26:40','0000-00-00 00:00:00','','','{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_vote\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',2,0,1,'','',1,19,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (3,80,'About Us','about','','<p class=\"warning\">\r\nEdit this page and fill in information about your project.  Think of\r\nthis page as the front page of a brochure.  Describe your overall\r\nproject and its goals in simple terms.  The following text is just\r\na suggestion for the kinds of things you might see on this page.\r\n</p>\r\n\r\n<h3>Our Mission</h3>\r\n\r\n<p>The Your Organization (YORG) is funded by <i>Your Funding Organization</i>\r\nwith a mission to <i>change the world</i>.</p>\r\n\r\n<h3>What is {xhub:getcfg hubShortName}?</h3>\r\n<p>\r\nThis web site is a resource for research, education and collaboration\r\nin <i>your science area</i>.  It hosts\r\n<a href=\"/resources/browse\">various resources</a> which will help you learn\r\nabout <i>your science area</i>, including\r\n<a href=\"/resources/seminars\">Seminars</a>,\r\n<a href=\"/resources/courses\">Courses</a>,\r\n<a href=\"/resources/teachingmaterials\">Teaching Materials</a>, and more.\r\nThese resources come from <a href=\"/members\">contributors</a> in our\r\nscientific community, and are used by <a href=\"/usage\">visitors from all\r\nover the world</a>.\r\n</p>\r\n<p>\r\nMost importantly, {xhub:getcfg hubShortURL} offers live <a href=\"/resources/tools/\">Simulation/Modeling Tools</a>\r\nwhich you can access from your web browser, so you can not only learn\r\nabout but also simulate <i>your science area</i>.\r\n</p>\r\n\r\n<h3>Join Us</h3>\r\n<ul>\r\n<li><a href=\"/register\" title=\"Sign up!\">Create your own account</a>.\r\nIt\'s free and will give you access to our\r\n<a href=\"/resources/tools/\" title=\"View a list of tools\">online simulation tools</a>\r\nand <a href=\"/discover\">other features</a>.</li>\r\n<li><a href=\"/groups/new\">Create your own private user group</a> and collaborate privately with students and colleagues that you invite.</li>\r\n<li><a href=\"/resources/new\">Become a contributor</a>\r\nby uploading your own presentations and simulation tools for others to share.</li>\r\n<li><a href=\"/answers/question/new\">Ask a question</a> in our <a href=\"/answers\">community forum</a>, and let the\r\ncommunity help you out.</li>\r\n</ul>','',1,1,0,8,'2010-03-25 02:26:40',62,'','0000-00-00 00:00:00',1,0,'0000-00-00 00:00:00','2010-03-25 02:26:40','0000-00-00 00:00:00','','','{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_vote\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',3,0,2,'','',1,173,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (4,81,'Contact Us','contact','','<p class=\"warning\">Edit this page and fill in your own contact information, so people know who owns and operates this site.</p>','',1,1,0,8,'2010-03-25 02:26:40',62,'','2010-03-27 16:19:26',63,0,'0000-00-00 00:00:00','2010-03-25 02:26:40','0000-00-00 00:00:00','','','{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_vote\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',3,0,3,'','',1,34,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (5,82,'Quotes','quotes','','<div style=\"text-align:right; margin:0; padding:0 0 1em 0;\"><a href=\"feedback/success_story\">Add Your Success Story</a></div>\r\n<p>{xhub:module position=\"quotes\" style=\"-1\"}</p>','',1,1,0,8,'2010-03-25 02:26:40',62,'','2010-03-26 15:03:09',63,0,'0000-00-00 00:00:00','2010-03-25 02:26:40','0000-00-00 00:00:00','','','{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_vote\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',2,0,4,'','',1,43,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (6,83,'Usage','usage','','About usage placeholder','',0,1,0,8,'2010-03-25 02:26:40',62,'','0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00','2010-03-25 02:26:40','0000-00-00 00:00:00','','','{\"pageclass_sfx\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_vote\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\"}',1,0,5,'','',1,2,'robots=\nauthor=\n',0,'','');
INSERT INTO `#__content` VALUES (7,84,'Copyrights','dmcapolicy','','<p class=\"warning\">Edit this page and fill in your contact information at the bottom.  Having this in place protects you from copyright violations.  If any of your users uploads material that infringes copyright protection, the copyright owner will send a \"take down\" notice to the address below.  When you receive such a letter, you are obliged to unpublish the offending material right away.</p>\r\n<p>To file a copyright infringement notification with us, you will need to send a written communication that includes substantially the following (please consult your legal counsel or see Section 512(c)(3) of the Copyright Act to confirm these requirements):</p>\r\n<ul>\r\n<li> A physical or electronic signature of a person authorized to act on behalf of the owner of an exclusive right that is allegedly infringed.</li>\r\n<li> Identification of the copyrighted work claimed to have been infringed, or, if multiple copyrighted works at a single online site are covered by a single notification, a representative list of such works at that site.</li>\r\n<li> Identification of the material that is claimed to be infringing or to be the subject of infringing activity and that is to be removed or access to which is to be disabled, and information reasonably sufficient to permit the service provider to locate the material. <strong>Providing URLs in the body of an email is the best way to help us locate content quickly.</strong></li>\r\n<li> Information reasonably sufficient to permit the service provider to contact the complaining party, such as an address, telephone number, and, if available, an electronic mail address at which the complaining party may be contacted.</li>\r\n<li> A statement that the complaining party has a good faith belief that use of the material in the manner complained of is not authorized by the copyright owner, its agent, or the law.</li>\r\n<li> A statement that the information in the notification is accurate, and under penalty of perjury, that the complaining party is authorized to act on behalf of the owner of an exclusive right that is allegedly infringed.</li>\r\n</ul>\r\n<p>Such written notice should be sent to our designated agent as follows:</p>\r\n<address> DMCA Complaints<br /> This Person<br /> 1234 Street<br /> City, ST 99999<br /> Fax: 555-555-5555<br /> </address>\r\n<p>Please also note that under Section 512(f) any person who knowingly materially misrepresents that material or activity is infringing may be subject to liability.</p>','',1,1,0,8,'2010-03-25 02:26:40',62,'','2010-03-26 15:06:42',63,0,'0000-00-00 00:00:00','2010-03-25 02:26:40','0000-00-00 00:00:00','','','{\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_vote\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',3,0,6,'','',1,30,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (8,85,'Feedback','feedback','','About feedback placeholder','',1,1,0,8,'2010-03-25 02:26:40',62,'','0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00','2010-03-25 02:26:40','0000-00-00 00:00:00','','','{\"pageclass_sfx\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_vote\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\"}',1,0,7,'','',1,41,'robots=\nauthor=\n',0,'','');
INSERT INTO `#__content` VALUES (11,86,'Terms of Use','terms','','<p class=\"warning\">Edit this page with appropriate terms of use for your site under advice of legal council at your institution.  The following text is provided as example text, with placeholders for <strong>MyInstitution</strong>, <strong>MyState</strong>, and <strong>MyCounty</strong>.</p>\r\n<p>Please read these Terms of Use carefully before accessing {xhub:getcfg hubShortURL}.  The {xhub:getcfg hubShortURL} site is operated by a community of researchers and hosted by MyInstitution.  Your access to {xhub:getcfg hubShortURL} is subject to your agreement to these Terms of Use.  By accessing {xhub:getcfg hubShortURL}, you accept, without limitation or qualification, these Terms of Use.</p>\r\n<h3>Modification of the Agreement</h3>\r\n<p>We maintain the right to modify these Terms of Use and may do so by posting modifications on this page.  Any modification is effective immediately upon posting the modification unless otherwise stated.  Your continued use of {xhub:getcfg hubShortURL} following the posting of any modification signifies your acceptance of that modification.  You should regularly visit this page to review the current Terms of Use.</p>\r\n<h3>Eligibility, Registration, Access, and Termination</h3>\r\n<p>The {xhub:getcfg hubShortURL} site is limited to non-commercial educational and research activities.  Posting of spam messages or other commercial advertisements is a violation of these terms and may result in termination of your account.</p>\r\n<p>Certain portions of {xhub:getcfg hubShortURL} are limited to registered users and/or allow a user to participate in online services by entering personal information.  You agree that any information provided to {xhub:getcfg hubShortURL} in these areas will be complete and accurate, and that you will neither register under the name of nor attempt to enter {xhub:getcfg hubShortURL} under the name of another person or entity.</p>\r\n<p>You are responsible for maintaining the confidentiality of your user ID and password, if any, and for restricting access to your computer, and you agree to accept responsibility for all activities that occur under your account or password.  {xhub:getcfg hubShortURL} does not authorize use of your User ID by third-parties.</p>\r\n<p>We may, in our sole discretion, terminate or suspend your access to and use of {xhub:getcfg hubShortURL} without notice and for any reason, including for violation of these Terms of Use or for other conduct that we, in our sole discretion, believe to be unlawful or harmful to others.  In the event of termination, you are no longer authorized to access {xhub:getcfg hubShortURL}.</p>\r\n<h3>Privacy and Confidentiality</h3>\r\n<p>We respect your privacy.  We will only use your personal identification information to support and manage your use of {xhub:getcfg hubShortURL}, including the use of tracking cookies to facilitate {xhub:getcfg hubShortURL} security procedures.  MyInstitution and {xhub:getcfg hubShortURL} sponsors regularly request {xhub:getcfg hubShortURL} usages statistics and other information.  Usage of {xhub:getcfg hubShortURL} is monitored and usage statistics are collected and reported on a regular basis.  {xhub:getcfg hubShortURL} also reserves the right to contact you to request additional information or to keep you updated on changes to {xhub:getcfg hubShortURL}.  You may opt out of receiving newsletters and other non-essential communications.  No information that would identify you personally will be provided to sponsors or third parties without your permission.</p>\r\n<p>All information posted or stored on {xhub:getcfg hubShortURL} is potentially available to all other users of {xhub:getcfg hubShortURL}.  MyInstitution and {xhub:getcfg hubShortURL} disclaim any responsibility or capability for the preservation of confidentiality of such information. <em>Do not post or store information on {xhub:getcfg hubShortURL} if you expect to or are obligated to protect the confidentiality of that information.</em></p>\r\n<h3>Conduct</h3>\r\n<p>You are responsible at all times for using {xhub:getcfg hubShortURL} in a manner that is legal, ethical, and not to the detriment of others.  Quotas for disk storage, job submissions, and other limited resources are strictly enforced.  You may request an increase in your quota, but attempting to circumvent your quota is unethical and may lead to a termination of your account.  You agree to delete unused files and acknowledge that if you fail to do so, the files may be deleted for you.  You agree that you will not:</p>\r\n<ul>\r\n<li>Use email addresses obtained or accessed through {xhub:getcfg hubShortURL} to transmit the same or substantially similar unsolicited message to multiple recipients without a valid purpose specifically related to the research and education mission of {xhub:getcfg hubShortURL};</li>\r\n<li>Use {xhub:getcfg hubShortURL} to commit a criminal offense or to encourage others to conduct that would constitute a criminal offense or give rise to a civil liability;</li>\r\n<li>Violate any applicable law;</li>\r\n<li>Post or transmit any unlawful, threatening, libelous, harassing, defamatory, vulgar, obscene, pornographic, profane, or otherwise objectionable content;</li>\r\n<li>Use {xhub:getcfg hubShortURL} to impersonate other parties or entities;</li>\r\n<li>Use {xhub:getcfg hubShortURL} to upload any content that contains a software virus, \"Trojan Horse\" or any other computer code, files, or programs that may alter, damage, or interrupt the functionality of {xhub:getcfg hubShortURL} or the hardware or software of any other person who accesses {xhub:getcfg hubShortURL};</li>\r\n<li>Upload, post, email, or otherwise transmit any materials that you do not have a right to transmit under any law or under a contractual relationship;</li>\r\n<li>Alter, damage, or delete any content posted on {xhub:getcfg hubShortURL};</li>\r\n<li>Disrupt the normal flow of communication in any way;</li>\r\n<li>Claim a relationship with or speak for any business, association, or other organization for which you are not authorized to claim such a relationship;</li>\r\n<li>Post or transmit any unsolicited advertising, promotional materials, or other forms of solicitation;</li>\r\n<li>Post any material that infringes or violates the intellectual property rights of another.</li>\r\n</ul>\r\n<h3>Disclaimers</h3>\r\n<p>THE {xhub:getcfg hubShortName} AND ANY INFORMATION, PRODUCTS OR SERVICES ON IT ARE PROVIDED \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  MyInstitution and {xhub:getcfg hubShortURL} do not warrant, and hereby disclaim any warranties, either express or implied, with respect to the accuracy, adequacy or completeness of any good, service, or information obtained from {xhub:getcfg hubShortURL}.  MyInstitution does not warrant that {xhub:getcfg hubShortURL} will operate in an uninterrupted or error-free manner or that {xhub:getcfg hubShortURL} is free of viruses or other harmful components.  Use of {xhub:getcfg hubShortURL} is at your own risk.</p>\r\n<p>You agree that {xhub:getcfg hubShortURL} and its administrator, MyInstitution, shall have no liability for any consequential, indirect, punitive, special or incidental damages, whether foreseeable or unforeseeable (including, but not limited to, claims for defamation, errors, loss of data, or interruption in availability of data), arising out of or relating to your use of {xhub:getcfg hubShortURL} or any resource that you access through {xhub:getcfg hubShortURL}.</p>\r\n<p>The {xhub:getcfg hubShortURL} site hosts content from a number of authors.  The statements and views of these authors are theirs alone, and do not reflect the stances or policies of MyInstitution or their sponsors, nor does their posting imply the endorsement of MyInstitution or their sponsors.</p>\r\n<h3>Choice of Law/Forum Selection/Attorney Fees</h3>\r\n<p>You agree that any dispute arising out of or relating to {xhub:getcfg hubShortURL}, whether based in contract, tort, statutory or other law, will be governed by federal law and by the laws of MyState, excluding its conflicts of law provisions.  You further consent to the personal jurisdiction of and exclusive venue in the federal and state courts located in and serving MyCounty, MyState as the exclusive legal forums for any such dispute.</p>','',1,3,0,9,'2010-03-25 02:26:40',62,'','2010-03-26 15:18:45',63,0,'0000-00-00 00:00:00','2010-03-25 02:26:40','0000-00-00 00:00:00','','','{\"show_title\":\"1\",\"link_titles\":\"0\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_vote\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',9,0,8,'','',1,20,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (12,87,'Intellectual Property Considerations','licensing','','<p>\r\nAll materials contributed to {xhub:getcfg hubShortURL} must have clearly defined rights\r\nand privileges.  We have instituted the following guidelines for all\r\nmaterials uploaded onto this site:\r\n</p>\r\n<h3>Simulation Tools</h3>\r\n<p>\r\n<div style=\"float:left; margin:10px;\">\r\n<a href=\"http://www.opensource.org/docs/definition.php\">\r\n<img src=\"/media/system/images/open_source_button.png\"  alt=\"Open Source (OSI) Logo\"></a>\r\n</div>\r\nSimulation tools can be made available online through HUBzero\'s\r\n<a href=\"http://hubzero.org/topics/middleware\">unique middleware</a>, so\r\nusers don\'t have to download or install any source code.  As such, the\r\nsource code for your tool can be completely protected, and may not require\r\nany license.  We do encourage our developers, however, to release their\r\ntools as <a href=\"http://www.opensource.org/\">open source</a> so that\r\nothers can build upon their work.  Please check with your local institution\r\nfor details on their policy for open source release.  If you\r\ndecide to make your source code available for download, we do require\r\nthat you include some well-defined license so that our users clearly\r\nunderstand how they are allowed to use your source code.  The <a href=\"http://opensource.org/licenses/alphabetical\">licenses available on opensource.org</a> have been vetted by lawyers and can be used right out of the box.\r\n</p>\r\n\r\n<h3>Seminars and Other Materials</h3>\r\n<p>\r\n<div style=\"float:left; margin:10px;\">\r\n<a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\"><img alt=\"Creative Commons License\" style=\"border-width: 0\" src=\"/media/system/images/creativecommons-2.5.png\" style=\"float:left;\"/></a>\r\n</div>\r\nWe strongly encourage contributors of online presentations, teaching\r\nmaterials, animations, and other materials to adopt the\r\n<a href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" title=\"Learn more about Creative Commons\">Creative Commons 3.0 license</a>.\r\nThis allows others to use your work for non-commercial purposes, but\r\nthey must acknowledge you as a source and share their derivative works\r\nunder the same license.  Note that this also gives you an opportunity\r\nto build upon their work!</p>\r\n<p>\r\nWe strongly encourage all contributors to adopt these licensing guidelines.\r\nIf you want to contribute, but for some reason you are unable to agree to\r\nthese licenses, please <a href=\"/support/ticket/new\">contact us</a>,\r\nso we can follow up and discuss other options.\r\n</p>','',1,3,0,9,'2010-03-25 02:26:40',62,'','2010-03-27 15:53:32',63,0,'0000-00-00 00:00:00','2010-03-25 02:26:40','0000-00-00 00:00:00','','','{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_vote\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',13,0,7,'','',1,15,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (13,88,'Creative Commons','cc','','<h3>What is Creative Commons?</h3>\r\n\r\n<p>\r\n<img src=\"/media/system/images/cc_button.jpg\" style=\"float: left; margin: 6px;\"/>The Creative Commons (CC) enables copyright holders to grant some or all of their rights to the public while retaining others through a variety of licensing and contract schemes. {xhub:getcfg hubShortName} prefers the <a href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\">Creative Commons 3.0</a> license, which is well suited to education and academic research.  This license allows people to use your work for non-commercial purposes, but they must attribute you as a source, and they must share any derivative works under the same license.</p>\r\n\r\n<p><i>Offering your work under a CC license does not mean giving up your copyright. It means offering some of your rights to any member of the public but only on certain conditions.</i>  You may offer your work on {xhub:getcfg hubShortName} under a non-commercial license and still grant commercial licenses separately, on a case-by-case basis.</p>\r\n\r\n<p>For further information on Creative Commons visit the <a href=\"http://creativecommons.org/\">Creative Commons homepage</a>.</p>\r\n\r\n<h3>From the Creative Commons FAQ:</h3>\r\n\r\n<blockquote cite=\"http://wiki.creativecommons.org/FAQ\">\r\n<h4>What if I change my mind?</h4>\r\n<p>Creative Commons licenses are non-revocable. This means that you cannot stop someone, who has obtained your work under a Creative Commons license, from using the work according to that license. You can stop distributing your work under a Creative Commons license at any time you wish; but this will not withdraw any copies of your work that already exist under a Creative Commons license from circulation, be they verbatim copies, copies included in collective works and/or adaptations of your work. So you need to think carefully when choosing a Creative Commons license to make sure that you are happy for people to be using your work consistent with the terms of the license, even if you later stop distributing your work.</p>\r\n\r\n<h4>Do Creative Commons licenses affect fair use, fair dealing or other exceptions to copyright?</h4>\r\n<p>No. All jurisdictions allow some uses of copyrighted material without permission, such as quotation, current-affairs reporting, or parody, although these vary from country to country. These are not dependent on the license and so cannot be affected by it. To make this clear, all of our licenses include this or similar language: Nothing in this license is intended to reduce, limit, or restrict any rights arising from fair use, first sale or other limitations on the exclusive rights of the copyright owner under copyright law or other applicable laws. Thus, regardless of the jurisdiction a user is in, our licenses do not affect a user\'s right to use or allow use of content under copyright exceptions.</p>\r\n\r\n<h4>What happens if someone misuses my Creative Commons-licensed work?</h4>\r\n<p>A Creative Commons license terminates automatically if someone uses your work contrary to the license terms. This means that, if a person uses your work under a Creative Commons license and they, for example, fail to attribute your work in the manner you specified, then they no longer have the right to continue to use your work. This only applies in relation to the person in breach of the license; it does not apply generally to the other people who use your work under a Creative Commons license and comply with its terms.</p>\r\n</blockquote>','',1,3,0,9,'2010-03-25 02:26:40',62,'','2010-03-27 20:24:17',63,0,'0000-00-00 00:00:00','2010-03-25 02:26:40','0000-00-00 00:00:00','','','{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_vote\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',10,0,6,'','',1,5,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (14,89,'Submitting Content','license','','<p>\r\n		THE WORK (AS DEFINED BELOW) IS PROVIDED UNDER THE TERMS OF THIS LICENSE.  THE WORK IS PROTECTED BY COPYRIGHT AND/OR OTHER APPLICABLE LAW.  ANY USE OF THE WORK OTHER THAN AS AUTHORIZED UNDER THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.\r\n	</p>\r\n	<p>\r\n		{xhub:getcfg hubShortURL} ACCEPTS AND AGREES TO BE BOUND BY THE TERMS OF THIS LICENSE.  THE LICENSOR (YOU) GRANTS {xhub:getcfg hubShortURL} THE RIGHTS CONTAINED HERE IN CONSIDERATION OF {xhub:getcfg hubShortURL}\'S ACCEPTANCE OF SUCH TERMS AND CONDITIONS.\r\n	</p>\r\n	<ol>\r\n	 <li>Definitions\r\n		<ol>\r\n		 <li>\"Collective Work\" means a work, such as a periodical issue, anthology or encyclopedia, in which the Work in its entirety in unmodified form, along with a number of other contributions, constituting separate and independent works in themselves, are assembled into a collective whole.  A work that constitutes a Collective Work will not be considered a Derivative Work (as defined below) for the purposes of this License.</li>\r\n		 <li>\"Derivative Work\" means a work based upon the Work or upon the Work and other pre-existing works, such as a translation, musical arrangement, dramatization, fictionalization, motion picture version, sound recording, art reproduction, abridgment, condensation, or any other form in which the Work may be recast, transformed, or adapted, except that a work that constitutes a Collective Work will not be considered a Derivative Work for the purpose of this License.  For the avoidance of doubt, where the Work is a musical composition or sound recording, the synchronization of the Work in timed-relation with a moving image (\"synching\") will be considered a Derivative Work for the purpose of this License.</li>\r\n		 <li>\"Licensor\" means the individual or entity that offers the Work under the terms of this License.</li>\r\n		 <li>\"Original Author\" means the individual or entity who created the Work.</li>\r\n		 <li>\"Work\" means the copyrightable work of authorship offered under the terms of this License.</li>\r\n		</ol>\r\n	 </li>\r\n	 <li>License Grant\r\n		<p>Subject to the terms and conditions of this License, Licensor hereby grants {xhub:getcfg hubShortURL} a worldwide, royalty-free, non-exclusive, perpetual (for the duration of the applicable copyright) license to exercise the rights in the Work as stated below:</p>\r\n		<ol>\r\n		 <li>to reproduce the Work, to incorporate the Work into one or more Collective Works, and to reproduce the Work as incorporated in the Collective Works;</li>\r\n		 <li>to create and reproduce Derivative Works;</li>\r\n		 <li>to distribute copies or phonorecords of, display publicly, perform publicly, and perform publicly by means of a digital audio transmission the Work including as incorporated in Collective Works;</li>\r\n		 <li>to distribute copies or phonorecords of, display publicly, perform publicly, and perform publicly by means of a digital audio transmission Derivative Works;</li>\r\n		</ol>\r\n		<p>The above rights may be exercised in all media and formats whether now known or hereafter devised.  The above rights include the right to make such modifications as are technically necessary to exercise the rights in other media and formats.  All rights not expressly granted by Licensor are hereby reserved, including but not limited to the rights set forth in Sections 4(d) and 4(e).</p>\r\n	</li>\r\n	<li>Representations, Warranties and Disclaimer\r\n		<p>UNLESS OTHERWISE MUTUALLY AGREED BY THE PARTIES IN WRITING, LICENSOR AND {xhub:getcfg hubShortURL} BOTH OFFER THE WORK AS-IS AND MAKE NO REPRESENTATIONS OR WARRANTIES OF ANY KIND CONCERNING THE WORK, EXPRESS, IMPLIED, STATUTORY OR OTHERWISE, INCLUDING, WITHOUT LIMITATION, WARRANTIES OF TITLE, MERCHANTIBILITY, FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT OR OTHER DEFECTS, ACCURACY, OR THE PRESENCE OF ABSENCE OF ERRORS, WHETHER OR NOT DISCOVERABLE.  SOME JURISDICTIONS DO NOT ALLOW THE EXCLUSION OF IMPLIED WARRANTIES, SO SUCH EXCLUSION MAY NOT APPLY IN ALL SITUATIONS.</p>\r\n	</li>\r\n	<li>Limitation on Liability\r\n		<p>EXCEPT TO THE EXTENT REQUIRED BY APPLICABLE LAW, IN NO EVENT WILL LICENSOR HOLD {xhub:getcfg hubShortURL} LIABLE ON ANY LEGAL THEORY FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL, PUNITIVE OR EXEMPLARY DAMAGES ARISING OUT OF THIS LICENSE OR THE USE OF THE WORK, EVEN IF LICENSOR AND/OR {xhub:getcfg hubShortURL} HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.</p>\r\n	</li>\r\n	<li>Termination\r\n		<ol>\r\n		 <li>This License and the rights granted hereunder will terminate automatically upon any breach by {xhub:getcfg hubShortURL} of the terms of this License.  Individuals or entities who have received Collective Works or Derivative Works from {xhub:getcfg hubShortURL} under this License, however, will not have their licenses terminated provided such individuals or entities remain in full compliance with those licenses.  Sections 1, 2, 5, 6, 7, and 8 will survive any termination of this License.</li>\r\n		 <li>Subject to the above terms and conditions, the license granted here is perpetual (for the duration of the applicable copyright in the Work).  Notwithstanding the above, Licensor reserves the right to release the Work under different license terms or to stop distributing the Work at any time; provided, however that any such election will not serve to withdraw this License (or any other license that has been, or is required to be, granted under the terms of this License), and this License will continue in full force and effect unless terminated as stated above.</li>\r\n		</ol>\r\n	 </li>\r\n	 <li>Miscellaneous\r\n		<ol>\r\n		 <li>Each time {xhub:getcfg hubShortURL} distributes or publicly digitally performs the Work, a Collective Work, or a Derivative Work, the Licensor offers to the recipient a license to the Work on the same terms and conditions as the license granted to {xhub:getcfg hubShortURL} under this License.</li>\r\n		 <li>If any provision of this License is invalid or unenforceable under applicable law, it shall not affect the validity or enforceability of the remainder of the terms of this License, and without further action by the parties to this agreement, such provision shall be reformed to the minimum extent necessary to make such provision valid and enforceable.</li>\r\n		 <li>No term or provision of this License shall be deemed waived and no breach consented to unless such waiver or consent shall be in writing and signed by the party to be charged with such waiver or consent.</li>\r\n		 <li>This License constitutes the entire agreement between the parties with respect to the Work licensed here.  There are no understandings, agreements or representations with respect to the Work not specified here.  Neither Licensor nor {xhub:getcfg hubShortURL} shall be bound by any additional provisions that may appear in any communication between the parties.  This License may not be modified without the mutual written agreement of the Licensor and {xhub:getcfg hubShortURL}.</li>\r\n		</ol>\r\n	 </li>\r\n	</ol>','',1,3,0,9,'2010-03-25 02:26:40',62,'','0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00','2010-03-25 02:26:40','0000-00-00 00:00:00','','','{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_vote\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_pdf_icon\":\"0\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',7,0,5,'','',1,1,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (22,90,'Discover','discover','','{xhub:include type=\"stylesheet\" filename=\"pages/discover.css\"}\r\n<div class=\"grid\">\r\n	<div class=\"col span-quarter\">\r\n		<h2>Do More</h2>\r\n	</div>\r\n\r\n	<div class=\"col span-quarter\">\r\n		<div class=\"presentation\">\r\n			<h3><a href=\"/resources\">Resources</a></h3>\r\n			<p>Find the latest cutting-edge research in our <a href=\"/resources\">resources</a>.</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"col span-quarter\">\r\n		<div class=\"quote\">\r\n			<h3><a href=\"/citations\">Citations</a></h3>\r\n			<p>See who has <a href=\"/citations\">cited</a> our content in their work.</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"col span-quarter omega\">\r\n		<div class=\"tag\">\r\n			<h3><a href=\"/tags\">Tags</a></h3>\r\n			<p>Explore all our content through <a href=\"/tags\">tags</a> or even tag content yourself.</p>\r\n		</div>\r\n	</div>\r\n</div>\r\n\r\n<div class=\"grid below\">\r\n	<div class=\"col span-quarter offset-quarter\">\r\n		<div class=\"blog\">\r\n			<h3><a href=\"/blog\">Blog</a></h3>\r\n			<p>Read the <a href=\"/blog\">latest entry</a> or browse the archive for articles of interest.</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"col span-quarter\">\r\n		<div class=\"wiki\">\r\n			<h3><a href=\"/wiki\">Wiki</a></h3>\r\n			<p>Browse our user-generated <a href=\"/wiki\">wiki pages</a> or write your own.</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"col span-quarter omega\">\r\n		<div class=\"feedback\">\r\n			<h3><a href=\"/feedback\">Feedback</a></h3>\r\n			<p>Like something? Having trouble? <a href=\"/feedback\">Let us know what you think!</a></p>\r\n		</div>\r\n	</div>\r\n</div>\r\n\r\n<div class=\"grid\">\r\n	<div class=\"col span-quarter\">\r\n		<h2>Services</h2>\r\n	</div>\r\n	<div class=\"col span-quarter\">\r\n		<div class=\"contribute\">\r\n			<h3><a href=\"/resources/new\">Upload</a></h3>\r\n			<p><a href=\"/resources/new\">Publish</a> your own tools, seminars, and other content on this site.</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"col span-quarter\">\r\n		<div class=\"tool\">\r\n			<h3><a href=\"/tools\">Tool Forge</a></h3>\r\n			<p>The <a href=\"/tools\">development area</a> for simulation tools. Sign up and manage your own software project!</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"col span-quarter omega\">\r\n		<div class=\"cart\">\r\n			<h3><a href=\"/store\">Store</a></h3>\r\n			<p><a href=\"/store\">Purchase items</a> such as t-shirts using points you earn by helping out.</p>\r\n		</div>\r\n	</div>\r\n</div>\r\n\r\n<div class=\"grid\">\r\n	<div class=\"col span-quarter\">\r\n		<h2>What\'s Happening</h2>\r\n	</div>\r\n	<div class=\"col span-quarter\">\r\n		<div class=\"event\">\r\n			<h3><a href=\"/events\">Events</a></h3>\r\n			<p>Find information about the many upcoming <a href=\"/events\">public meetings and scientific symposia</a>.</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"col span-quarter\">\r\n		<div class=\"new\">\r\n			<h3><a href=\"/whatsnew\">What\'s New</a></h3>\r\n			<p>Find the latest content posted on the site with our <a href=\"/whatsnew\">What\'s New</a> section.</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"col span-quarter omega\">\r\n		<div class=\"poll\">\r\n			<h3><a href=\"/poll\">Poll</a></h3>\r\n			<p>Respond to our poll questions and <a href=\"/poll\">see what everyone else is thinking</a>.</p>\r\n		</div>\r\n	</div>\r\n</div>', '', '1', '0', '0', '2', '2010-03-27 16:47:23', '62', '', '2013-08-29 16:38:40', '1000', '0', '0000-00-00 00:00:00', '2010-03-27 16:47:23', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',13,0,4,'','',1,155,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',0,'*','');
INSERT INTO `#__content` VALUES (32,91,'Congratulations','congratulations','','{xhub:include type=\"stylesheet\" filename=\"pages/congrats.css\"}\r\n\r\n<div id=\"features\">\r\n<div class=\"wrap\">\r\n	<div class=\"three columns first\">\r\n<div class=\"use\">\r\n		<h3>Utilize</h3>\r\n		<p>View tutorials and read about how to use the numerous features of a hub. We show you how to add content, customize your dashboard, create groups, and more.</p>\r\n		<p class=\"btn-container\"><a class=\"btn\" href=\"http://hubzero.org/documentation/1.1.0/users\" rel=\"external\">User documentation</a></p>\r\n</div>\r\n	</div>\r\n	<div class=\"three columns second\">\r\n<div class=\"manage\">\r\n		<h3>Manage</h3>\r\n		<p>Read the manual for managing the content and functionality of a hub. It progresses step-by-step through various common tasks and familiarizes you with the administrative interface.</p>\r\n		<p class=\"btn-container\"><a class=\"btn\" href=\"http://hubzero.org/documentation/1.1.0/managers\" rel=\"external\">Manager documentation</a></p>\r\n</div>\r\n	</div>\r\n	<div class=\"three columns third\">\r\n<div class=\"customize\">\r\n		<h3>Extend</h3>\r\n		<p>Build your own extensions and discover how to extend or tailor the existing ones to your needs. We try to guide you through the creation steps and provide examples for download.</p>\r\n		<p class=\"btn-container\"><a class=\"btn\" href=\"http://hubzero.org/documentation/1.1.0/webdevs\" rel=\"external\">Developer documentation</a></p>\r\n</div>\r\n	</div>\r\n	<div class=\"clear\"></div>\r\n</div>\r\n</div>\r\n\r\n<div class=\"highlight-section\">\r\n	<p>\r\n		Ready to go? Jump to the <a rel=\"external\" href=\"/administrator\">administration</a> or learn how to <a href=\"http://hubzero.org/documentation/1.1.0/managers/articles.homepage\" rel=\"external\">change this page</a>.\r\n	</p>\r\n</div><!-- / .highlight-section -->\r\n\r\n<div class=\"support-section\">\r\n<div class=\"wrap\">\r\n	<div class=\"four columns first\">\r\n		<h2>Support</h2>\r\n		<p>\r\n			If you need help or support while developing your hub, reach out to us.\r\n		</p>\r\n	</div>\r\n	<div class=\"four columns second third fourth\">\r\n		<div class=\"two columns first\">\r\n			<h3>I have an idea!</h3>\r\n			<p>\r\n				Think something can be done better or is missing? Post your <a href=\"http://hubzero.org/wishlist\" rel=\"external\">ideas or feature requests</a>. We\'d love to hear from you.\r\n			</p>\r\n		</div>\r\n		<div class=\"two columns second\">\r\n			<h3>I have an error!</h3>\r\n			<p>\r\n				We continually test our code and strive for a smooth, error-free experience but, sadly, we can make mistakes. If you found a bug, <a href=\"http://hubzero.org/support/ticket/new\" rel=\"external\">let us know</a>.\r\n			</p>\r\n		</div>\r\n		<div class=\"clear\"></div>\r\n	</div>\r\n	<div class=\"clear\"></div>\r\n</div>\r\n</div><!-- / .inner -->\r\n\r\n<div class=\"blocks-section wrap\">\r\n	<div class=\"four columns first\">\r\n		<h2>Community</h2>\r\n		<p>\r\n			Connect with the growing HUBzero developer community and see what your peers have to say.\r\n		</p>\r\n	</div>\r\n	<div class=\"four columns second third fourth\">\r\n		<div class=\"two columns first\">\r\n			<h3>Groups</h3>\r\n			<p>\r\n				Members working together. <a rel=\"external\" href=\"http://hubzero.org/groups\">Groups</a> allow <a rel=\"external\" href=\"http://hubzero.org/members\">members</a> with similar interests to get in touch with each other and collaborate on projects.\r\n			</p>\r\n		</div>\r\n		<div class=\"two columns second\">\r\n			<h3>Wiki</h3>\r\n			<p>\r\n				The <a rel=\"external\" href=\"http://hubzero.org/wiki\">wiki</a> is a space where you can share work, ideas, pictures, links, and media &mdash; and just about anything else you can think of.\r\n			</p>\r\n		</div>\r\n		<div class=\"clear\"></div>\r\n\r\n		<div class=\"two columns first\">\r\n			<h3>Questions &amp; Answers</h3>\r\n			<p>\r\n				This is where you can <a rel=\"external\" href=\"http://hubzero.org/answers\">ask questions</a>, get answers, and help others in the community.\r\n			</p>\r\n		</div>\r\n		<div class=\"two columns second\">\r\n			<h3>Forums</h3>\r\n			<p>\r\n				A place for you to start a <a rel=\"external\" href=\"http://hubzero.org/forum\">discussion</a> or find out what everyone is talking about.\r\n			</p>\r\n		</div>\r\n		<div class=\"clear\"></div>\r\n	</div>\r\n	<div class=\"clear\"></div>\r\n</div><!-- / .inner -->','',1,0,0,2,'2012-09-07 16:55:44',1008,'','2012-09-07 19:16:06',1008,0,'0000-00-00 00:00:00','2012-09-07 16:55:44','0000-00-00 00:00:00','','','{\"show_title\":\"0\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_vote\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_pdf_icon\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',2,0,2,'','',1,7,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (27,92,'Privacy Policy','privacy','','<p>We respect your privacy. We will never sell your e-mail address or other personally identifiable information to third parties, or make that information publicly available without your permission.</p>\r\n<p>We are a scientific project and we provide a free service, so we do track your activities on this site.  We combine your usage metrics with others to create an aggregate picture of how the site is being used, and we report <a href=\"usage\">that usage</a> publicly on our site and send similar quarterly reports to our program sponsors.  However, such usage reports never contain detailed information about your activities as an individual without your prior consent.</p>\r\n<p>From time to time, we work with other other projects that seek to study social interactions on the site.  We may share your activities with those groups, but they are bound by a Memorandum of Understanding to follow our policies and respect your privacy in the same way that we do.  We may contact you on their behalf and ask you to participate in their study, but your participation is voluntary, and your information will not be publicly released without your prior consent.</p>\r\n<p>We reserve the right to contact you to request additional information or to keep you updated on changes to {xhub:getcfg hubShortURL}. You may opt out of receiving newsletters and other non-essential communications by updating the settings in your account profile.</p>\r\n<p>All resources, wiki articles, blogs, questions, answers, or other information posted or stored on {xhub:getcfg hubShortURL} is potentially available to all other users of {xhub:getcfg hubShortURL}.  We do our best to restrict access to source code and to other private materials shared within groups.  However, we are a research project and our software is constantly changing.  We disclaim any responsibility or capability for the preservation of confidentiality of any information posted on this site. <em>Do not post or store information on {xhub:getcfg hubShortURL} if you expect to or are obligated to protect the confidentiality of that information.</em></p>\r\n<h3>Changes to policy</h3>\r\n<p>We may occasionally update our Privacy Policy to reflect changes in our practices and services. If we make material changes in the way we collect, use, or share your personal information, we will notify you and/or prominently post notices of the changes on our website.</p>','',1,3,0,9,'2012-05-02 12:15:06',62,'','2012-05-02 12:20:30',62,0,'0000-00-00 00:00:00','2012-05-02 12:15:06','0000-00-00 00:00:00','','','{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_vote\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_pdf_icon\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',2,0,4,'','',1,0,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (28,93,'Abuse Policy','abuse','','<p>\r\nYou are responsible at all times for using {xhub:getcfg hubShortURL} in a manner that is legal, ethical, and not to the detriment of others.  Once you have created an account, you are allowed to post materials and participate in other social networking features available on this site.  All members are encouraged to help moderate content and click on \"report abuse\" links to report any material deemed offensive or inappropriate.  If your posted material is reported as abusive, it will be immediately withdrawn and subsequently reviewed by a site administrator.  If the material is judged to be appropriate, it will be restored.  Otherwise, it will be removed from the site, and depending on the inappropriate nature of the content, your account may be terminated.\r\n</p><p>\r\nAll users must recognize that system resources on {xhub:getcfg hubShortURL} are limited.  Quotas for disk storage, job submissions, and other limited resources are strictly enforced. By using {xhub:getcfg hubShortURL}, you agree to delete unused files and acknowledge that if you fail to do so, the files may be deleted for you.  You may request an increase in system quotas, and you may use points to pay for premium services, but you may not circumvent the policies put in place to manage resources.\r\n</p><p>\r\n<em>Creating multiple accounts or otherwise gaming the system in order to earn extra points, to increase your disk quota, or to gain an unfair share of other system resources is strictly prohibited and may lead to termination of your account.</em></p>\r\n<p>\r\nBy using {xhub:getcfg hubShortURL}, you agree that:\r\n</p>\r\n<ul>\r\n <li>You will not use {xhub:getcfg hubShortURL} to commit a criminal offense or to encourage others to conduct what would constitute a criminal offense or give rise to a civil liability;</li>\r\n <li>You will not violate any applicable law;</li>\r\n <li>You will not post or transmit any unlawful, threatening, libelous, harassing, defamatory, vulgar, obscene, pornographic, profane, or otherwise objectionable content;</li>\r\n <li>You will not use {xhub:getcfg hubShortURL} to impersonate other parties or entities;</li>\r\n <li>You will not use {xhub:getcfg hubShortURL} to upload any content that contains a software virus, \"Trojan Horse\" or any other computer code, files, or programs that may alter, damage, or interrupt the functionality of {xhub:getcfg hubShortURL} or the hardware or software of any other person who accesses {xhub:getcfg hubShortURL};</li>\r\n <li>You will not post any material that infringes or violates the intellectual property rights of another;</li>\r\n <li>You will not redistribute resource materials posted on {xhub:getcfg hubShortURL} or create derivative works unless it is allowed by the license terms posted for a resource;</li>\r\n <li>You will not alter, damage, or delete any content posted on {xhub:getcfg hubShortURL};</li>\r\n <li>You will not claim a relationship with or speak for any business, association, or other organization for which you are not authorized to claim such a relationship;</li>\r\n <li>You will not post or transmit any unsolicited advertising, promotional materials, or other forms of solicitation;</li>\r\n <li>You will not use email addresses obtained or accessed through {xhub:getcfg hubShortURL} to transmit the same or substantially similar unsolicited message to multiple recipients without a valid purpose specifically related to the research and education mission of the {xhub:getcfg hubShortURL};</li>\r\n</ul>','',1,3,0,9,'2012-05-02 12:19:12',62,'','2012-05-02 12:20:14',62,0,'0000-00-00 00:00:00','2012-05-02 12:19:12','0000-00-00 00:00:00','','','{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_vote\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_pdf_icon\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',2,0,3,'','',1,0,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (29,94,'Legal','legal','','<p class=\"warning\">\r\nEdit this page and fill in contact information for your project, or unpublish it if you think it is unnecessary.  The following text is just\r\na suggestion for the policies that you may want to highlight, and your contact for legal issues.\r\n</p>\r\n\r\n<h3>Policies</h3>\r\n<p>Review {xhub:getcfg hubShortURL}\'s <a href=\"/legal/terms\">Terms of Use</a>, <a href=\"/legal/privacy\">Privacy Policy</a> or <a href=\"/legal/abuse\">Abuse Policy</a>.</p>\r\n\r\n<h3>Legal Contacts</h3>\r\n<div class=\"two columns first\" id=\"getintouch\">\r\n	{xhub:module position=\"contact\"}\r\n</div><!-- / .two columns first -->\r\n<div class=\"two columns second\">\r\n	<div class=\"vcard\">	\r\n		<address class=\"adr\">\r\n			<span class=\"fn org\">{Your Organization}</span><br />\r\n			<span class=\"street-address\">{Street Address}</span><br />\r\n			<span class=\"locality\">{City}</span>, <span class=\"region\">{Region/Stqte}</span> <span class=\"postal-code\">{Postal Code}</span><br />\r\n			<span class=\"country-name\">{Country}</span>\r\n		</address>\r\n		<p>\r\n			<span class=\"tel\"><span class=\"type\">Phone</span> +{Telephone}</span>\r\n		</p>\r\n	</div><!-- / .vcard -->\r\n</div><!-- / .two columns second -->','',1,3,0,9,'2012-05-02 12:21:09',62,'','0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00','2012-05-02 12:21:09','0000-00-00 00:00:00','','','{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_vote\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_pdf_icon\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',1,0,2,'','',1,2,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (30,95,'HUBzero Accessibility Statement','accessibility','','<div id=\"getintouch\" style=\"width:350px; float:right; margin:0px 0px 15px 25px; border: #cccccc 1px solid; padding:0px 10px 10px 10px;\">\r\n	{xhub:module position=\"accessibilitycontact\"}\r\n</div>\r\n\r\n<div>\r\n<h3>An Open Commitment</h3>\r\n<p>Our web site is built on the <a href=\"http://hubzero.org\">HUBzero&reg;</a> software platform.  The HUBzero team is committed to creating websites that are accessible to the widest possible audience, regardless of technology or ability.  If you find accessibility problems with our site, please report them so we can take corrective action.</p>\r\n\r\n<h3>Guidelines, Standards and Testing</h3>\r\n<p>Our site has been developed according to the following standards:</p>\r\n<dl>\r\n	<dt>Section 508</dt>\r\n	<dd>\r\n		<p>This website endeavors to meet or exceed the requirements of <a href=\"http://www.access-board.gov/508.htm\">Section 508 of the Rehabilitation Act</a>.</p>\r\n	</dd>\r\n	\r\n	<dt>WCAG 2.0</dt>\r\n	<dd>\r\n		<p>This website endeavors to conform to level AA standards, and where possible strive for AAA, as defined by <a href=\"http://www.w3.org/TR/WCAG20\" rel=\"external\">W3C\'s Web Content Accessibility Guidelines (WCAG) 2.0</a>. These guidelines provide web authors and designers with recommendations to help provide website content that is accessible to all users.</p>\r\n	</dd>\r\n	\r\n	<dt>Coding Standards</dt>\r\n	<dd>\r\n		<p>Pages on this site have been authored to be compliant with current W3C standards for <a href=\"http://www.w3.org/TR/xhtml1/\" rel=\"external\">HTML (XHTML 1.0 Strict)</a> and <a href=\"http://www.w3.org/TR/CSS21/\" rel=\"external\">CSS</a>. Standards-compliant code helps to ensure that visitors using assistive technologies (such as screen readers) are able to access the site contents.</p>\r\n	</dd>\r\n	\r\n	<dt>Additional Testing</dt>\r\n	<dd>\r\n		<p></p>\r\n		<p>In addition to reviewing for compliance with the standards noted above, we periodically test with such technologies as the <a href=\"http://wave.webaim.org/\" rel=\"external\">Web Accessibility Evaluation Tool</a>, <a href=\"http://achecker.ca/checker/index.php\" rel=\"external\">AChecker</a>, and try to test with a range of assistive technologies (e.g., JAWS and WindowEyes screen readers). We also appreciate any input from third parties and assistive technology users from the community.</p>\r\n	</dd>\r\n</dl>\r\n\r\n<h3>Contributed Content</h3>\r\n<p>While we make every effort to make sure that all pages designed and maintained by us are fully accessible, the accessibility of some contributed content is most often beyond our control.</p>\r\n</div>','',1,3,0,9,'2012-05-02 12:28:16',62,'','0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00','2012-05-02 12:28:16','0000-00-00 00:00:00','','','{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_vote\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_pdf_icon\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"language\":\"\",\"keyref\":\"\",\"readmore\":\"\"}',1,0,1,'','',1,0,'robots=\nauthor=',0,'','');
INSERT INTO `#__content` VALUES (31,96,'Community','community','','{xhub:include type=\"stylesheet\" filename=\"pages/community.css\"}\r\n\r\n<div class=\"tagline\">\r\n	<p>Join the community!</p>\r\n</div>\r\n\r\n<div class=\"about odd members\">\r\n	<h3><a href=\"/members\">Members</a></h3>\r\n	<p>As a member, you instantly become part of a community designed for you and your colleagues.  Browse the <a href=\"/members\">profiles</a> of people who have joined this site. Find members with similar <a href=\"/tags\">interests</a>.</p>\r\n</div>\r\n\r\n<div class=\"about even groups\">\r\n	<h3>Groups</h3>\r\n	<p>Members working together! Groups are an easy way to share content and conversation, either privately or with the world.  Explore our <a href=\"/groups\">groups</a> and get in touch with <a href=\"/members\">members</a> with similar interests.</p>\r\n</div>\r\n\r\n<div class=\"about odd answers\">\r\n	<h3><a href=\"/answers\">Questions &amp; Answers</a></h3>\r\n	<p>Submit a question to our community and get an answer from real people. <a href=\"/answers/new\">Ask questions</a>, get <a href=\"/answers\">answers</a>, and help others.</p>\r\n</div>\r\n\r\n<div class=\"about even forum\">\r\n	<h3><a href=\"/forum\">Forum</a></h3>\r\n	<p>A place for you to start a <a href=\"/forum\">discussion</a> or find out what everyone is talking about.</p>\r\n</div>', '', '1', '0', '0', '2', '2012-09-07 16:33:42', '1008', '', '2013-08-29 16:43:06', '1000', '0', '0000-00-00 00:00:00', '2012-09-07 16:33:42', '0000-00-00 00:00:00', '', '', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_layout\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}',4,0,3,'','',1,10,'{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}',0,'*','');

--
-- HUBzero sample data for table `#__events_config`
--

INSERT INTO `#__events_config` (`param`, `value`) VALUES ('adminmail','');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('adminlevel','0');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('starday','0');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('mailview','NO');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('byview','NO');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('hitsview','NO');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('repeatview','NO');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('dateformat','0');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('calUseStdTime','NO');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('navbarcolor','');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('startview','month');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('calEventListRowsPpg','30');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('calSimpleEventForm','YES');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('defColor','');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('calForceCatColorEventForm','NO');
INSERT INTO `#__events_config` (`param`, `value`) VALUES ('fields','');

--
-- HUBzero sample data for table `#__faq`
--

INSERT INTO `#__faq` VALUES (1,'What are groups?','general','uploadpath=/site/kb\nshow_authors=1\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial\nshow_date=2','<h4>Work together with your colleagues</h4>\r\n	<p>Create a group to organize your interactions.  Group members can:</p>\r\n	<ul>\r\n	<li>Post content that only other group members are allowed to see\r\n	<li>Export their content to other web sites, and brand it with their own logo\r\n</ul>\r\n	<h4>Create a new group</h4>\r\n	<p>You can <a href=\"/groups/new\">create your own group</a> of users.  Just fill in a simple form choosing a group name, a title, and a brief description, so that others will know what your group is about.  Once created, your group title and description will be available for all to see in the <a href=\"/groups/browse\">list of all groups</a>.  Each group also has its own page, which contains a link that other users can click on to request membership.</p>\r\n	<h4>Managing group members</h4>\r\n	<p>Whenever another user requests membership, you will receive an email asking you to approve their request.  To do this, log in and visit the <a href=\"/groups\">groups</a> page and find your group name.  If you\'re logged in, you should see a <i>[manage]</i> link next to the group name.  Clicking on that link will bring up a page showing a list of users who have requested membership.  Use the controls on that page to approve or deny their request.  You can use the same page to promote ordinary users to also act as managers, so they can help you approve or deny requests.  You can also demote or remove users from your group.<br />\r\nOnce removed from a group, a user will no longer have access to protected or private group resources.  Of course, they can always rejoin the group at any point by requesting membership and going through the usual approval process.<br />\r\n<strong>Note:</strong> All groups must have at least one manager. If you are the last manager of a group, you will <em>not</em> be able to demote or remove yourself from the group.\r\n</p>','2011-03-31 15:10:54',62,'2011-03-31 15:10:54',62,0,'0000-00-00 00:00:00',1,0,3,1,1,0,0,0);
INSERT INTO `#__faq` VALUES (2,'Why is Hispanic / Latino not a racial background choice?','hispanic','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>According to U.S. government guidelines, ethnic heritage and racial background are to be separate, distinct questions and responses.  \\\"Ethnic Heritage\\\" defines membership in cultural groups such as Hispanic / Latino, whereas \\\"Racial Background\\\" is based on ancestry and genetic groups.  This issue is handled in various ways outside the U.S., and the current standards continue to evolve.  We realize this distinction may be somewhat confusing, but we must conform to the latest reporting standards required by the government.<br />\r\nMore precise definitions of the various racial background and ethnic heritage choices are as follows:</p>\r\n	<h3>Racial Background</h3>\r\n	<ul>\r\n	<li><b>American Indian or Alaska Native</b><br />\r\nPersons having origins in any of the original peoples of North and South America (including Central America), and who maintains cultural identification through tribal affiliation or community recognition.\r\n</li>\r\n	<li><b>Asian</b><br />\r\nPersons having origins in any of the original peoples of the Far East, Southeast Asia or the Indian subcontinent, including for example, Cambodia, China, India, Japan, Korea, Malaysia, Pakistan, the Philippine Islands, Thailand, and Vietnam.\r\n</li>\r\n	<li><b>Black or African American</b><br />\r\nPersons having origins in any of the black racial groups of Africa.\r\n</li>\r\n	<li><b>Native Hawaiian or Other Pacific Islander</b><br />\r\nPersons having origins in any of the original peoples of Hawaii, Guam, Samoa, or other Pacific Islands.\r\n</li>\r\n	<li><b>White</b><br />\r\nPersons having origins in any of the original peoples of Europe, the Middle East, or North Africa.\r\n</li>\r\n	</ul>\r\n	<h3>Ethnic Heritage</h3>\r\n	<ul>\r\n	<li><b>Hispanic or Latino</b><br />\r\nPersons of Cuban, Mexican, Puerto Rican, Central or South American, or other Spanish culture of origin, regardless of race.\r\n</li>\r\n	</ul>','2011-03-31 17:21:07',69,'2011-03-31 17:21:07',69,0,'0000-00-00 00:00:00',1,0,2,1,2,0,0,0);
INSERT INTO `#__faq` VALUES (3,'Why can\\\'t I log in?','login','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>Have you registered? You must register in order to log in. If you have registered and you still cannot log in then check and double-check your username and password. Usually this is the problem; if not, contact <a href=\\\"/support/report_problems/\\\" title=\\\"Report problem form\\\">support</a>.\n</p>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,1,1,2,0,0,0);
INSERT INTO `#__faq` VALUES (4,'I registered but cannot log in!','login2','uploadpath=/site/kb\nshow_authors=1\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial\nshow_date=2','<ul>\r\n<li>If this is a <b>new account</b>, you won\'t be able to log in until you\'ve confirmed your e-mail address.  Right after you registered, you should have received an e-mail at the address that you registered with us.  This e-mail contains a special link.  Click on the link to prove that you can receive e-mail from us.  If you did not receive the e-mail, make sure that you did not misspell your e-mail address when you registered with us.  Check your junk mail folder to see if the e-mail message wound up there.</li>\r\n<li>If this is an <b>old account</b>, check that you are entering the correct username and password.  If you\'ve forgotten your password, you can <a href=\"/user/reset\">recover it</a>.</li>\r\n<li>In either case, make sure that <a href=\"/kb/misc/cookies\">cookies are enabled</a> for your browser.  If all else fails, <a href=\"/support/ticket/new\" title=\"Report problems form\">report the problem</a> in our support area.</li>\r\n</ul>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,2,0,0,0);
INSERT INTO `#__faq` VALUES (5,'I registered in the past but cannot log in anymore!','login3','uploadpath=/site/kb\nshow_authors=1\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial\nshow_date=2','<p>You may have entered an incorrect username or password.  If you\'ve forgotten either one, you can <a href=\"/user/remind\">recover your username</a> or <a href=\"/user/reset\">recover your password</a>.  Just fill out the form, and we\'ll send your account information to the e-mail address that you registered with your account.  If you\'ve changed e-mail addresses and can no longer recover your account information, <a href=\"/support/report_problems/\" title=\"Report problems form\">contact support</a>, and we\'ll help you recover your account.\r\n</p>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,4,1,2,0,0,0);
INSERT INTO `#__faq` VALUES (6,'I\'ve lost my password!','pwreset','uploadpath=/site/kb\nshow_authors=1\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial\nshow_date=2','<p>Don\'t panic!  We can <a href=\"/user/reset\">reset your password</a> and send instructions to the e-mail address that you have on file with us.  Then, you can follow the instructions, log in to the site, and change your password to anything you like.\r\n</p><p>\r\n<b>Note:</b>  If you don\'t receive an e-mail after resetting your password, check your junk mail folder and make sure that it didn\'t get filed there by mistake.  If you no longer have access to the e-mail address that you have on file with us, <a href=\"/support/report_problems/\">contact support</a> and we\'ll help you recover your account.\r\n</p>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,2,0,0,0);
INSERT INTO `#__faq` VALUES (7,'Why do I get logged off automatically?','autologout','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>If you do not check the <i>Remember login</i> box when you log in, the site will only keep you logged in for a short time.  This prevents misuse of your account by anyone else.  To stay logged in, check the box during login.  This is not recommended if you access the site from a shared computer--e.g., in a library, internet cafe, university lab, etc.\n</p>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,1,1,2,0,0,0);
INSERT INTO `#__faq` VALUES (8,'Why do I need to register at all?','register','uploadpath=/site/kb\nshow_authors=1\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial\nshow_date=2','<p>Registration will give you access to additional features not available to guest users, including access to simulation/modeling tools, the ability to ask questions, create private groups, participate in discussions, rate resources, and more.  The registration process is completely automatic and it takes just a few minutes.  Your registration also helps us sustain this project.  Our funding agency periodically reviews statistics about the number of users that access our site.  By registering and filling in your personal profile, you are helping to justify our existence and continue our funding.\r\n</p>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,2,0,0,0);
INSERT INTO `#__faq` VALUES (9,'How do I change my password?','pwchange','uploadpath=/site/kb\nshow_authors=1\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial\nshow_date=2','<p>We have an online form to <a href=\"/members/myaccount\" title=\"Change password form\">change your password</a>.  You can use the link included here, or you can find the same link on the page that you go to when you first <a href=\"/login\">log in</a> to this site.</p>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,2,0,0,0);
INSERT INTO `#__faq` VALUES (10,'How do I change my username?','username','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>Sorry, but login names cannot be changed.  If this is poses a serious problem for you, please <a href=\\\"/support/report_problems/\\\" title=\\\"Trouble report page\\\">contact our support team</a>.\n</p>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,2,0,0,0);
INSERT INTO `#__faq` VALUES (11,'How to View/Download Video Content?','video','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>This hub relies on two formats of video files, MP4 (MPEG-4) mostly used for podcasts but  also can be viewed directly on your computer, and Windows Media Player which is used by older lectures and seminars.  In general we sugguest Apple Quicktime for playing MP4 files, however there are a variety of MP4 players available.<br />\nWe recommend VideoLAN.org\\\'s <a href=\\\"http://www.videolan.org/\\\" rel=\\\"external\\\">VLC - Media Player</a>, a free cross-platform media player that supports a large number of multimedia formats, without the need for additional codecs. It will play both the MP4 and Windows Media Player files. You will have to copy and paste the video URL from your browser to the VLC player (menu <em>file-&gt;open network</em>). Below are operating system specific issues for those using Windows Media Player.<br />\nBelow is a list of OS specific player issues:</p>\n	<ul>\n	<li><b>Windows</b><br />\nIf you\\\'re experiencing problems viewing video lectures on Windows systems, make sure that you\\\'ve installed the latest WindowsMedia software:<br />\n<a href=\\\"http://www.microsoft.com/windows/windowsmedia/mp10/default.aspx\\\" rel=\\\"external\\\"\\\">Windows Media Player for Windows</a>\n</li>\n	<li><b>Mac OS X</b><br />\nIf you\\\'re experiencing problems viewing video lectures on Mac OS X systems, make sure that you\\\'ve installed the latest WindowsMedia software:<br />\n<a href=\\\"http://www.microsoft.com/windows/windowsmedia/software/Macintosh/osx/default.aspx\\\" rel=\\\"external\\\">Windows Media Player for Mac OS X</a><br />\n<strong>NOTE:</strong> Microsoft will continue to offer Windows Media Player for Mac as a download free of charge, but has no plans to provide<br />\nfuture updates or product support. Instead, Microsoft will be offering <a href=\\\"http://www.microsoft.com/windows/windowsmedia/player/flip4mac.mspx\\\" rel=\\\"external\\\">Windows Media&reg; Components for Quicktime, by Flip4Mac&trade;</a>, as an<br />\nalternative for Mac OS X users wanting to play Windows Media Audio and Windows Media Video. Requires Mac OS X version 10.3.9 or later and QuickTime version 6.5 or later.<br />\n<b>Known Issue:</b> Windows Media Player 9 for Mas OS X may have difficulty playing secure video streams (URLs starting with \\\'https\\\'). The Flip4Mac plugin described above fixes this problem.\n</li>\n	<li><b>Linux</b><br />\nNo currently known issues.  Use <a href=\\\"http://www.videolan.org/\\\" rel=\\\"external\\\">VideoLAN Media Player</a> or equivalent application.\n</li>\n	<li><b>MacOS Classic</b><br />\nIf you don\\\'t have Mac OS X, get the <a href=\\\"http://www.microsoft.com/windows/windowsmedia/download/mac71.aspx\\\" rel=\\\"external\\\">Windows Media Player for Mac 7.1</a> which runs on the Macintosh Classic OS.\n</li>\n	</ul>\n	<h3>Downloading Video and Audio Content</h3>\n	<p><img src=\\\"/site/images/kb/video_download.jpg\\\" alt=\\\"browser download\\\" class=\\\"align-right\\\"><br />\nMost of this hub\\\'s video and audio content is downloadable.  Proceedures varry depending on the browser you are using:</p>\n	<ul>\n	<li><b>Firefox</b><br />\nRight click (hold click for Mac) on the resource link, select \\\"Save Link As...\\\", a dialog box will appear allowing you to save document as a file.\n</li>\n	<li><b>Internet Explorer</b><br />\nRight click on the resource link, then select \\\"Save Target As...\\\", a dialog box will appear allowing you to save document as a file.  Mac users should drag the link to their desktop or folder and the document will be downloaded.\n</li>\n	<li><b>Safari</b><br />\nControl-click on the resource link, then select \\\"Download Linked File\\\", the document will download to your download\\\'s folder.  The download folder is specified using the <i>Preferences</i> menu and selecting the <i>General</i> tab.\n</li>\n	</ul>\n	<h3>Continued Problems</h3>\n	<p>If the problem persists, please send us a <a href=\\\"support/report_problems/\\\">trouble report</a>.\n</p>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,3,0,0,0);
INSERT INTO `#__faq` VALUES (12,'How to enable pop-ups?','popups','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>Web pages can use the JavaScript language to automatically force the your web browser to open new windows.  This capability has often been abused by advertising sites and many browsers disable the capability by default.<br />\nYou must enable pop-ups for this site in order to do file downloads.  The way in which this is done varies from browser to browser:</p>\n	<ul>\n	<li><b>Firefox</b><br />\nGo to the <i>Edit-&gt;Preferences</i> menu and choose the <i>Content</i> icon at the top of the dialog.  If <i>Block pop-up windows</i> is checked, add this site to the <i>Exceptions</i> list.<br />\nFirefox also uses plugins to filter pop-ups.  The most common plugin is NoScript.  To enable a pop-up for a particular page, select the highlighted <i>S</i> icon at the bottom of the browser to instruct NoScript to allow the pop-up.\n</li>\n	<li><b>Internet Explorer</b><br />\nGo to <i>Tools-&gt;Internet Options</i> menu. Click on the <i>Privacy</i> tab. Uncheck the field <i>Block pop-ups\\\'</i> (<i>Turn on Pop-up Blocker</i> in IE 7.x). This will unblock pop-ups from all sites. To only allow pop-ups from this site, check <i>Block pop-ups</i> and click on <i>Settings</i>. Enter the address of this site in the field <i>Address of Web site to allow:</i> and click <i>Add</i>. Close all windows.\n</li>\n	<li><b>Safari</b><br />\nGo to the menu bar and select <i>Safari-&gt;Preferences</i> and choose the <i>Security</i> tab. If <i>Block pop-up windows</i> is checked, uncheck it.\n</li>\n	<li><b>Opera</b><br />\nApple OSX - Go to the menu bar and select <i>Opera-&gt;Quick Preferences</i> and make sure \\\"Block all pop-ups\\\" is not selected (click on it to toggle preference).<br />\nWindows - Go to the menu bar and select <i>Tools-&gt;Quick Preferences</i> and make sure <i>Block all pop-ups</i> is not selected (click on it to toggle preference).\n</li>\n	<li><b>Konqueror</b><br />\nGo to the <i>Settings-&gt;Configure Konqueror</i> menu and choose Java and JavaScript.  Select the JavaScript tab at the top of the dialog.  In the center of the dialog is a <i>Domain-Specific</i>policy mechanism.  Press the <i>New...</i> button and type the address of this site for the host or domain name.  Select <i>Accept</i> for the policy.  Set the <i>Open new windows</i> policy to <i>Allow</i>.\n</li>\n	<li><b>Mozilla</b><br />\nGo to the <i>Edit-&gt;Preferences</i> menu and choose <i>Privacy</i> and <i>Security-&gt;Popup Windows</i>.  There, you can add the address for this site to the <i>Allowed Sites</i>.\n</li>\n	</ul>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,3,0,0,0);
INSERT INTO `#__faq` VALUES (13,'Why do I need Java?','java','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>In order to access the simulation tools, you must have Java version 1.4 or later installed on your machine and enabled in your web browser.  Note that Java is <em>not</em> the same as Javascript.  Visit the <a href=\\\"http://www.java.com/en/download/installed.jsp\\\" rel=\\\"external\\\">Java website</a> to verify which version of Java is installed on your browser.  You can also <a href=\\\"http://www.java.com/en/download/manual.jsp\\\" rel=\\\"external\\\">upgrade</a> to the latest release of Java. If you do not have access to install plug-ins, please contact your system administrator about installing or upgrading your Java.</p>\n	<h4>Known Issues</h4>\n	<ul>\n	<li><b>KDE Konqueror</b><br />\nTo enable Java in the KDE Konqueror browser, make sure that the Java preferences are enabled and that <i>Use KIO</i> is checked.  In the box that specifies the path to the <i>java</i> executable, simply typing <i>java</i> often works better than the full path to the executable.</li>\n	</ul>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,1,1,3,0,0,0);
INSERT INTO `#__faq` VALUES (14,'How to Enable Cookies','cookies','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>In order to log in to this site, you must enable cookies in your browser.  Instructions for enabling cookies in common browsers are listed below. If your browser is not listed, please check its website or other browser documentation for more information.</p>\n	<h3>Windows IE 6/7</h3>\n	<ul>\n	<li>In <i>Tools</i> menu, click <i>Internet Options</i></li>\n	<li>Click <i>Privacy tab</i></li>\n	<li>Click <i>Advanced button</i></li>\n	<li>Check the box next to <i>Override Automatic Cookie Handlng</i></li>\n	<li>At bottom, check the box next to <i>Always accept session cookies</i></li>\n	<li>Click <i>OK</i></li>\n	<li>Now you should be able to <a href=\\\"/login\\\">log in</a></li>\n	</ul>\n	<h3>Firefox 1/2</h3>\n	<ul>\n	<li>In <i>Tools</i> menu, select <i>Options...</i></li>\n	<li>Click <i>Advanced</i> icon</li>\n	<li>Select/expand cookies section on left</li>\n	<li>Check box next to <i>Allow Sites to Set Cookies</i></li>\n	<li>Now you should be able to <a href=\\\"/login\\\">log in</a></li>\n	</ul>\n	<h3>Safari 1.2.4</h3>\n	<ul>\n	<li>Click on <i>Safari</i> tab on menu bar</li>\n	<li>Click <i>Preferences</i></li>\n	<li>Click <i>Security</i> tab</li>\n	<li>Ensure <i>Enable Javascript</i> is enabled</li>\n	<li>In the cookies area, choose either <i>Only from sites you navigate to</i> or <i>Always</i></li>\n	<li>Now you should be able to <a href=\\\"/login\\\">log in</a></li>\n	</ul>\n	<h3>Netscape 7</h3>\n	<ul>\n	<li>In <i>Edit</i> menu, select <i>Preferences</i></li>\n	<li>Select <i>Privacy and Security</i></li>\n	<li>Select <i>Cookies</i></li>\n	<li>Select <i>Enable All Cookies</i> or <i>Enable cookies for the originating website only</i></li>\n	<li>Click <i>OK</i></li>\n	<li>Now you should be able to <a href=\\\"/login\\\">log in</a></li>\n	</ul>\n	<h3>Mac IE 5</h3>\n	<ul>\n	<li><a href=\\\"http://www.mozilla.com/firefox/\\\">Download Firefox</a> and use it instead.  :)</li>\n	<li>If you must use Mac IE 5, follow these instructions...</li>\n	<li>Go to <i>Edit</i> menu, select <i>Preferences</i></li>\n	<li>Click on <i>Receiving Files</i> settings</li>\n	<li>Click on <i>Cookies</i></li>\n	<li>In the pull-down menu labeled <i>When receiving cookies:</i>, select <i>Never Ask</i> or <i>Ask for each site.</i></li>\n	<li>Clicking <i>Ask for each site</i> will display a prompt asking if you\\\'d like to accept cookies for this site. Click <i>Accept</i>.</li>\n	<li>Now you should be able to <a href=\\\"/login\\\">log in</a></li>\n	</ul>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,3,0,0,0);
INSERT INTO `#__faq` VALUES (15,'Share a simulation session','share','uploadpath=/site/kb\nshow_authors=1\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial\nshow_date=2','<p>Have some interesting results from a simulation that you\'d like someone else to see? Share the session!\r\nEnter one or more login names in the form beneath the tool session and click on the <i>Share</i> button.  Anyone added for sharing will see your tool session listed on their own <i>My Sessions</i> area on their <a href=\"/members/myaccount\">dashboard page</a>.  Just as you would click a link to resume a tool session, they can click the link and access your session.  Many people can access a single session at the same time and discuss the results on a conference call.\r\n</p><p>\r\n<b>Note:</b>  If you don\'t want others to have control of the tool, be sure to select the <i>Read-Only</i> checkbox before sharing the session.\r\n</p>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,5,0,0,0);
INSERT INTO `#__faq` VALUES (16,'Rate a Resource','rate','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>Rating a resource is quick and easy.<br />\nEvery resource has two sets of stars: the average rating and your rating. If you haven\\\'t rated a resource, you\\\'re rating will show up as a set of slightly grayed out stars.<br />\nTo rate the resource, hover over your rating stars. The stars will change to red depending on where your cursor is. If you want a four star rating, move the cursor until you see four red stars and then click.  You will be taken to a form where you can then add comments, suggestions, and even tags.  If you\\\'d like to remain anonymous, be sure to check the box.  Otherwise, your name will show up next to your rating and your comments on the resource page.\n</p>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,1,1,5,0,0,0);
INSERT INTO `#__faq` VALUES (17,'Customize your dashboard page','personalize','uploadpath=/site/kb\nshow_authors=1\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial\nshow_date=2','<p>To change your <a href=\"/members/myaccount\"> dashboard page</a>, simply click the <i>Personalize</i> button located in the upper-right corner of that page.  The page will enter a customization mode where you may move modules around by simple drag-and-drop, remove modules, or add modules.  When you\'re done, click the <i>finish</i> button and all your changes will be saved.  Your changes will even be remembered the next time you log in--even if you use a different computer!\r\n</p>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,5,0,0,0);
INSERT INTO `#__faq` VALUES (18,'Renaming Sessions','rename','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>You can rename a simulation session by simple double-clicking the session title just above the active tool area.  The title will then become a text box where you can input any title you wish.  Press the TAB key or ENTER key to save changes or press ESC to cancel.\n</p>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,5,0,0,0);
INSERT INTO `#__faq` VALUES (19,'How to use WebDAV to access your hub storage','webdav','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>WebDAV is the Distributed Authoring and Versioning extension to the standard HTTP/HTTPS web protocol.  It allows a client to browse a remote filesystem, usually with a graphical browser that makes it appear that your files are on your desktop.  You may access your hub storage using only the secure version of this service (HTTPS).  We do not support HTTP.  Most modern computer platforms support HTTPS transport for WebDAV with either small adjustments or freely available software.</p>\n	<h3>Linux/Unix</h3>\n	<p>If you use the KDE graphical desktop environment, you can access your hub storage with the Konqueror browser by typing the special URL <tt>webdavs://HUBADDRESS/webdav</tt> into the Location field of the browser.  It will prompt you for your hub login and password.  Thereafter, you traverse your home directory by clicking on folders and you can drag and drop files to your desktop.<br />\n<a href=\\\"http://www.webdav.org/cadaver/\\\" rel=\\\"external\\\">Cadaver</a> is a text-mode WebDAV browser.  It can be used if it is compiled with SSL support.  Invoke it with the command <tt>cadaver https://HUBADDRESS/webdav</tt> and it will prompt you for your hub login and password.  You can then use it in a manner similar to FTP.<br />\nIf you are using Linux, you can use the <a href=\\\"http://dav.sourceforge.net/\\\" rel=\\\"external\\\">davfs</a> kernel module to mount your hub storage area as a local filesystem.</p>\n	<h3>Macintosh</h3>\n	<p>MacOS versions 10.4 and higher support HTTPS transport for WebDAV using the Finder.  To access your hub directory, select the Go menu in the Finder and choose \\\"Connect to Network Server\\\".  Enter the URL <tt>https://HUBADDRESS/webdav</tt> into the address field.  You will be prompted for your hub login and password.<br />\nMacOS versions lower than 10.4 do not have support for HTTPS, but a free client exists.  Download <a href=\\\"http://www.webdav.org/goliath/\\\" rel=\\\"external\\\">Goliath</a> and install it on your system.  Invoke it and use <tt>https://HUBADDRESS/webdav</tt> as the address to connect to.  Note that you may also use Goliath on newer MacOS platforms as well.</p>\n	<h3>Windows</h3>\n	<p>Windows XP systems have native support for accessing WebDAV storage via HTTPS, but it may be disabled by default depending on how your OS was configured.  Try these instructions first, and then check the next set of instructions to enable WebDAV.  To access your hub storage,</p>\n	<ul>\n	<li> Double-click on the desktop icon called \\\"My Network Places\\\".</li>\n	<li> This will invoke a dialog box where you can select \\\"Add Network Place\\\".  This will invoke a wizard that you can step through.</li>\n	<li> Select the \\\"Choose another network location\\\" function.</li>\n	<li> The wizard will then ask you for the \\\"Internet or Network Address.\\\"  In the box, type <tt>https://HUBADDRESS/webdav</tt></li>\n	<li> Specify the name that you would like to have associated with this storage space.  An icon will be created for the hub storage folder.  When you double-click on it to open it, you will be prompted for your hub login and password.</li>\n	</ul>\n	<h4>Enabling WebDAV in Windows XP</h4>\n	<p>If the steps above do not work, for Windows XP, or you cannot find the named options, your OS may have WebDAV turned off by default.  Do the following additional steps and then try to add network storage again.</p>\n	<ul>\n	<li>Open Windows Explorer</li>\n	<li>Go to the \\\"Tools\\\" menu and select \\\"Folder Options\\\"</li>\n	<li>Select the radio button \\\"Use Windows classic folders\\\" under \\\"Tasks\\\".</li>\n	</ul>\n	<h4>Windows 2003 users cannot access secure WebDAV</h4>\n	<p>There is no support for secure WebDAV transport in Windows 2003.  Various workarounds have been suggested, but it appears the easiest action to take is to simply upgrade the OS.\n</p>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,2,1,5,0,0,0);
INSERT INTO `#__faq` VALUES (20,'Troubleshoot','troubleshoot','uploadpath=/site/kb\nshow_authors=1\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial\nshow_date=2','<p>There are two common reasons why you may not be able to view an application.</p>\r\n	<ul>\r\n	<li><b>The tool is internally misconfigured.</b>  If you can look at your <a href=\"/members/myaccount\">personalized dashboard page</a> and see that the tool you just started does not appear in the list of running sessions, it exited before it could be viewed.  You should <a href=\"/support/ticket/new\">report this as a problem</a>.\r\n	<li><b>The Java interpreter won\'t start or is misconfigured.</b>  If you\'ve been able to view applications in previous times with the same browser, usually you can solve this problem by restarting your browser.  Make sure that all instances of the browser (e.g. multiple windows) are stopped in order to properly stop and restart the Java environment.  If this fails to make tool sessions viewable, consult the <a href=\"/kb/misc/java/\">Java page</a> for more platform-specific hints.</li>\r\n	</ul>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,2,1,6,0,0,0);
INSERT INTO `#__faq` VALUES (21,'Help! I\\\'m getting a Java error!','javaerr','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>Users may experience a Java error on Mac OS X if they are using Java version 1.3 and below. Please ensure your Java install is up to date.<br />\nNOTE! For gecko browsers (Mozilla, Firefox, Camino), the following may be the source of the error:</p>\n	<blockquote cite=\\\"http://plugindoc.mozdev.org/OSX.html#Java\\\"><p>Mozilla will only use <abbr title=\\\"Java Runtime Engine\\\">JRE</abbr> 1.3.1, even if a later JRE is installed [Bug 197813]. To use a newer JRE, you will need to install the <a href=\\\"http://javaplugin.sourceforge.net/\\\">Java Embedding Plugin for Mac OS X</a>. This plugin is beta quality software, and may have bugs and cause problems. Read the <a href=\\\"http://javaplugin.sourceforge.net/Readme.html\\\">Readme</a> before installing it.</p></blockquote>\n	<p>Java for Windows, Mac OS, Solaris, and Linux can be downloaded <a href=\\\"http://www.java.com/en/download/\\\">here</a>. Instructions for installation may also be found at that site.\n</p>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,1,1,6,0,0,0);
INSERT INTO `#__faq` VALUES (22,'Signed Applet','applet','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>If you are behind a network firewall that requires you to use a web proxy with your browser, your Java environment will also need to use a proxy to connect to tool sessions.  The default security manager for Java stipulates that an applet can make network connections only to the web server from which it was originally loaded.  Connecting to a proxy requires additional privileges&#8212;even though the ultimate connection through the proxy is to the originating web server.</p>\n<p>In order to empower an applet with additional privileges, it must be <i>signed</i>.  This is a process by which a cryptographic identity is added to the applet to prove the identity of its author.  The first time you load a particular signed applet, your Java virtual machine will show you a dialog  which shows that the applet was authored by HUBzero and is confirmed by Thawte Consulting (a certificate authority that most JVM\\\'s trust).  If you trust the author of this applet, you can select \\\"Yes\\\" to load the applet.<p>\nA signed applet can have many privileges.  It can access your general window system, your computer\\\'s peripherals, and your local file system.  This site\\\'s VNC applet uses additional privileges <strong class=\\\"highlight\\\">only to connect to your web proxy.</strong>  The applet contains no code to perform any kind of additional access to your computer\\\'s local resources.\n</p>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,2,1,6,0,0,0);
INSERT INTO `#__faq` VALUES (23,'Why the math question?','why_the_math_question','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>When you use the Help button to submit a trouble report, it may ask you a simple math question such as \\\"What is the sum of 3 and 5?\\\" You get this if you\\\'re not logged in. Providing a correct answer gives us some indication that you\\\'re a human that has read and understood the question--not a bot that is attempting to put spam on our site!\n</p>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,0,1,3,0,0,0);
INSERT INTO `#__faq` VALUES (24,'Frequently Asked Questions','faq','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<ul class=\"faq-list\">\r\n  <li><a href=\"#groupdiscoverability\">What is Group Discoverability?</a></li>\r\n   <li><a href=\"#groupmembership\">What is Group Membership Access?</a></li>\r\n   <li><a href=\"#groupcustomization\">How to Customize a Group?</a></li>\r\n   <li><a href=\"#groupaccesslevels\">What are Group Plugin Access Levels?</a></li>\r\n  <li><a href=\"#groupmanagement\">How are groups managed?</a></li>\r\n    <li><a href=\"#leavegroup\">How do I leave a group?</a></li>\r\n    <li><a href=\"#deletegroup\">How do I delete a group?</a></li>\r\n</ul>\r\n\r\n<h3><a name=\"groupdiscoverability\"></a>What is Group Discoverability?</h3>\r\n<p>All groups have an overall discoverability setting of either visible or hidden. This determines whether or not the group appears in searches or by browsing groups. Visible means the group can be found by anyone, hidden means the reverse.</p>\r\n<p>The group mangers have the ability to update the group discoverability which can be found by editing the group.</p>\r\n<p>Group managers can also set access restrictions on each group plugin (members, messages, wiki, etc) to limit access to that specific plugin\'s content. Information about group access levels can be found below.</p>\r\n\r\n<h3><a name=\"groupmembership\"></a>What is Group Membership Access?</h3>\r\n<p>Group membership allows for groups to restrict access for new members. There are four settings for group membership: Anyone or Open, Restricted, Invite Only, and Closed.</p>\r\n<ol>\r\n<li><strong>Anyone or Open</strong> means that if a registered hub member comes to you group they will be able to click a button to join the group without a group manager having to approve. </li>\r\n<li><strong>Restricted</strong> means that the user will have to enter a reason for wanting to join the group and a group manager must approve their request before they will be granted access to the group.</li>\r\n<li><strong>Invite Only</strong> means that the user will not be able to join the group unless they have been sent a group invite from one of the group managers.</li>\r\n<li><strong>Closed</strong> simply means that membership cannot be modified.</li>\r\n</ol>\r\n<p>The group managers have the ability to update the group membership access, which can be found by editing the group.</p>\r\n\r\n<h3><a name=\"groupcustomization\"></a>How to Customize a Group?</h3>\r\n<p>Groups allow for customization including adding a group logo, customizing the group home or main page (instead of using default group description and random selection of group members), setting group plugin access levels (discussed below), and the ability to add extra custom group pages.</p>\r\n<p>All group managers can customize any of these items through the group customization interface.</p>\r\n\r\n<h3><a name=\"groupaccesslevels\"></a>What are Group Plugin Access Levels?</h3>\r\n<p>Group Plugin Access Levels allow for groups to set access levels for each plugin (members, messages, wiki, etc) individually. The different access levels are: Any HUB Visitor, Registered HUB Members, Group Members, and Disabled or Off.</p>\r\n<ol>\r\n<li><strong>Any HUB Visitor</strong> means that if a guest (not logged in user) comes to the group plugin they will be granted access to view the plugin but not allowed to perform any actions (add, edit, delete, etc) within the plugin.</li>\r\n<li><strong>Registered HUB Members</strong> means that if a HUB member (not a member of the group) comes to the group plugin they will be granted access to view the plugin but not allowed to perform any actions (add, edit, delete, etc) within the plugin. Guest users will not be granted access to view the plugin.</li>\r\n<li><strong>Group Members</strong> means that is a group member comes to the group plugin they will granted access to view the plugin and perform any actions that group members are allowed to perform. Guest users and Registered HUB users will not be granted access to the plugin.</li>\r\n<li><strong>Disabled or Off</strong> means that no one will be granted access to the plugin.</li>\r\n</ol>\r\n<p>All group managers have the ability to update the group plugin access levels, which can be found through the group customization interface.</p>\r\n\r\n<h3><a name=\"groupmanagement\"></a>How are groups managed?</h3>\r\n<p>When you create a group, you are automatically made its first manager. As manager, you can also promote members to help you run the group.</p>\r\n<p><strong>A group manager can</strong>:</p>\r\n<ol>\r\n  <li>Create group participation rules</li>\r\n  <li>Promote/demote members and approve/deny membership requests.</li>\r\n  <li>Modify information about the group\r\n    <ul>\r\n      <li>Create or change the group name</li>\r\n      <li>Create or change the group description</li>\r\n      <li>Associate the group with an external URL</li>\r\n      <li>Determine whether or not your group wiki pages, resources, and discussion topics can be viewed by non-members.</li>\r\n      <li>Moderate group discussions</li>\r\n    </ul>\r\n  </li>\r\n</ol>\r\n<p>There\'s no upper limit on the number of managers a group can have, but a group <strong>must</strong> have at least one manager at all times.</p>\r\n<p>You can read about keeping your group happy on the <a href=\"/kb/groups/guide\">Tips for Running Your Group</a> page.</p>\r\n\r\n<h3><a name=\"leavegroup\"></a>How do I leave a group?</h3>\r\n<p>To Leave a group navigate to your Member profile then to the Groups tab. There you will see a listing of all the groups you are associated with. Along the right side of the listing there is a Remove icon. Clicking this link will remove you from the group. You can also navigate directly to the group and click the cancel group membership button.</p>\r\n<p><em>Note: You will not be able to leave a group if you are the only group manager. You must promote someone else in the group first before removing yourself.</em></p>\r\n\r\n<h3><a name=\"deletegroup\"></a>How do I delete a group?</h3>\r\n<p>To Delete a group navigate to your Member profile then to the Groups tab. There you will see a listing of all the groups you are associated with. Along the right side of the listing you will see a Trash icon. Clicking this will take you to another screen to confirm deletion of the group.</p>\r\n<p><em>Note: You will not be able to delete a group if there are other members still in the group.</em></p>\r\n\r\n<hr />\r\n\r\n<p>Return to <a href=\"/groups\">the main groups page</a>.</p>','2010-03-25 02:26:40',62,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,4,1,1,0,0,0);
INSERT INTO `#__faq` VALUES (25,'Group Guidelines & Tips','guide','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>Ultimately it is the Admins that decide what the rules are for their group, but if you have been made a manager of a group, here are some suggestions for keeping your group happy:</p>\r\n\r\n<h3>Manager Guidelines</h3>\r\n<p>If you are a manager of a group, here are some pointers for creating a thriving community:</p>\r\n<ol>\r\n    <li><strong>Invite your friends</strong> and anyone you know who is interested in what you are interested in. Having group members is the first step in having a successful group!</li> \r\n    <li><strong>Visit the group frequently.</strong> Groups thrive with daily discussion, and with daily responses from other members of the community, in chat and on the discussion boards.</li>\r\n  <li><strong>Moderate, moderate, moderate!</strong> Successful groups are kept in check by good moderation. Tend that garden; pull the weeds, mow the lawn, prune the roses, etc. To help you moderate your group, you can enlist other members to become moderators. Moderators don\\\'t have full administrative power, but they can help you moderate pool submissions, keep tabs on discussions, and weed out the people who don\\\'t play by the rules.</li>\r\n</ol>\r\n\r\n<h3>Removing members</h3>\r\n<p>Here are some general guidelines to help managers determine how and when to use the removing feature.</p>\r\n<p>\\\"Removing\\\" is when a person is removed from a group. They can come back if they want, but some trolls just need a cooling off period and are remorseful when they return.</p>\r\n<ul>\r\n    <li>Use this power wisely and sparingly.</li>\r\n   <li>If a troll types or posts something offensive, they should be warned.</li>\r\n  <li>If they continue their behavior, they should be removed. You can do this from the members list.</li>\r\n</ul>\r\n\r\n<h3>Group Life </h3>\r\n<h4>Swearing</h4>\r\n<p>People ask if it\\\'s OK to swear. It is OK to swear so long as you\\\'re not offending, insulting or harassing anybody.</p>\r\n\r\n<h4>Porn</h4>\r\n<p>Porn, nudity and other such content is not disallowed, but it shouldn\\\'t be posted in public areas.</p>\r\n\r\n<h4>Trolls</h4>\r\n<p>Trolls are people who are just being rude and obnoxious, and are generally trying to offend, shock, harass, abuse or otherwise annoy people. Dealing with such people can often be difficult, but they should not go unwarned or unremoved. Trolls can destroy a community, and often this is their goal.</p>\r\n<p>Trolls thrive on attention, and often the best way to deal with them is to completely ignore them. They don\\\'t know when they are being ignored, all they know is that no one is responding to their attempts to annoy, harass or offend.</p>\r\n\r\n<hr />\r\n\r\n<p>Return to <a href=\\\"/groups\\\">the main groups page</a>.</p>','2011-03-31 15:24:31',69,'2011-03-31 15:24:31',69,0,'0000-00-00 00:00:00',1,0,3,1,1,0,0,0);
INSERT INTO `#__faq` VALUES (27,'Frequently Asked Questions','faq','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<ul class=\\\"faq-list\\\">\r\n	<li><a href=\\\"#explanation\\\">What are resources?</a></li>\r\n	<li><a href=\\\"#create\\\">How do I upload a new resource?</a></li>\r\n	<li><a href=\\\"#delete\\\">How can I delete a resource?</a></li>\r\n	<li><a href=\\\"#limit\\\">Is there a limit on the number of resources I can submit?</a></li>\r\n</ul>\r\n\r\n<h3><a name=\\\"explanation\\\"></a>What are resources?</h3>\r\n<p>Think of a hub as an empty library.  Resources are items on the shelves.  Unlike a traditional library, resources not only be publications, but also videos, tools, animations, and other types.  Anyone can upload resources, although some hubs require moderation and approval before a resource is posted.</p>\r\n\r\n<h3><a name=\\\"create\\\"></a>How do I upload a new resource?</h3>\r\n<p>You can submit a new resource with our <a href=\\\"/resources/new\\\">contribution section</a>. This will guide you, step-by-step, through the process. If you get interrupted during the submission process, no problem.  The hub will remember where you left off.  Submissions may be worked on at your leisure and submitted at any future date when you feel they are ready.</p>\r\n\r\n<h3><a name=\\\"deletetag\\\"></a>How can I delete a resource?</h3>\r\n<p>Currently, you can\\\'t. This is partly because others may reference your resource in journal articles, and it would be wrong for it to suddenly disappear.  Instead, resources are normally \\\"retired,\\\" or put in a state where they can be seen but not downloaded or used.  If you wish to have a resource retired or completely removed, please contact our support and we will work with you to address the issue.</p>\r\n\r\n<h3><a name=\\\"taglimit\\\"></a>Is there a limit on the number of resources I can submit?</h3>\r\n<p>No.  Think of resources as publications or presentations that you would be proud to have others find in the library.  It usually takes time to produce high-quality resources, but there is no limit on the amount that you can contribute</p>\r\n\r\n<hr />\r\n\r\n<p>Back to the <a href=\\\"/resources\\\">main Resources page</a>.</p>','2010-03-27 11:27:39',63,'0000-00-00 00:00:00',0,0,'0000-00-00 00:00:00',1,0,7,1,7,0,0,0);
INSERT INTO `#__faq` VALUES (28,'Earning points in the Questions & Answers forum','earning_points_in_the_answers_forum','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<p>Each question in the forum has its own \\\"market\\\" value, which reflects the level of community interest the question has generated. This is calculated by summing up the weighted number of answers, recommendations and answer votes, e.g. each additional answer rises the value of the question by 10 points, each recommendation by 2 points, etc. When the person who asked the question selects an answer as most helpful, the question gets 20 bonus points and is considered to be closed. At that moment the accumulated point value of the question is distributed between participating parties. One third of the value goes to the asker; another third goes to the user whose answer was accepted as the best; the remaining third is split between all users who answered the question, provided that their response received at least 3 community votes and more than half of those are positive (users found them helpful). In the case of only one answer, or if the community vote requirement is not satisfied, the user whose answer was accepted as best gets the remainder of accumulated points for the question.</p>\r\n<p>Additionally, users will get monthly \\\"royalty\\\" payments for their questions and answers based on the total of received question recommendations and answer votes. The royalty payment is distributed the same way as the points at question closure. The more community interest the question generates and the more positive votes your answer receives, the more points you earn as a result.</p>\r\n<p>You can boost the value of your question by assigning a point reward for best answer. This can be done when you first submit your question, provided that you have funds available on your account. The amount you set aside for the reward is not deducted from your account until you select the winner, but is meanwhile kept on hold. If you are not satisfied with a single answer and do not wish to name a winner, you have an option to withdraw your question.</p>','2011-03-31 13:52:03',71,'2011-03-31 13:52:03',71,0,'0000-00-00 00:00:00',1,0,6,1,8,0,0,0);
INSERT INTO `#__faq` VALUES (29,'Frequently Asked Questions','faq','show_date=2\nallow_comments=0\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial','<ul class=\\\"faq-list\\\"> \r\n	<li><a href=\\\"#tagsexplanation\\\">What are tags?</a></li> \r\n	<li><a href=\\\"#createtag\\\">How do I create a new tag?</a></li> \r\n	<li><a href=\\\"#deletetag\\\">How can I delete a tag?</a></li> \r\n	<li><a href=\\\"#removetag\\\">How can I remove a tag from a resource/group/my profile/etc?</a></li> \r\n	<li><a href=\\\"#taglimit\\\">Is there a limit on the number of tags I can add to an item?</a></li> \r\n	<li><a href=\\\"#otherstags\\\">Can I tell who\\\'s tagged another member\\\'s content?</a></li> \r\n</ul> \r\n \r\n<h3><a name=\\\"tagsexplanation\\\"></a>What are tags?</h3> \r\n<p>Tags are like keywords or category labels. Tags help you find content, events, and members which have something in common or similar interests. Tags can be added to groups, your profile, resources, wiki pages, and events.</p> \r\n \r\n<h3><a name=\\\"createtag\\\"></a>How do I create a new tag?</h3> \r\n<p>When creating or editing content, your profile, groups, etc. you can add or remove tags as you wish. If a tag doesn\\\'t already exist, simply typing it in a \\\"Tags\\\" form field will create it and make it available for everyone to use.</p> \r\n \r\n<h3><a name=\\\"deletetag\\\"></a>How can I delete a tag?</h3> \r\n<p>You can\\\'t. Tags can only be deleted by the site administrators. You may only remove tags from a piece of content or profile.</p> \r\n \r\n<h3><a name=\\\"removetag\\\"></a>How can I remove a tag from a resource/group/my profile/etc?</h3> \r\n<p>When editing content, your profile, groups, etc. you can remove tags by simply deleting them from the list presented in the \\\"Tags\\\" form field.</p> \r\n \r\n<h3><a name=\\\"taglimit\\\"></a>Is there a limit on the number of tags I can add to an item?</h3> \r\n<p>No. You should be able to add as many tags as you want to taggable content/profiles.</p> \r\n \r\n<h3><a name=\\\"otherstags\\\"></a>Can I tell who\\\'s tagged another member\\\'s content?</h3> \r\n<p>No. Who tagged an item and what tags they added is currently not available to users.</p> \r\n \r\n<hr /> \r\n \r\n<p>Back to the <a href=\\\"/tags\\\">main Tags page</a>.</p>','2010-03-27 13:24:44',62,'2010-03-27 13:27:17',63,0,'0000-00-00 00:00:00',1,0,11,1,4,0,0,0);
INSERT INTO `#__faq` VALUES (42,'Where do I go for documentation?','testarticle','uploadpath=/site/kb\nshow_authors=1\nallow_comments=1\nclose_comments=year\nfeeds_enabled=1\nfeed_entries=partial\nshow_date=2','Documentation can be found in <a href=\"https://hubzero.org/documentation\">HUBzero\'s documentation page<a>.','2011-04-01 10:25:02',71,'2011-04-01 10:25:02',0,0,'0000-00-00 00:00:00',1,0,5,1,3,0,0,0);

--
-- HUBzero sample data for table `#__faq_categories`
--

INSERT INTO `#__faq_categories` VALUES (1,'Members & Groups','groups','&quot;Members only&quot; content, working with member groups, member content, and member privileges.',0,1,0,0);
INSERT INTO `#__faq_categories` VALUES (2,'Login & Registration','registration','The following will try to answer some frequently recieved questions concerning login and registration issues.',0,1,0,0);
INSERT INTO `#__faq_categories` VALUES (3,'Miscellaneous','misc','Issues that don\\\'t necessarily fit in other categories, but that can affect hub use or are very helpful in using it.',0,1,0,0);
INSERT INTO `#__faq_categories` VALUES (4,'Tags','tags','Information about tags and how to deal with them.',0,1,0,0);
INSERT INTO `#__faq_categories` VALUES (5,'Tips','tips','Learn more about features of this hub you may not have known about.',0,1,0,0);
INSERT INTO `#__faq_categories` VALUES (6,'Tools','tools','The most common questions on launching and using simulation tools.',0,1,0,0);
INSERT INTO `#__faq_categories` VALUES (7,'Resources','resources','Questions, concerns, and problems you may have with uploading and publishing content on this site.',0,1,0,0);
INSERT INTO `#__faq_categories` VALUES (8,'Reward Points','points','<p>Our hub is powered by your contributions!  We want to reward you for your efforts and encourage you to contribute more.  So we have introduced a new system of reward points similar to airline miles.</p>\r\n\r\n<p><img src=\\\"site/media/images/header_economy',0,1,0,0);

--
-- HUBzero sample data for table `#__forum_categories`
--

INSERT INTO `#__forum_categories` (`id`, `title`, `alias`, `description`, `created`, `created_by`, `modified`, `modified_by`, `access`, `state`, `scope`, `scope_id`, `section_id`, `closed`, `asset_id`, `object_id`) VALUES (1,'Discussions','discussions','Default category for all discussions in this forum.','2012-05-24 17:33:36',0,'0000-00-00 00:00:00',0,0,0,'site',0,1,0,0,0);

--
-- HUBzero sample data for table `#__forum_sections`
--

INSERT INTO `#__forum_sections` (`id`, `title`, `alias`, `created`, `created_by`, `access`, `state`, `scope`, `scope_id`, `asset_id`, `object_id`) VALUES (1,'Default Section','defaultsection','2012-05-24 17:33:36',0,0,1,'site',0,0,0);

--
--
-- HUBzero sample data for table `#__jobs_categories`
--

INSERT INTO `#__jobs_categories` (`id`, `category`, `ordernum`, `description`) VALUES (1,'Scientific/Technical Staff',3,'');
INSERT INTO `#__jobs_categories` (`id`, `category`, `ordernum`, `description`) VALUES (2,'Post-Doctoral Researcher',2,'');
INSERT INTO `#__jobs_categories` (`id`, `category`, `ordernum`, `description`) VALUES (3,'Faculty Tenure & Tenure-Track',1,'');

--
-- HUBzero sample data for table `#__jobs_types`
--

INSERT INTO `#__jobs_types` (`id`, `category`) VALUES (1,'Full-time');
INSERT INTO `#__jobs_types` (`id`, `category`) VALUES (2,'Part-time');
INSERT INTO `#__jobs_types` (`id`, `category`) VALUES (3,'Contract');
INSERT INTO `#__jobs_types` (`id`, `category`) VALUES (4,'Internship');
INSERT INTO `#__jobs_types` (`id`, `category`) VALUES (5,'Temporary');

--
-- HUBzero sample data for table `#__menu`
--

TRUNCATE `#__menu`;
ALTER TABLE `#__menu` DROP KEY  `idx_client_id_parent_id_alias_language`;
ALTER TABLE `#__menu` ADD KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`, `language`);

INSERT INTO `#__menu` VALUES ('1', '', 'Menu_Item_Root', 'root', '', '', '', '', '1', '0', '0', '0', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '0', '197', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('4', 'mainmenu', 'Resources', 'resources', '', 'discover/resources', 'index.php?Itemid=', 'alias', '1', '41', '2', '0', '1', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"88\"}', '96', '101', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('5', 'mainmenu', 'Members', 'members', '', 'community/members', 'index.php?Itemid=', 'alias', '1', '76', '2', '0', '1', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"83\"}', '130', '131', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('6', 'mainmenu', 'Events', 'events', '', 'discover/events', 'index.php?Itemid=', 'alias', '1', '41', '2', '0', '7', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"85\"}', '112', '113', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('7', 'mainmenu', 'About', 'about', '', 'about', 'index.php?option=com_content&view=article&id=3', 'component', '1', '1', '1', '22', '5', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '141', '150', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('8', 'mainmenu', 'Support', 'support', '', 'support', 'index.php?Itemid=', 'alias', '1', '1', '1', '0', '6', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"84\"}', '153', '162', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('9', 'about', 'About Us', 'about', '', 'about', 'index.php?option=com_content&view=article&id=2', 'component', '1', '1', '1', '22', '1', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '', '65', '76', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('10', 'about', 'Contact Us', 'contact', '', 'about/contact', 'index.php?option=com_content&view=article&id=4', 'component', '1', '9', '2', '22', '1', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '66', '67', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('15', 'about', 'Copyright Infringement Notification', 'dmcapolicy', '', 'about/dmcapolicy', 'index.php?option=com_content&view=article&id=7', 'component', '1', '9', '2', '22', '3', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '70', '71', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('17', 'about', 'Our Cyberinfrastructure', 'hubzero', '', 'about/hubzero', 'index.php?option=com_content&view=article&id=2', 'component', '1', '9', '2', '22', '4', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '72', '73', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('19', 'about', 'Terms of Use', 'terms', '', 'about/terms', 'index.php?option=com_content&view=article&id=11', 'component', '1', '9', '2', '22', '2', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"1\",\"link_titles\":\"0\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '68', '69', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('20', 'mainmenu', 'What\'s New', 'whatsnew', '', 'discover/resources/whatsnew', 'index.php?option=com_whatsnew&view=results&layout=display', 'component', '1', '4', '3', '1030', '1', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"period\":\"resources:month\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '97', '98', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('21', 'mainmenu', 'Upload', 'upload', '', 'discover/resources/upload', '/resources/new', 'url', '1', '4', '3', '0', '2', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu_image\":\"0\"}', '99', '100', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('32', 'mainmenu', 'Groups', 'groups', '', 'community/groups', 'index.php?Itemid=', 'alias', '1', '76', '2', '0', '2', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"81\"}', '132', '133', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('37', 'mainmenu', 'Knowledge Base', 'knowledgebase', '', 'support/knowledgebase', 'index.php?Itemid=', 'alias', '1', '8', '2', '0', '1', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"82\"}', '154', '155', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('38', 'mainmenu', 'Report a Problem', 'reportproblems', '', 'support/reportproblems', '/feedback/report_problems', 'url', '1', '8', '2', '0', '2', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu_image\":\"0\"}', '156', '157', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('39', 'mainmenu', 'Tickets', 'tickets', '', 'support/tickets', '/support/tickets', 'url', '1', '8', '2', '0', '3', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu_image\":\"0\"}', '158', '159', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('40', 'mainmenu', 'Wish List', 'wishlist', '', 'support/wishlist', 'index.php?Itemid=', 'alias', '1', '8', '2', '0', '4', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"92\"}', '160', '161', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('41', 'mainmenu', 'Discover', 'discover', '', 'discover', 'index.php?option=com_content&view=article&id=22', 'component', '1', '1', '1', '22', '3', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '95', '120', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('42', 'mainmenu', 'Wiki', 'wiki', '', 'discover/wiki', 'index.php?Itemid=', 'alias', '1', '41', '2', '0', '5', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"86\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_text\":1}', '108', '109', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('43', 'mainmenu', 'Questions & Answers', 'answers', '', 'community/answers', 'index.php?Itemid=', 'alias', '1', '76', '2', '0', '4', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"77\"}', '136', '137', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('44', 'mainmenu', 'Tags', 'tags', '', 'discover/tags', 'index.php?Itemid=', 'alias', '1', '41', '2', '0', '4', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"89\"}', '106', '107', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('45', 'mainmenu', 'Citations', 'citations', '', 'discover/citations', 'index.php?Itemid=', 'alias', '1', '41', '2', '0', '6', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"79\"}', '110', '111', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('46', 'mainmenu', '&nbsp;', 'n', '', 'discover/n', '', 'separator', '1', '41', '2', '0', '3', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu_image\":\"0\"}', '104', '105', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('47', 'mainmenu', 'Feedback', 'feedback', '', 'discover/feedback', 'index.php?Itemid=', 'alias', '1', '41', '2', '0', '10', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"93\"}', '118', '119', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('48', 'mainmenu', 'Store', 'store', '', 'discover/store', 'index.php?Itemid=', 'alias', '1', '41', '2', '0', '9', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"90\"}', '116', '117', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('49', 'mainmenu', '&nbsp;', 'n', '', 'discover/n', '', 'separator', '1', '41', '2', '0', '8', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"menu_image\":\"0\"}', '114', '115', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('50', 'mainmenu', 'Tool Forge', 'tools', '', 'discover/tools', 'index.php?Itemid=', 'alias', '1', '41', '2', '0', '2', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"87\"}', '102', '103', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('55', 'default', 'Login', 'login', '', 'login', 'index.php?option=com_users&view=login', 'component', '1', '1', '1', '25', '4', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_login_title\":\"1\",\"header_login\":\"\",\"login_message\":\"0\",\"description_login\":\"1\",\"description_login_text\":\"Log in with your <br \\/> hub account.\",\"image_login\":\"\",\"image_login_align\":\"right\",\"show_logout_title\":\"1\",\"header_logout\":\"\",\"logout\":\"\",\"logout_message\":\"1\",\"description_logout\":\"1\",\"description_logout_text\":\"\",\"image_logout\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\",\"login_redirect_url\":\"\\/members\\/myaccount\"}', '123', '128', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('56', 'default', 'Logout', 'logout', '', 'logout', 'index.php?option=com_users&view=logout', 'component', '1', '1', '1', '25', '5', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_login_title\":\"1\",\"header_login\":\"\",\"login\":\"\",\"login_message\":\"0\",\"description_login\":\"0\",\"description_login_text\":\"\",\"image_login\":\"\",\"image_login_align\":\"right\",\"show_logout_title\":\"1\",\"header_logout\":\"\",\"logout\":\"\",\"logout_message\":\"1\",\"description_logout\":\"1\",\"description_logout_text\":\"\",\"image_logout\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '139', '140', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('59', 'default', 'Reset', 'reset', '', 'login/reset', 'index.php?option=com_users&view=reset', 'component', '1', '55', '2', '25', '2', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '126', '127', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('60', 'default', 'Remind', 'remind', '', 'login/remind', 'index.php?option=com_users&view=remind', 'component', '1', '55', '2', '25', '1', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '124', '125', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('65', 'mainmenu', 'Contact Us', 'contact', '', 'about/contact', 'index.php?option=com_content&view=article&id=4', 'component', '1', '7', '2', '22', '1', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '142', '143', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('66', 'mainmenu', 'Terms of Use', 'terms', '', 'about/terms', 'index.php?option=com_content&view=article&id=11', 'component', '1', '7', '2', '22', '2', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"1\",\"link_titles\":\"0\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '144', '145', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('67', 'mainmenu', 'Copyright Infringement', 'copyright', '', 'about/copyright', 'index.php?option=com_content&view=article&id=7', 'component', '1', '7', '2', '22', '3', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '146', '147', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('68', 'mainmenu', 'Our Cyberinfrastructure', 'hubzero', '', 'about/hubzero', 'index.php?option=com_content&view=article&id=2', 'component', '1', '7', '2', '22', '4', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '148', '149', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('69', 'legal', 'Legal', 'legal', '', 'legal', 'index.php?option=com_content&view=article&id=29', 'component', '1', '1', '1', '22', '1', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '77', '92', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('70', 'legal', 'Abuse Policy', 'abuse', '', 'legal/abuse', 'index.php?option=com_content&view=article&id=28', 'component', '1', '69', '2', '22', '1', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '78', '79', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('71', 'legal', 'Privacy Policy', 'privacy', '', 'legal/privacy', 'index.php?option=com_content&view=article&id=27', 'component', '1', '69', '2', '22', '2', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '80', '81', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('72', 'legal', 'Terms of Use', 'terms', '', 'legal/terms', 'index.php?option=com_content&view=article&id=11', 'component', '1', '69', '2', '22', '3', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"1\",\"link_titles\":\"0\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '82', '83', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('73', 'legal', 'Licensing Content', 'licensing', '', 'legal/licensing', 'index.php?option=com_content&view=article&id=12', 'component', '1', '69', '2', '22', '4', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '86', '87', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('74', 'legal', 'Submitting Content', 'license', '', 'legal/license', 'index.php?option=com_content&view=article&id=14', 'component', '1', '69', '2', '22', '5', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"0\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '88', '89', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('75', 'legal', 'Accessibility Statement', 'accessibility', '', 'legal/accessibility', 'index.php?option=com_content&view=article&id=30', 'component', '1', '69', '2', '22', '6', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '90', '91', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('76', 'mainmenu', 'Community', 'community', '', 'community', 'index.php?option=com_content&view=article&id=31', 'component', '1', '1', '1', '22', '4', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '129', '138', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('77', 'default', 'Questions & Answers', 'answers', '', 'answers', 'index.php?option=com_answers&view=questions&layout=search', 'component', '1', '1', '1', '1000', '14', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"notify_users\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '177', '178', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('78', 'default', 'Blog', 'blog', '', 'blog', 'index.php?option=com_blog&view=entries&layout=display', 'component', '1', '1', '1', '1002', '6', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"cleanintro\":\"\",\"introlength\":\"300\",\"show_authors\":\"\",\"allow_comments\":\"\",\"feeds_enabled\":\"\",\"feed_entries\":\"\",\"show_date\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '151', '152', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('79', 'default', 'Citations', 'citations', '', 'citations', 'index.php?option=com_citations&view=citations&layout=display', 'component', '1', '1', '1', '1003', '7', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"citation_label\":\"\",\"citation_rollover\":\"\",\"citation_sponsors\":\"\",\"citation_import\":\"\",\"citation_bulk_import\":\"\",\"citation_download\":\"\",\"citation_batch_download\":\"\",\"citation_download_exclude\":\"\",\"citation_coins\":\"\",\"citation_openurl\":\"\",\"citation_url\":\"\",\"citation_custom_url\":\"\",\"citation_cited\":\"\",\"citation_cited_single\":\"\",\"citation_cited_multiple\":\"\",\"citation_show_tags\":\"\",\"citation_allow_tags\":\"\",\"citation_show_badges\":\"\",\"citation_allow_badges\":\"\",\"citation_format\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '163', '164', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('80', 'default', 'Forum', 'forum', '', 'forum', 'index.php?option=com_forum&view=sections&layout=display', 'component', '1', '1', '1', '1009', '10', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"filepath\":\"\\/site\\/forum\",\"forum\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '169', '170', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('81', 'default', 'Groups', 'groups', '', 'groups', 'index.php?option=com_groups&view=intro', 'component', '1', '1', '1', '1010', '11', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"join_policy\":\"\",\"privacy\":\"\",\"auto_approve\":\"\",\"display_system_users\":\"\",\"email_comment_processing\":\"\",\"email_member_groupsidcussionemail_autosignup\":\"\",\"intro_mygroups\":\"\",\"intro_interestinggroups\":\"\",\"intro_populargroups\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '171', '172', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('82', 'default', 'Knowledge Base', 'kb', '', 'kb', 'index.php?option=com_kb&view=articles&layout=display', 'component', '1', '1', '1', '1013', '12', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_date\":\"\",\"allow_comments\":\"\",\"close_comments\":\"\",\"feeds_enabled\":\"\",\"feed_entries\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '173', '174', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('83', 'default', 'Members', 'members', '', 'members', 'index.php?option=com_members&view=profiles&layout=browse', 'component', '1', '1', '1', '1015', '13', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"privacy\":\"\",\"bankAccounts\":\"\",\"user_messaging\":\"\",\"employeraccess\":\"\",\"shadowMax\":\"\",\"shadowMin\":\"0\",\"shadowWarning\":\"7\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '175', '176', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('84', 'default', 'Support', 'support', '', 'support', 'index.php?option=com_support&view=index&layout=display', 'component', '1', '1', '1', '1023', '17', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"feed_summary\":\"\",\"emails\":\"{config.mailfrom}\",\"blacklist\":\"\",\"badwords\":\"viagra, pharmacy, xanax, phentermine, dating, ringtones, tramadol, hydrocodone, levitra, ambien, vicodin, fioricet, diazepam, cash advance, free online, online gambling, online prescriptions, debt consolidation, baccarat, loan, slots, credit, mortgage, casino, slot, texas holdem, teen nude, orgasm, gay, fuck, crap, shit, asshole, cunt, fucker, fuckers, motherfucker, fucking, milf, cocksucker, porno, videosex, sperm, hentai, internet gambling, kasino, kasinos, poker, lottery, texas hold em, texas holdem, fisting\",\"email_processing\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '183', '184', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('85', 'default', 'Events', 'events', '', 'events', 'index.php?option=com_events&view=browse&layout=month', 'component', '1', '1', '1', '1006', '8', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '165', '166', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('86', 'default', 'Wiki', 'wiki', '', 'wiki', 'index.php?option=com_wiki&view=page&layout=display', 'component', '1', '1', '1', '1031', '21', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '191', '192', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('87', 'default', 'Tool Forge', 'tools', '', 'tools', 'index.php?option=com_tools&view=tools&layout=display', 'component', '1', '1', '1', '1026', '19', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"mw_on\":\"\",\"shareable\":\"\",\"warn_multiples\":\"\",\"show_storage\":\"\",\"contribtool_on\":\"\",\"usedoi\":\"\",\"exec_pu\":\"\",\"screenshot_edit\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '187', '188', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('88', 'default', 'Resources', 'resources', '', 'resources', 'index.php?option=com_resources&view=intro', 'component', '1', '1', '1', '1020', '15', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"autoapprove\":\"\",\"autoapproved_users\":\"\",\"cc_license\":\"\",\"cc_license_custom\":\"\",\"email_when_approved\":\"\",\"browsetags\":\"\",\"show_authors\":\"\",\"show_assocs\":\"\",\"show_ranking\":\"\",\"show_rating\":\"\",\"show_date\":\"\",\"show_metadata\":\"\",\"show_citation\":\"\",\"show_audience\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '179', '180', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('89', 'default', 'Tags', 'tags', '', 'tags', 'index.php?option=com_tags&view=tags&layout=display', 'component', '1', '1', '1', '1025', '18', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '185', '186', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('90', 'default', 'Store', 'store', '', 'store', 'index.php?option=com_store&view=shop&layout=display', 'component', '1', '1', '1', '1022', '16', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"store_enabled\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '181', '182', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('92', 'default', 'Wishlist', 'wishlist', '', 'wishlist', 'index.php?option=com_wishlist&view=wishlist', 'component', '1', '1', '1', '1032', '22', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"banking\":\"\",\"allow_advisory\":\"\",\"votesplit\":\"\",\"show_percentage_granted\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '193', '194', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('93', 'default', 'Feedback', 'feedback', '', 'feedback', 'index.php?option=com_feedback&view=feedback&layout=display', 'component', '1', '1', '1', '1008', '9', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"blacklist\":\"\",\"badwords\":\"viagra, pharmacy, xanax, phentermine, dating, ringtones, tramadol, hydrocodone, levitra, ambien, vicodin, fioricet, diazepam, cash advance, free online, online gambling, online prescriptions, debt consolidation, baccarat, loan, slots, credit, mortgage, casino, slot, texas holdem, teen nude, orgasm, gay, fuck, crap, shit, asshole, cunt, fucker, fuckers, motherfucker, fucking, milf, cocksucker, porno, videosex, sperm, hentai, internet gambling, kasino, kasinos, poker, lottery, texas hold em, texas holdem, fisting\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '167', '168', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('94', 'default', 'What\'s New', 'whatsnew', '', 'whatsnew', 'index.php?option=com_whatsnew&view=results&layout=display', 'component', '1', '1', '1', '1030', '20', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"period\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '189', '190', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('95', 'default', 'Congratulations', 'congratulations', '', 'congratulations', 'index.php?option=com_content&view=article&id=32', 'component', '1', '1', '1', '22', '3', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"0\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '121', '122', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('96', 'legal', 'Creative Commons', 'cc', '', 'legal/cc', 'index.php?option=com_content&view=article&id=13', 'component', '1', '69', '2', '22', '3', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"show_section\":\"\",\"link_section\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"0\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '84', '85', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('97', 'about', 'Quotes', 'quotes', '', 'about/quotes', 'index.php?option=com_content&view=article&id=5', 'component', '1', '9', '2', '22', '5', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"1\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '74', '75', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('98', 'mainmenu', 'Projects', 'projects', '', 'community/projects', 'index.php?Itemid=', 'alias', '1', '76', '2', '0', '3', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"aliasoptions\":\"99\"}', '134', '135', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('99', 'default', 'Projects', 'projects', '', 'projects', 'index.php?option=com_projects&view=browse', 'component', '1', '1', '1', '1018', '22', '1000', '2012-09-20 18:41:28', '0', '1', '', '0', '{\"grantinfo\":\"\",\"confirm_step\":\"\",\"edit_settings\":\"\",\"restricted_data\":\"\",\"restricted_upfront\":\"\",\"approve_restricted\":\"\",\"offroot\":\"\",\"messaging\":\"\",\"privacy\":\"\",\"use_alias\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '195', '196', '0', '*', '0');
INSERT INTO `#__menu` VALUES ('100', 'default', 'Home', 'home', '', 'home', 'index.php?option=com_content&view=article&id=1', 'component', '1', '1', '1', '22', '2', '0', '0000-00-00 00:00:00', '0', '1', '', '0', '{\"show_noauth\":\"\",\"show_title\":\"0\",\"link_titles\":\"\",\"show_intro\":\"1\",\"show_section\":\"0\",\"link_section\":\"0\",\"show_category\":\"0\",\"link_category\":\"0\",\"show_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_vote\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"0\",\"show_email_icon\":\"0\",\"show_hits\":\"\",\"feed_summary\":\"\",\"page_title\":\"\",\"show_page_title\":\"1\",\"pageclass_sfx\":\"\",\"menu_image\":\"0\",\"secure\":\"0\"}', '93', '94', '1', '*', '0');
INSERT INTO `#__menu` VALUES ('101', 'main', 'com_answers', 'answers', '', 'answers', 'index.php?option=com_answers', 'component', '1', '1', '1', '1000', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '1', '2', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('102', 'main', 'com_billboards', 'billboards', '', 'billboards', 'index.php?option=com_billboards', 'component', '1', '1', '1', '1001', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '25', '26', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('103', 'main', 'com_blog', 'blog', '', 'blog', 'index.php?option=com_blog', 'component', '1', '1', '1', '1002', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '23', '24', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('104', 'main', 'com_citations', 'citations', '', 'citations', 'index.php?option=com_citations', 'component', '1', '1', '1', '1003', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '21', '22', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('105', 'main', 'com_cron', 'cron', '', 'cron', 'index.php?option=com_cron', 'component', '1', '1', '1', '1005', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '19', '20', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('106', 'main', 'com_events', 'events', '', 'events', 'index.php?option=com_events', 'component', '1', '1', '1', '1006', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '15', '16', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('107', 'main', 'com_feedback', 'feedback', '', 'feedback', 'index.php?option=com_feedback', 'component', '1', '1', '1', '1008', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '17', '18', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('108', 'main', 'com_groups', 'groups', '', 'groups', 'index.php?option=com_groups', 'component', '1', '1', '1', '1010', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '13', '14', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('109', 'main', 'com_jobs', 'jobs', '', 'jobs', 'index.php?option=com_jobs', 'component', '1', '1', '1', '1012', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '11', '12', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('110', 'main', 'com_kb', 'kb', '', 'kb', 'index.php?option=com_kb', 'component', '1', '1', '1', '1013', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '9', '10', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('111', 'main', 'com_members', 'members', '', 'members', 'index.php?option=com_members', 'component', '1', '1', '1', '1014', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '7', '8', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('112', 'main', 'com_newsletter', 'newsletter', '', 'newsletter', 'index.php?option=com_newsletter', 'component', '1', '1', '1', '1015', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '5', '6', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('113', 'main', 'com_poll', 'poll', '', 'poll', 'index.php?option=com_poll', 'component', '1', '1', '1', '1017', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '3', '4', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('114', 'main', 'com_projects', 'projects', '', 'projects', 'index.php?option=com_projects', 'component', '1', '1', '1', '1019', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '27', '28', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('115', 'main', 'com_register', 'register', '', 'register', 'index.php?option=com_register', 'component', '1', '1', '1', '1021', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '29', '30', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('116', 'main', 'com_resources', 'resources', '', 'resources', 'index.php?option=com_resources', 'component', '1', '1', '1', '1022', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '63', '64', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('117', 'main', 'com_services', 'services', '', 'services', 'index.php?option=com_services', 'component', '1', '1', '1', '1023', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '61', '62', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('118', 'main', 'com_store', 'store', '', 'store', 'index.php?option=com_store', 'component', '1', '1', '1', '1024', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '59', '60', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('119', 'main', 'com_support', 'support', '', 'support', 'index.php?option=com_support', 'component', '1', '1', '1', '1025', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '57', '58', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('120', 'main', 'com_system', 'system', '', 'system', 'index.php?option=com_system', 'component', '1', '1', '1', '1026', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '51', '52', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('121', 'main', 'com_tags', 'tags', '', 'tags', 'index.php?option=com_tags', 'component', '1', '1', '1', '1027', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '55', '56', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('122', 'main', 'com_tools', 'tools', '', 'tools', 'index.php?option=com_tools', 'component', '1', '1', '1', '1028', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '53', '54', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('123', 'main', 'com_usage', 'usage', '', 'usage', 'index.php?option=com_usage', 'component', '1', '1', '1', '1030', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '49', '50', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('124', 'main', 'com_wiki', 'wiki', '', 'wiki', 'index.php?option=com_wiki', 'component', '1', '1', '1', '1032', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '47', '48', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('125', 'main', 'com_wishlist', 'wishlist', '', 'wishlist', 'index.php?option=com_wishlist', 'component', '1', '1', '1', '1033', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '45', '46', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('126', 'main', 'com_ysearch', 'Ysearch', '', 'Ysearch', 'index.php?option=com_ysearch&task=configure', 'component', '1', '1', '1', '1034', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '33', '34', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('127', 'main', 'com_forum', 'com_forum', '', 'com_forum', 'index.php?option=com_forum', 'component', '1', '1', '1', '1009', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '39', '40', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('128', 'main', 'com_cart', 'com_cart', '', 'com_cart', 'index.php?option=com_cart', 'component', '1', '1', '1', '1035', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '37', '38', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('129', 'main', 'com_courses', 'com_courses', '', 'com_courses', 'index.php?option=com_courses', 'component', '1', '1', '1', '1004', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '35', '36', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('130', 'main', 'com_dataviewer', 'com_dataviewer', '', 'com_dataviewer', 'index.php?option=com_dataviewer', 'component', '1', '1', '1', '1018', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '31', '32', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('131', 'main', 'com_oaipmh', 'com_oaipmh', '', 'com_oaipmh', 'index.php?option=com_oaipmh', 'component', '1', '1', '1', '1016', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '43', '44', '0', '*', '1');
INSERT INTO `#__menu` VALUES ('132', 'main', 'com_publications', 'com_publications', '', 'com_publications', 'index.php?option=com_publications', 'component', '1', '1', '1', '1020', '0', '0', '0000-00-00 00:00:00', '0', '0', '', '0', '', '41', '42', '0', '*', '1');

--
-- HUBzero sample data for table `#__menu_types`
--

INSERT INTO `#__menu_types` (`id`, `menutype`, `title`, `description`) VALUES (2,'about','About','About Side Menu');
INSERT INTO `#__menu_types` (`id`, `menutype`, `title`, `description`) VALUES (3,'default','Default','default');
INSERT INTO `#__menu_types` (`id`, `menutype`, `title`, `description`) VALUES (4,'legal','Legal','Menu for policies and legal items');

--
-- HUBzero sample data for table `#__modules`
--



INSERT INTO `#__modules` VALUES (18,'Groups','','',1,'cpanel',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_groups',1,1,'{\"type\":\"1\",\"cache\":\"1\"}',1,'');
INSERT INTO `#__modules` VALUES (19,'Events Calendar','','',0,'eventsLeft',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_events_cal',1,0,'{\"moduleclass_sfx\":\"\",\"show_nav_prev_month\":\"1\",\"start_day\":\"0\",\"display_last_month\":\"NO\",\"display_last_month_days\":\"0\",\"show_nav_next_month\":\"1\",\"display_next_month\":\"NO\",\"display_next_month_days\":\"0\",\"cache\":\"0\",\"cache_time\":\"900\"}',0,'');
INSERT INTO `#__modules` VALUES (20,'Latest Events','','',0,'eventsRight',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_events_latest',1,1,'{\"moduleclass_sfx\":\"\",\"startday\":\"0\",\"max_events\":\"10\",\"mode\":\"2\",\"announcements\":\"0\",\"days\":\"365\",\"display_links\":\"0\",\"display_year\":\"0\",\"display_date_style\":\"0\",\"display_title_style\":\"0\",\"no_repeat\":\"1\",\"char_limit\":\"150\",\"cache\":\"0\",\"cache_time\":\"900\"}',0,'');
INSERT INTO `#__modules` VALUES (21,'Featured Resource','','',0,'featureLeft',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_featuredresource',1,1,'{\"catid\":\"\",\"moduleclass_sfx\":\"featured-resource\",\"txt_length\":\"200\",\"minranking\":\"6.0\",\"tag\":\"\",\"cache\":\"1\",\"cache_time\":\"900\"}',0,'');
INSERT INTO `#__modules` VALUES (22,'Community Poll','','',0,'featureMiddle',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_poll',1,1,'{\"formid\":\"\",\"cache\":\"1\"}',0,'');
INSERT INTO `#__modules` VALUES (23,'Featured Tool','','',0,'featureRight',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_featuredresource',1,1,'{\"catid\":\"\",\"moduleclass_sfx\":\"featured-resource\",\"txt_length\":\"200\",\"type\":\"tools\",\"minranking\":\"6.0\",\"tag\":\"\",\"cache\":\"1\",\"cache_time\":\"900\"}',0,'');
INSERT INTO `#__modules` VALUES (24,'Hub Footer','','<h2>Helpful Links</h2>\r\n<div id=\"ancillary\" class=\"grid cf\">\r\n\r\n	<div class=\"col span-quarter\">\r\n		<h3>Get Help</h3>\r\n		<ul>\r\n			<li><a href=\"/support/ticket/new\">Report problems</a></li>\r\n			<li><a href=\"/user/remind\">Forgot username?</a></li>\r\n			<li><a href=\"/user/reset\">Lost password?</a></li>\r\n			<li><a href=\"/legal/accessibility\">Accessibility Issues</a></li>\r\n			<li><a href=\"/about/contact\">Contact us</a></li>\r\n		</ul>\r\n	</div>\r\n	<div class=\"col span-quarter\">\r\n		<h3>Participate</h3>\r\n		<ul>\r\n			<li><a href=\"/resources/new\">Submit a resource</a></li>\r\n			<li><a href=\"/groups/new\">Create a group</a></li>\r\n			<li><a href=\"/answers\"><span>Answer questions</span></a></li>\r\n			<li><a href=\"/wishlist\"><span>Make a wish</span></a></li>\r\n			<li><a href=\"/forum\"><span>Join the discussion</span></a></li>\r\n		</ul>\r\n	</div>\r\n	<div class=\"col span-quarter\">\r\n		<h3>Discover</h3>\r\n		<ul>\r\n			<li><a href=\"/whatsnew\"><span>What\'s New</span></a></li>\r\n			<li><a href=\"/resources\"><span>Resources</span></a></li>\r\n			<li><a href=\"/wiki\"><span>Wiki</span></a></li>\r\n			<li><a href=\"/tags\"><span>Tags</span></a></li>\r\n			<li><a href=\"/kb\"><span>Knowledge Base</span></a></li>\r\n		</ul>\r\n	</div>\r\n	<div class=\"col span-quarter omega\">\r\n		<h3>Learn</h3>\r\n		<ul>\r\n			<li><a href=\"/about\">About us</a></li>\r\n			<li><a href=\"/legal/terms\">Terms of use</a></li>\r\n			<li><a href=\"/legal/privacy\">Privacy Policy</a></li>\r\n			<li><a href=\"/legal/abuse\">Abuse Policy</a></li>\r\n			<li><a href=\"/about/dmcapolicy\">Copyright Infringement</a></li>\r\n		</ul>\r\n	</div>\r\n\r\n</div><!-- / footer nav -->\r\n<div class=\"inner\">\r\n<ul id=\"legalese\">\r\n	<li class=\"policy\">Copyright &copy; 2012 Hubzilla</li>\r\n	<li>Powered by <a href=\"http://hubzero.org\" rel=\"external\">HUBzero<sup>&reg;</sup></a>, a <a href=\"http://www.purdue.edu\" title=\"Purdue University\" rel=\"external\">Purdue</a> project</li>\r\n</ul><!-- / footer #legalese -->\r\n</div>', '1', 'footer', '0', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '1', 'mod_custom', '1', '0', '{\"prepare_content\":\"0\",\"backgroundimage\":\"\",\"layout\":\"_:default\",\"moduleclass_sfx\":\"\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}',0,'*');
INSERT INTO `#__modules` VALUES (25,'Trouble Report','','',0,'helppane',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_reportproblems',1,0,'{\"moduleclass_sfx\":\"\",\"cache\":\"0\"}',0,'');
INSERT INTO `#__modules` VALUES (26,'Support Tickets','','',0,'icon',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_supporttickets',1,1,'{\"cache\":\"1\"}',1,'');
INSERT INTO `#__modules` VALUES (27,'Resources','','',1,'icon',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_resources',1,1,'{\"cache\":\"1\"}',1,'');
INSERT INTO `#__modules` VALUES (28,'Wish List','','',2,'icon',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_wishlist',1,1,'{\"wishlist\":\"\",\"showMine\":\"0\",\"cache\":\"1\"}',1,'');
INSERT INTO `#__modules` VALUES (29,'Questions & Answers','','',3,'icon',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_answers',1,1,'{\"showMine\":\"0\",\"cache\":\"1\"}',1,'');
INSERT INTO `#__modules` VALUES (30,'Dashboard','','',4,'icon',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',0,'mod_dashboard',1,0,'',1,'');
INSERT INTO `#__modules` VALUES (31,'About','','',0,'left',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_menu',1,1,'{\"menutype\":\"about\",\"menu_style\":\"list\",\"startLevel\":\"0\",\"endLevel\":\"0\",\"showAllChildren\":\"1\",\"window_open\":\"\",\"show_whitespace\":\"0\",\"cache\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"moduleclass_sfx\":\"\",\"maxdepth\":\"10\",\"menu_images\":\"0\",\"menu_images_align\":\"0\",\"menu_images_link\":\"0\",\"expand_menu\":\"0\",\"activate_parent\":\"0\",\"full_active_id\":\"0\",\"indent_image\":\"0\",\"indent_image1\":\"\",\"indent_image2\":\"\",\"indent_image3\":\"\",\"indent_image4\":\"\",\"indent_image5\":\"\",\"indent_image6\":\"\",\"spacer\":\"\",\"end_spacer\":\"\"}',0,'');
INSERT INTO `#__modules` VALUES (32,'Legal Menu','','',1,'left',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_menu',1,1,'{\"menutype\":\"legal\",\"menu_style\":\"list\",\"startLevel\":\"0\",\"endLevel\":\"0\",\"showAllChildren\":\"0\",\"window_open\":\"\",\"show_whitespace\":\"0\",\"cache\":\"1\",\"tag_id\":\"\",\"class_sfx\":\"\",\"moduleclass_sfx\":\"\",\"maxdepth\":\"10\",\"menu_images\":\"0\",\"menu_images_align\":\"0\",\"menu_images_link\":\"0\",\"expand_menu\":\"0\",\"activate_parent\":\"0\",\"full_active_id\":\"0\",\"indent_image\":\"0\",\"indent_image1\":\"\",\"indent_image2\":\"\",\"indent_image3\":\"\",\"indent_image4\":\"\",\"indent_image5\":\"\",\"indent_image6\":\"\",\"spacer\":\"\",\"end_spacer\":\"\"}',0,'');
INSERT INTO `#__modules` VALUES (33,'My Groups','','',0,'myhub',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_mygroups',1,0,'',0,'');
INSERT INTO `#__modules` VALUES (34,'My Drafts','','',6,'myhub',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_mycontributions',1,0,'{\"show_tools\":\"1\",\"get_questions\":\"1\",\"get_wishes\":\"1\",\"get_tickets\":\"1\",\"limit_tools\":\"10\",\"limit_other\":\"10\"}',0,'');
INSERT INTO `#__modules` VALUES (35,'My Points','','',8,'myhub',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_mypoints',1,1,'',0,'');
INSERT INTO `#__modules` VALUES (36,'My Tools','','',3,'myhub',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_mytools',1,0,'',0,'');
INSERT INTO `#__modules` VALUES (37,'My Tickets','','',4,'myhub',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_mytickets',1,1,'',0,'');
INSERT INTO `#__modules` VALUES (38,'My Questions','','',9,'myhub',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_myquestions',1,0,'',0,'');
INSERT INTO `#__modules` VALUES (39,'My Wishes','','',7,'myhub',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_mywishes',1,0,'',0,'');
INSERT INTO `#__modules` VALUES (40,'My Messages','','',5,'myhub',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_mymessages',1,0,'',0,'');
INSERT INTO `#__modules` VALUES (41,'My Sessions','','',1,'myhub',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_mysessions',1,0,'{\"moduleclass_sfx\":\"\",\"show_storage\":\"1\",\"hubvnc\":\"\"}',0,'');
INSERT INTO `#__modules` VALUES (42,'My Projects','','',2,'myhub',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_myprojects',1,1,'{\"moduleclass\":\"md-projects\",\"limit\":\"5\"}',0,'');
INSERT INTO `#__modules` VALUES (43,'Resources','','<ul>\r\n	<li><a href=\"/resources/tools\">Simulation Tools</a></li>\r\n	<li><a href=\"/resources/seminars\">Seminars</a></li>\r\n	<li><a href=\"/resources/workshops\">Workshops</a></li>\r\n	<li><a href=\"/resources/courses\">Courses</a></li>\r\n	<li><a href=\"/resources/teachingmaterials\">Teaching Materials</a></li>\r\n	<li><a href=\"/resources/publications\">Publications</a></li>\r\n	<li><a href=\"/resources/downloads\">Downloads</a></li>\r\n</ul>',10,'myhub',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_custom',1,1,'{\"moduleclass_sfx\":\"\"}',0,'');
INSERT INTO `#__modules` VALUES (44,'Dashboard Introduction','','<p>Welcome to your customizable dashboard page!</p>\r\n\r\n<p>To get started, click the \"Personalize\" button towards the top of this page. You will then be presented with a list of modules you may add to your page. You may also, at that time, remove any unwanted modules or rearrange the current modules by drag-and-drop!</p>',11,'myhub',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_custom',1,1,'{\"moduleclass_sfx\":\"\"}',0,'');
INSERT INTO `#__modules` VALUES (45,'Notices','','',0,'notices',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_notices',1,0,'{\"start_publishing\":\"0000-00-00 00:00:00\",\"stop_publishing\":\"0000-00-00 00:00:00\",\"alertlevel\":\"low\",\"moduleid\":\"\",\"message\":\"\",\"allowClose\":\"0\"}',0,'');
INSERT INTO `#__modules` VALUES (46,'Quotes','','',1,'quotes',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_quotes',1,0,'{\"cache\":\"0\",\"moduleclass_sfx\":\"\",\"maxquotes\":\"\"}',0,'');
INSERT INTO `#__modules` VALUES (47,'Search','','',0,'search',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_search',1,0,'{\"moduleclass_sfx\":\"\",\"width\":\"20\",\"text\":\"Search\",\"button\":\"\",\"button_pos\":\"right\",\"imagebutton\":\"\",\"button_text\":\"Go\",\"set_itemid\":\"\",\"cache\":\"1\",\"cache_time\":\"900\"}',0,'');
INSERT INTO `#__modules` VALUES (48,'My Submissions','','',7,'submissions',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_mysubmissions',1,0,'',0,'');
INSERT INTO `#__modules` VALUES (49,'Browse Content by Tags','','',0,'toptags',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_toptags',1,1,'{\"numtags\":\"25\",\"exclude\":\"\",\"message\":\"\",\"sortby\":\"alphabeta\",\"morelnk\":\"0\",\"cache\":\"0\",\"cache_time\":\"900\"}',0,'');
INSERT INTO `#__modules` VALUES (50,'Congratulations','','<div id=\"congrats\">\r\n<h2>Welcome to HUBzero!</h2>\r\n<p>Congratulations! Your new hub is up and running. This is a skeleton site and basic template to serve as a starting point for you to begin building your hub.</p>\r\n</div>',0,'welcome',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_custom',1,1,'{\"moduleclass_sfx\":\"\"}',0,'');
INSERT INTO `#__modules` VALUES (51,'Welcome','','<div id=\"welcome\">\r\n<h2>Welcome to our site!</h2>\r\n<p>\r\nThis project has an <a href=\"/about\">important mission</a> of revolutionizing scientific research and educational activities.\r\n</p>\r\n</div>',1,'welcome',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_custom',1,1,'{\"moduleclass_sfx\":\"\"}',0,'');
INSERT INTO `#__modules` VALUES (52,'Accessibility Contact','','',1,'accessibilitycontact',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_rapid_contact',1,1,'{\"name_label\":\"Name:\",\"email_label\":\"Email:\",\"subject_label\":\"Subject:\",\"message_label\":\"Message:\",\"email_recipient\":\"\",\"button_text\":\"Send Message\",\"page_text\":\"Thank you for your contact.\",\"error_text\":\"Your message could not be sent. Please try again.\",\"no_email\":\"Please write your email\",\"invalid_email\":\"Please write a valid email\",\"from_name\":\"\",\"from_email\":\"\",\"exact_url\":\"1\",\"disable_https\":\"0\",\"pre_text\":\"We welcome your feedback and invite you to let us know if you have trouble accessing this site. Please send us an email using this form and describe the problem in as much detail as possible, including the URL of the page you were on, the type of problem, and any other information that you would deem necessary for us to better diagnose and resolve the issue.\",\"fixed_url\":\"0\",\"fixed_url_address\":\"\",\"enable_anti_spam\":\"1\",\"anti_spam_q\":\"How many eyes has a typical person?\",\"anti_spam_a\":\"2\",\"moduleclass_sfx\":\"\"}',0,'');
INSERT INTO `#__modules` VALUES (53,'Members','','',0,'cpanel',0,'0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00',1,'mod_members',1,1,'{\"cache\":\"1\"}',1,'');

--
-- HUBzero sample data for table `#__modules_menu`
--

TRUNCATE `#__modules_menu`;
INSERT INTO `#__modules_menu` VALUES (1,0);
INSERT INTO `#__modules_menu` VALUES (2,0);
INSERT INTO `#__modules_menu` VALUES (3,0);
INSERT INTO `#__modules_menu` VALUES (4,0);
INSERT INTO `#__modules_menu` VALUES (5,0);
INSERT INTO `#__modules_menu` VALUES (6,0);
INSERT INTO `#__modules_menu` VALUES (7,0);
INSERT INTO `#__modules_menu` VALUES (8,0);
INSERT INTO `#__modules_menu` VALUES (10,0);
INSERT INTO `#__modules_menu` VALUES (11,0);
INSERT INTO `#__modules_menu` VALUES (12,0);
INSERT INTO `#__modules_menu` VALUES (13,0);
INSERT INTO `#__modules_menu` VALUES (14,0);
INSERT INTO `#__modules_menu` VALUES (15,0);
INSERT INTO `#__modules_menu` VALUES (16,0);
INSERT INTO `#__modules_menu` VALUES (17,0);
INSERT INTO `#__modules_menu` VALUES (18,0);
INSERT INTO `#__modules_menu` VALUES (19,100);
INSERT INTO `#__modules_menu` VALUES (20,100);
INSERT INTO `#__modules_menu` VALUES (21,100);
INSERT INTO `#__modules_menu` VALUES (22,100);
INSERT INTO `#__modules_menu` VALUES (23,100);
INSERT INTO `#__modules_menu` VALUES (24,0);
INSERT INTO `#__modules_menu` VALUES (25,0);
INSERT INTO `#__modules_menu` VALUES (26,0);
INSERT INTO `#__modules_menu` VALUES (27,0);
INSERT INTO `#__modules_menu` VALUES (28,0);
INSERT INTO `#__modules_menu` VALUES (29,0);
INSERT INTO `#__modules_menu` VALUES (30,0);
INSERT INTO `#__modules_menu` VALUES (31,7);
INSERT INTO `#__modules_menu` VALUES (31,9);
INSERT INTO `#__modules_menu` VALUES (31,10);
INSERT INTO `#__modules_menu` VALUES (31,15);
INSERT INTO `#__modules_menu` VALUES (31,17);
INSERT INTO `#__modules_menu` VALUES (31,19);
INSERT INTO `#__modules_menu` VALUES (31,46);
INSERT INTO `#__modules_menu` VALUES (31,65);
INSERT INTO `#__modules_menu` VALUES (31,66);
INSERT INTO `#__modules_menu` VALUES (31,67);
INSERT INTO `#__modules_menu` VALUES (31,68);
INSERT INTO `#__modules_menu` VALUES (31,97);
INSERT INTO `#__modules_menu` VALUES (32,69);
INSERT INTO `#__modules_menu` VALUES (32,70);
INSERT INTO `#__modules_menu` VALUES (32,71);
INSERT INTO `#__modules_menu` VALUES (32,72);
INSERT INTO `#__modules_menu` VALUES (32,73);
INSERT INTO `#__modules_menu` VALUES (32,74);
INSERT INTO `#__modules_menu` VALUES (32,75);
INSERT INTO `#__modules_menu` VALUES (32,96);
INSERT INTO `#__modules_menu` VALUES (45,0);
INSERT INTO `#__modules_menu` VALUES (46,12);
INSERT INTO `#__modules_menu` VALUES (47,0);
INSERT INTO `#__modules_menu` VALUES (49,100);
INSERT INTO `#__modules_menu` VALUES (50,95);
INSERT INTO `#__modules_menu` VALUES (51,100);
INSERT INTO `#__modules_menu` VALUES (52,75);

--
-- HUBzero sample data for table `#__password_blacklist`
--

INSERT INTO `#__password_blacklist` (`id`, `word`) VALUES (1,'hubzero');
INSERT INTO `#__password_blacklist` (`id`, `word`) VALUES (2,'test');
INSERT INTO `#__password_blacklist` (`id`, `word`) VALUES (3,'password');
INSERT INTO `#__password_blacklist` (`id`, `word`) VALUES (4,'secret');

--
-- HUBzero sample data for table `#__password_rule`
--

INSERT INTO `#__password_rule` VALUES ('','Must be changed at least every 120 days',0,'Must be changed at least every 120 days','hub',20,10,'notStale','120');
INSERT INTO `#__password_rule` VALUES ('','Must be different than the previous password (re-use of the same password will not be allowed for one (1) year)',0,'Must be different than the previous password (re-use of the same password will not be allowed for one (1) year)','hub',19,9,'notReused','365');
INSERT INTO `#__password_rule` VALUES ('','Must not contain your username',0,'Must not contain your username','hub',18,8,'notUsernameBased','');
INSERT INTO `#__password_rule` VALUES ('','Must not contain your name or parts of your name',0,'Must not contain your name or parts of your name','hub',17,7,'notNameBased','');
INSERT INTO `#__password_rule` VALUES ('','Must not contain easily guessed words',1,'Must not contain easily guessed words','hub',16,6,'notBlacklisted','');
INSERT INTO `#__password_rule` VALUES ('','Must contain more than 4 unique characters',1,'Must contain more than 4 unique characters','hub',15,5,'minUniqueCharacters','5');
INSERT INTO `#__password_rule` VALUES ('','Must be no longer than 16 characters',1,'Must be no longer than 16 characters','hub',14,4,'maxPasswordLength','16');
INSERT INTO `#__password_rule` VALUES ('','Must be at least 8 characters long',1,'Must be at least 8 characters long','hub',13,3,'minPasswordLength','8');
INSERT INTO `#__password_rule` VALUES ('nonalpha','Must contain at least 1 number or punctuation mark',1,'Must contain at least 1 number or punctuation mark','hub',12,2,'minClassCharacters','1');
INSERT INTO `#__password_rule` VALUES ('alpha','Must contain at least 1 letter',1,'Must contain at least 1 letter','hub',11,1,'minClassCharacters','1');

--
-- HUBzero sample data for table `#__resource_licenses`
--

INSERT INTO `#__resource_licenses` (`id`, `name`, `text`, `title`, `ordering`, `apps_only`, `main`, `icon`, `url`, `agreement`, `info`) VALUES (1,'cc25-by-nc-sa','You are free:\r\n\r\nto Share — to copy, distribute and transmit the work\r\nto Remix — to adapt the work\r\n\r\nUnder the following conditions:\r\n\r\nAttribution — You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).\r\nNoncommercial — You may not use this work for commercial purposes.\r\n\r\nShare Alike — If you alter, transform, or build upon this work, you may distribute the resulting work only under the same or similar license to this one.\r\n\r\nWith the understanding that:\r\n\r\nWaiver — Any of the above conditions can be waived if you get permission from the copyright holder.\r\n\r\nPublic Domain — Where the work or any of its elements is in the public domain under applicable law, that status is in no way affected by the license.\r\n\r\nOther Rights — In no way are any of the following rights affected by the license:\r\n- Your fair dealing or fair use rights, or other applicable copyright exceptions and limitations;\r\n- The author\'s moral rights;\r\n- Rights other persons may have either in the work itself or in how the work is used, such as publicity or privacy rights.\r\n\r\nNotice — For any reuse or distribution, you must make clear to others the license terms of this work. The best way to do this is with a link to this web page.','Creative Commons BY-NC-SA 2.5',6,0,NULL,NULL,'http://creativecommons.org/licenses/by-nc-sa/2.5/',0,NULL);
INSERT INTO `#__resource_licenses` (`id`, `name`, `text`, `title`, `ordering`, `apps_only`, `main`, `icon`, `url`, `agreement`, `info`) VALUES (2,'cc30-by-nc-sa','You are free:\r\n\r\nto Share — to copy, distribute and transmit the work\r\nto Remix — to adapt the work\r\n\r\nUnder the following conditions:\r\n\r\nAttribution — You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).\r\n\r\nNoncommercial — You may not use this work for commercial purposes.\r\n\r\nShare Alike — If you alter, transform, or build upon this work, you may distribute the resulting work only under the same or similar license to this one.\r\n\r\nWith the understanding that:\r\n\r\nWaiver — Any of the above conditions can be waived if you get permission from the copyright holder.\r\n\r\nPublic Domain — Where the work or any of its elements is in the public domain under applicable law, that status is in no way affected by the license.\r\n\r\nOther Rights — In no way are any of the following rights affected by the license:\r\n- Your fair dealing or fair use rights, or other applicable copyright exceptions and limitations;\r\n- The author\'s moral rights;\r\n- Rights other persons may have either in the work itself or in how the work is used, such as publicity or privacy rights.','Creative Commons BY-NC-SA 3.0',7,0,NULL,NULL,'http://creativecommons.org/licenses/by-nc-sa/3.0/',0,NULL);
INSERT INTO `#__resource_licenses` (`id`, `name`, `text`, `title`, `ordering`, `apps_only`, `main`, `icon`, `url`, `agreement`, `info`) VALUES (3,'cc','You are free:\r\n\r\nto Share — to copy, distribute and transmit the work\r\nto Remix — to adapt the work\r\n\r\nUnder the following conditions:\r\n\r\nAttribution — You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).\r\nNoncommercial — You may not use this work for commercial purposes.\r\n\r\nShare Alike — If you alter, transform, or build upon this work, you may distribute the resulting work only under the same or similar license to this one.\r\n\r\nWith the understanding that:\r\n\r\nWaiver — Any of the above conditions can be waived if you get permission from the copyright holder.\r\n\r\nPublic Domain — Where the work or any of its elements is in the public domain under applicable law, that status is in no way affected by the license.\r\n\r\nOther Rights — In no way are any of the following rights affected by the license:\r\n- Your fair dealing or fair use rights, or other applicable copyright exceptions and limitations;\r\n- The author\'s moral rights;\r\n- Rights other persons may have either in the work itself or in how the work is used, such as publicity or privacy rights.\r\n\r\nNotice — For any reuse or distribution, you must make clear to others the license terms of this work. The best way to do this is with a link to this web page.','Creative Commons',1,0,NULL,NULL,'http://creativecommons.org/licenses/by-nc-sa/2.5/',0,NULL);
INSERT INTO `#__resource_licenses` (`id`, `name`, `text`, `title`, `ordering`, `apps_only`, `main`, `icon`, `url`, `agreement`, `info`) VALUES (4,'cc30-by-nc-nd','You are free:\r\n\r\nto Share — to copy, distribute and transmit the work\r\n\r\nUnder the following conditions:\r\n\r\nAttribution — You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).\r\n\r\nNoncommercial — You may not use this work for commercial purposes.\r\n\r\nNo Derivative Works — You may not alter, transform, or build upon this work.\r\nWith the understanding that:\r\n\r\nWaiver — Any of the above conditions can be waived if you get permission from the copyright holder.\r\n\r\nPublic Domain — Where the work or any of its elements is in the public domain under applicable law, that status is in no way affected by the license.\r\n\r\nOther Rights — In no way are any of the following rights affected by the license:\r\n- Your fair dealing or fair use rights, or other applicable copyright exceptions and limitations;\r\n- The author\'s moral rights;\r\n- Rights other persons may have either in the work itself or in how the work is used, such as publicity or privacy rights.','Creative Commons BY-NC-ND 3.0',8,0,NULL,NULL,'http://creativecommons.org/licenses/by-nc-nd/3.0/',0,NULL);
INSERT INTO `#__resource_licenses` (`id`, `name`, `text`, `title`, `ordering`, `apps_only`, `main`, `icon`, `url`, `agreement`, `info`) VALUES (5,'cc30-by','You are free:\r\n\r\nto Share — to copy, distribute and transmit the work\r\nto Remix — to adapt the work\r\nto make commercial use of the work\r\n\r\nUnder the following conditions:\r\n\r\nAttribution — You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).\r\nWith the understanding that:\r\n\r\nWaiver — Any of the above conditions can be waived if you get permission from the copyright holder.\r\n\r\nPublic Domain — Where the work or any of its elements is in the public domain under applicable law, that status is in no way affected by the license.\r\n\r\nOther Rights — In no way are any of the following rights affected by the license:\r\n- Your fair dealing or fair use rights, or other applicable copyright exceptions and limitations;\r\n- The author\'s moral rights;\r\n- Rights other persons may have either in the work itself or in how the work is used, such as publicity or privacy rights.','Creative Commons BY 3.0',2,0,NULL,NULL,'http://creativecommons.org/licenses/by/3.0/',0,NULL);
INSERT INTO `#__resource_licenses` (`id`, `name`, `text`, `title`, `ordering`, `apps_only`, `main`, `icon`, `url`, `agreement`, `info`) VALUES (6,'cc30-by-sa','You are free:\r\n\r\nto Share — to copy, distribute and transmit the work\r\nto Remix — to adapt the work\r\nto make commercial use of the work\r\n\r\nUnder the following conditions:\r\n\r\nAttribution — You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).\r\n\r\nShare Alike — If you alter, transform, or build upon this work, you may distribute the resulting work only under the same or similar license to this one.\r\nWith the understanding that:\r\n\r\nWaiver — Any of the above conditions can be waived if you get permission from the copyright holder.\r\n\r\nPublic Domain — Where the work or any of its elements is in the public domain under applicable law, that status is in no way affected by the license.\r\n\r\nOther Rights — In no way are any of the following rights affected by the license:\r\n- Your fair dealing or fair use rights, or other applicable copyright exceptions and limitations;\r\n- The author\'s moral rights;\r\n- Rights other persons may have either in the work itself or in how the work is used, such as publicity or privacy rights.','Creative Commons BY-SA 3.0',3,0,NULL,NULL,'http://creativecommons.org/licenses/by-sa/3.0/',0,NULL);
INSERT INTO `#__resource_licenses` (`id`, `name`, `text`, `title`, `ordering`, `apps_only`, `main`, `icon`, `url`, `agreement`, `info`) VALUES (7,'cc30-by-nd','You are free:\r\n\r\nto Share — to copy, distribute and transmit the work\r\nto make commercial use of the work\r\n\r\nUnder the following conditions:\r\n\r\nAttribution — You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).\r\n\r\nNo Derivative Works — You may not alter, transform, or build upon this work.\r\n\r\nWith the understanding that:\r\n\r\nWaiver — Any of the above conditions can be waived if you get permission from the copyright holder.\r\n\r\nPublic Domain — Where the work or any of its elements is in the public domain under applicable law, that status is in no way affected by the license.\r\n\r\nOther Rights — In no way are any of the following rights affected by the license:\r\n- Your fair dealing or fair use rights, or other applicable copyright exceptions and limitations;\r\nThe author\'s moral rights;\r\n- Rights other persons may have either in the work itself or in how the work is used, such as publicity or privacy rights.','Creative Commons BY-ND 3.0',4,0,NULL,NULL,'http://creativecommons.org/licenses/by-nd/3.0/',0,NULL);
INSERT INTO `#__resource_licenses` (`id`, `name`, `text`, `title`, `ordering`, `apps_only`, `main`, `icon`, `url`, `agreement`, `info`) VALUES (8,'cc30-by-nc','You are free:\r\n\r\nto Share — to copy, distribute and transmit the work\r\nto Remix — to adapt the work\r\n\r\nUnder the following conditions:\r\n\r\nAttribution — You must attribute the work in the manner specified by the author or licensor (but not in any way that suggests that they endorse you or your use of the work).\r\n\r\nNoncommercial — You may not use this work for commercial purposes.\r\n\r\nWith the understanding that:\r\n\r\nWaiver — Any of the above conditions can be waived if you get permission from the copyright holder.\r\n\r\nPublic Domain — Where the work or any of its elements is in the public domain under applicable law, that status is in no way affected by the license.\r\n\r\nOther Rights — In no way are any of the following rights affected by the license:\r\n- Your fair dealing or fair use rights, or other applicable copyright exceptions and limitations;\r\n- The author\'s moral rights;\r\n- Rights other persons may have either in the work itself or in how the work is used, such as publicity or privacy rights.','Creative Commons BY-NC 3.0',5,0,NULL,NULL,'http://creativecommons.org/licenses/by-nc/3.0/',0,NULL);

--
-- HUBzero sample data for table `#__resource_types`
--

INSERT INTO `#__resource_types` VALUES ('1', 'seminars', 'Seminars', '27', 'A lecture of some sort, usually recorded with voice or video.  It may be a graduate or undergraduate level seminar, a lecture for a class, or a tutorial presentation.', '1', '{\"fields\":[{\"default\":\"\",\"name\":\"bio\",\"label\":\"Bio\",\"type\":\"textarea\",\"required\":\"0\"},{\"default\":\"\",\"name\":\"credits\",\"label\":\"Credits\",\"type\":\"textarea\",\"required\":\"0\"},{\"default\":\"\",\"name\":\"sponsoredby\",\"label\":\"Sponsored by\",\"type\":\"textarea\",\"required\":\"0\"}]}', 'plg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=1\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('2', 'workshops', 'Workshops', '27', 'A collection of lectures, seminars, and materials that were presented at a workshop.', '0', 'credits=Credits=textarea=0\nsponsoredby=Sponsored by=textarea=0', 'plg_citations=0\nplg_questions=0\nplg_recommendations=1\nplg_related=1\nplg_reviews=1\nplg_usage=0\nplg_versions=0\nplg_favorite=1\nplg_share=1\nplg_wishlist=0\nplg_supportingdocs=1\nplg_about=1\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('3', 'publications', 'Publications', '27', 'Articles, technical reports, theses, and other documents, usually in PDF or DOC format.', '1', 'acknowledgments=Acknowledgments=textarea=0\nreferences=References=textarea=0', 'plg_citations=0\nplg_questions=0\nplg_recommendations=1\nplg_related=1\nplg_reviews=1\nplg_usage=0\nplg_versions=0\nplg_favorite=1\nplg_share=1\nplg_wishlist=0\nplg_supportingdocs=1\nplg_about=1\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('6', 'courses', 'Courses', '27', 'University courses and short courses with lectures and associated teaching materials.', '0', 'credits=Credits=textarea=0\nreferences=References=textarea=0\nsponsoredby=Sponsored by=textarea=0', 'plg_citations=0\nplg_questions=0\nplg_recommendations=1\nplg_related=1\nplg_reviews=1\nplg_usage=0\nplg_versions=0\nplg_favorite=1\nplg_share=1\nplg_wishlist=0\nplg_supportingdocs=1\nplg_about=1\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('7', 'tools', 'Tools', '27', 'Simulation and modeling tools that can be accessed via a web browser.', '1', 'poweredby=Powered by=textarea=0\ncredits=Credits=textarea=0\nsponsoredby=Sponsored by=textarea=0\nreferences=References=textarea=0', 'plg_citations=1\nplg_questions=1\nplg_recommendations=1\nplg_related=1\nplg_reviews=1\nplg_usage=1\nplg_versions=1\nplg_favorite=1\nplg_share=1\nplg_wishlist=1\nplg_supportingdocs=1\nplg_about=0\nplg_abouttool=1');
INSERT INTO `#__resource_types` VALUES ('9', 'downloads', 'Downloads', '27', 'Spreadsheets, executables, and other items that are available for download but don\\\'t fit into other categories.', '1', '{\"fields\":[{\"default\":\"\",\"name\":\"credits\",\"label\":\"Credits\",\"type\":\"textarea\",\"required\":\"0\"},{\"default\":\"\",\"name\":\"sponsoredby\",\"label\":\"Sponsored by\",\"type\":\"textarea\",\"required\":\"0\"},{\"default\":\"\",\"name\":\"references\",\"label\":\"References\",\"type\":\"text\",\"required\":\"0\"}]}', 'plg_share=1\nplg_favorite=1\nplg_versions=0\nplg_reviews=1\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=1\nplg_recommendations=1\nplg_citations=0\nplg_supportingdocs=1\nplg_usagenew=0\nplg_about=1\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('11', 'elink', 'External Link', '30', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('12', 'ilink', 'Internal Link', '30', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('13', 'file', 'File', '30', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('14', 'presentationslides', 'Presentation Slides', '28', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('15', 'quicktime', 'Quicktime', '30', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('19', 'presentation', 'Presentation (without audio)', '28', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('20', 'presentation_audio', 'Presentation (with audio)', '28', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('21', NULL, 'Sub Type', '0', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('22', 'researchseminars', 'Research Seminars', '21', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('26', 'flash_paper', 'Flash Paper', '30', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('27', NULL, 'Main Types', '0', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('28', NULL, 'Logical Type', '0', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('29', NULL, 'Group', '0', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('30', NULL, 'Type', '0', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('31', 'series', 'Series', '27', 'Series are collections of lectures, publications, and other resources presented as a list.  Each series is available as a podcast feed.', '0', 'credits=Credits=textarea=0\nsponsoredby=Sponsored by=textarea=0\nreferences=References=textarea=0', 'plg_citations=0\nplg_questions=0\nplg_recommendations=1\nplg_related=1\nplg_reviews=1\nplg_usage=0\nplg_versions=0\nplg_favorite=1\nplg_share=1\nplg_wishlist=0\nplg_supportingdocs=1\nplg_about=1\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('32', 'breeze', 'Breeze', '30', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('33', 'pdf', 'PDF', '30', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('34', 'quiz', 'Quiz', '28', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('35', 'powerpoint', 'PowerPoint', '30', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('36', 'poster', 'Poster', '28', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('37', 'player', 'Media Player', '30', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('38', 'package', 'Package', '30', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('39', 'teachingmaterials', 'Teaching Materials', '27', 'Supplementary materials (study notes, guides, etc.) that don\\\'t quite fit into any of the other categories.', '1', 'references=References=textarea=0', 'plg_citations=0\nplg_questions=0\nplg_recommendations=1\nplg_related=1\nplg_reviews=1\nplg_usage=0\nplg_versions=0\nplg_favorite=1\nplg_share=1\nplg_wishlist=0\nplg_supportingdocs=1\nplg_about=1\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('40', 'video_stream', 'Video Stream', '28', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('41', 'video', 'Video', '30', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('48', 'tutorials', 'Tutorials', '21', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('49', 'podcastaudio', 'Podcast (audio)', '28', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('50', 'podcastvideo', 'Podcast (video)', '28', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('51', 'homeworkassignment', 'Homework Assignment', '28', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('54', 'courselectures', 'Course Lectures', '21', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('55', 'thesis', 'Ph.D. Thesis', '28', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('56', 'publicationpreprint', 'Publication Preprint', '28', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('57', 'handout', 'Handout', '28', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('58', 'undergraduatepresentation', 'Undergraduate Presentation', '21', '', '1', '{\"fields\":[]}', 'linkAction=extension\nplg_share=0\nplg_favorite=0\nplg_versions=0\nplg_reviews=0\nplg_questions=0\nplg_wishlist=0\nplg_usage=0\nplg_related=0\nplg_recommendations=0\nplg_citations=0\nplg_supportingdocs=0\nplg_usagenew=0\nplg_about=0\nplg_abouttool=0');
INSERT INTO `#__resource_types` VALUES ('59', 'manual', 'Manual', '28', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('60', 'software_download', 'Software Download', '28', NULL, '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('62', 'hubpresenter', 'HUBpresenter', '30', 'HTML5 Breeze Replacement', '1', NULL, NULL);
INSERT INTO `#__resource_types` VALUES ('63', 'html5video', 'HTML5 Video', '28', 'HTML5 Video with Subtitle support!', '1', NULL, NULL);

--
-- HUBzero sample data for table `#__support_acl_acos`
--

INSERT INTO `#__support_acl_acos` (`id`, `model`, `foreign_key`) VALUES (1,'tickets',NULL);
INSERT INTO `#__support_acl_acos` (`id`, `model`, `foreign_key`) VALUES (2,'comments',NULL);
INSERT INTO `#__support_acl_acos` (`id`, `model`, `foreign_key`) VALUES (3,'private_comments',NULL);

--
-- HUBzero sample data for table `#__support_messages`
--

INSERT INTO `#__support_messages` VALUES (1,'First Contact (no further information needed)','Thank you for using {sitename}, and for reporting this problem.  Your request has been forwarded to a member of our team, and it is being tracked as ticket {ticket#} in our system.  We will keep you informed as we make progress in resolving this issue.\r\n\r\nThanks again for your support!\r\n--the {sitename} team');
INSERT INTO `#__support_messages` VALUES (2,'First Contact (more information is needed)','Thank you for using {sitename}, and for reporting this problem.  Your request has been forwarded to a member of our team, and it is being tracked as ticket {ticket#} in our system.\r\n\r\nIn order to resolve this issue, we need some more information:\r\n\r\nXXXXXXX  Input questions here XXXXXX\r\n\r\nPlease reply back to {siteemail} with the requested information. If we haven\\\'t heard back from you in 48 hours, we\\\'ll assume that you are no longer experiencing the problem, or that you\\\'ve worked around it, and we\\\'ll consider the matter closed.  You can reopen the matter at any time by sending email or by submitting another problem report on our web site.\r\n\r\nThanks again for your support!\r\n--the {sitename} team');
INSERT INTO `#__support_messages` VALUES (3,'Final Contact (closing ticket)','We haven not heard back from you so we will assume that you are no\r\nlonger experiencing the problem, or that you\\\'ve worked around it, and we\\\'ll consider the matter closed.  You can reopen the matter at any time by sending email or by submitting another problem report on our web site.\r\n\r\nThanks again for your support!\r\n--the {sitename} team');
INSERT INTO `#__support_messages` VALUES (4,'Ticket Resolved','Thank you for using {sitename}, and for reporting this problem.  We believe that your issue (ticket {ticket#} in our system) has been resolved. If you continue to have problems please let us know.\r\n\r\nThank you for helping us to improve {sitename}!\r\n--the {sitename} team');
INSERT INTO `#__support_messages` VALUES (5,'Reply to tickets that have been in the queue for a while','Thank you for using {sitename}.  We apologize for not responding to your request sooner.  We have received more support requests than we can handle, and we are working hard to improve our help-desk support.\r\n\r\nYour request was concerning XXXXXXXXXXXXX. \r\n\r\nMany problems have been fixed since your message.  Is this still a problem for you now?  Is there any more information you could give us about this? Please reply back to {siteemail} with any additional information. If we haven\\\'t heard back from you in 48 hours, we\\\'ll assume that you are no longer experiencing the problem, or that it is no longer an issue for you, and we\\\'ll consider the matter closed.  You can reopen the matter at any time by sending email or by submitting another problem report on our web site.\r\n\r\nThanks again for your support!\r\n--the {sitename} team');

--
-- HUBzero sample data for table `#__support_resolutions`
--

INSERT INTO `#__support_resolutions` VALUES (1,'Fixed','fixed');
INSERT INTO `#__support_resolutions` VALUES (2,'Invalid','invalid');
INSERT INTO `#__support_resolutions` VALUES (3,'Won\'t fix','wontfix');
INSERT INTO `#__support_resolutions` VALUES (4,'Duplicate','duplicate');
INSERT INTO `#__support_resolutions` VALUES (5,'Works for me','worksforme');
INSERT INTO `#__support_resolutions` VALUES (6,'Transferred','transferred');
INSERT INTO `#__support_resolutions` VALUES (7,'Answered','answered');

--
-- HUBzero sample data for table `#__xorganization_types`
--

INSERT INTO `#__xorganization_types` VALUES (1,'government','Government Agency');
INSERT INTO `#__xorganization_types` VALUES (2,'industry','Industry / Private Company');
INSERT INTO `#__xorganization_types` VALUES (3,'military','Military');
INSERT INTO `#__xorganization_types` VALUES (4,'nationallab','National Laboratory');
INSERT INTO `#__xorganization_types` VALUES (5,'universityfaculty','University / College Faculty');
INSERT INTO `#__xorganization_types` VALUES (6,'universitystaff','University / College Staff');
INSERT INTO `#__xorganization_types` VALUES (7,'universityundergraduate','University / College Undergraduate');
INSERT INTO `#__xorganization_types` VALUES (8,'precollegefacultystaff','K-12 (Pre-College) Faculty or Staff');
INSERT INTO `#__xorganization_types` VALUES (9,'precollegestudent','K-12 (Pre-College) Student');
INSERT INTO `#__xorganization_types` VALUES (10,'unemployed','Retired / Unemployed');
INSERT INTO `#__xorganization_types` VALUES (11,'universitygraduate','University / College Graduate Student');

--
-- HUBzero sample data for table `#__poll_data`
--

INSERT INTO `#__poll_data` VALUES (1,1,'Graduate student',0);
INSERT INTO `#__poll_data` VALUES (2,1,'Undergraduate student',0);
INSERT INTO `#__poll_data` VALUES (3,1,'High school or elementary student',0);
INSERT INTO `#__poll_data` VALUES (4,1,'College faculty',0);
INSERT INTO `#__poll_data` VALUES (5,1,'Professional scientist/engineer',0);
INSERT INTO `#__poll_data` VALUES (6,1,'Retired, but still curious',0);

--
-- HUBzero sample data for table `#__poll_menu`
--

INSERT INTO `#__poll_menu` (`pollid`, `menuid`) VALUES (1,0);

--
-- HUBzero sample data for table `#__polls`
--

INSERT INTO `#__polls` (`id`, `title`, `voters`, `checked_out`, `checked_out_time`, `published`, `access`, `lag`, `open`, `opened`, `closed`) VALUES (1,'Who are you?',0,0,'0000-00-00 00:00:00',1,0,86400,1,NULL,NULL);

