<?php
/**
 * HUBzero CMS
 *
 * Copyright 2005-2011 Purdue University. All rights reserved.
 *
 * This file is part of: The HUBzero(R) Platform for Scientific Collaboration
 *
 * The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
 * software: you can redistribute it and/or modify it under the terms of
 * the GNU Lesser General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * HUBzero is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * HUBzero is a registered trademark of Purdue University.
 *
 * @package   hubzero-cms
 * @author    Ilya Shunko <ishunko@purdue.edu>
 * @copyright Copyright 2005-2012 Purdue University. All rights reserved.
 * @license   http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

ximport('Hubzero_Controller');

/**
 * Product viewing controller class
 */
class StorefrontControllerProduct extends ComponentController
{		
	/**
	 * Execute a task
	 * 
	 * @return     void
	 */
	public function execute()
	{
		include_once(JPATH_COMPONENT . DS . 'models' . DS . 'Warehouse.php');
		$this->warehouse = new StorefrontModelWarehouse();
		
		$app = JFactory::getApplication();
		$pathway = $app->getPathway();
				
		$this->pathway = $pathway;
		$this->_getStyles();
		
		// Get the task
		$this->_task  = JRequest::getCmd('task', '');
		
		if (empty($this->_task))
		{
			JError::raiseError(404, JText::_('COM_STOREFRONT_PAGE_NOT_FOUND'));
		}
		elseif (!method_exists($this, $this->_task . 'Task'))
		{
			// Try to find a corresponding collection
			$pId = $this->warehouse->productExists($this->_task);
			if ($pId)
			{
				// if match is found -- display the product
				$executed = true;
				$this->displayProduct($pId);
			}
			else {
				JError::raiseError(404, JText::_('COM_STOREFRONT_PRODUCT_NOT_FOUND'));		
			}
		}		
		else
		{
			parent::execute();
		}
	}
	
	/**
	 * Display product
	 * 
	 * @param		$pId
	 * @return     	void
	 */
	private function displayProduct($pId) 
	{
		$view = new JView( array('name'=>'product', 'layout' => 'display') );
		$view->pId = $pId;
		
		$doc = JFactory::getDocument();
		$doc->addScript(DS . 'components' . DS . 'com_storefront' . DS . 'assets' . DS . 'js' . DS . 'product_display.js');
		//$doc->addScript(JURI::root() . 'storefront/product/getJs');
		
		// POST add to cart request
		// handle add to cart requests if needed for non-ajax transactions
		$addToCartRequest = JRequest::getVar('addToCart', false, 'post');
		$options = JRequest::getVar('og', false, 'post');
		$qty = JRequest::getInt('qty', 1, 'post');
				
		if ($addToCartRequest)
		{		
			// Initialize errors array
			$errors = array();
			
			// Check if passed options/productID map to a SKU
			try
			{
				$sku = $this->warehouse->mapSku($pId, $options);
				
				include_once(JPATH_BASE . DS . 'components' . DS . 'com_cart' . DS . 'models' . DS . 'cart.php');
				$cart = new CartModelCart();				
				$cart->add($sku, $qty);					
			}		
			catch (Exception $e)
			{
				$errors[] = $e->getMessage();
			}
			
			if (!empty($errors)) 
			{
				$view->setError($errors);
			}
			else {
				// prevent resubmitting by refresh
				// If not an ajax call, redirect to cart
				$redirect_url  = JRoute::_('index.php?option=' . 'com_cart');
				$app  =  JFactory::getApplication();
				$app->redirect($redirect_url);		
			}			
		}
		
		// Get the product info
		$product = $this->warehouse->getProductInfo($pId);
		$view->product = $product;
		
		//print_r($product); die;
		
		// Get option groups with options and SKUs
		$data = $this->warehouse->getProductOptions($pId);
		$view->options = $data->options;
		
		//print_r($data); die;
		
		// Find a price range for the product
		$priceRange = array('high' => 0, 'low' => false);
		
		/* 
			Find if there is a need to display a product quantity dropdown on the initial view load. It will be only displayed for single SKU that allows multiple items. 
			For multiple SKUs it will be generated by JS (no drop-down for non-JS users, sorry)
		*/
		$qtyDropDownMaxVal = 0;
		
		$inStock = true;
		if (!count($data->skus))
		{
			$inStock = false;
		}
		$view->inStock = $inStock;
		
		if (count($data->skus) == 1)
		{
			// Get the first and the only value
			$sku = array_shift(array_values($data->skus));
			
			$qtyDropDownMaxVal = $sku['info']->sInventory;
			
			if ($qtyDropDownMaxVal < 1) 
			{
				$qtyDropDownMaxVal = 1;
			}
			// Limit to max number
			elseif ($qtyDropDownMaxVal > 20)
			{
				$qtyDropDownMaxVal = 20;
			}
			
			// If the SKU doesn't allow multiple items, reset the dropdown
			if (!$sku['info']->sAllowMultiple)
			{
				$qtyDropDownMaxVal = 0;
			}
		}
		
		$view->qtyDropDown = $qtyDropDownMaxVal;
		
		foreach ($data->skus as $sId => $info)
		{
			$info = $info['info'];
			
			if ($info->sPrice > $priceRange['high'])
			{
				$priceRange['high'] = $info->sPrice;
			}
			if (!$priceRange['low'] || $priceRange['low'] > $info->sPrice)
			{
				$priceRange['low'] = $info->sPrice;
			}
		}
		$view->price = $priceRange;

		// Add custom page JS
		$js = $this->getDisplayJs($data->options, $data->skus);
		$doc->addScriptDeclaration($js);
		
		// Breadcrumbs
		$this->pathway->addItem($product->pName, JRoute::_('index.php?id=' . '5'));
		
		$view->display();
	}
	
	/**
	 * Generate JS needed for displaying a product page
	 * 
	 * @param		void
	 * @return     	void
	 */
	private function getDisplayJs($ops, $skus) 
	{
		$js = "\tSF.OPTIONS = {\n";
		
			// generate skus
			$js .= "\t\tskus: [\n";
			
			// generate pricing
			$skuPrices = "\t\tskuPrices: [";
			
			// generate inventory level for each SKU (for the number of products drop-down)
			$inventory = "\t\tskuInventory: [";
			
			$i = 0;
			foreach ($skus as $sId => $data)
			{
				$options = $data['options'];
				$info = $data['info'];
				$js .=  "\t\t\t[";
				
				if ($i)
				{
					$skuPrices .= ',';	
				}
				// convert price to integer for precision
				$skuPrices .= '"' . $info->sPrice * 100 . '"';
				
				// inventory
				if ($i)
				{
					$inventory .= ',';	
				}
				if (!$info->sAllowMultiple)
				{
					$inventory .= '1';
				}
				elseif (!$info->sTrackInventory)
				{
					$inventory .= '20';	
				}
				elseif (empty($info->sInventory))
				{
					$inventory .= '1';	
				}
				else {
					$inventory .= $info->sInventory > 20 ? 20 : $info->sInventory;	
				}									
				
				$sku = '';
				foreach ($options as $option)
				{			
					if ($sku)		
					{
						$sku .= ', ';
					}
					$sku .= '"' . $option . '"';	
				}
				$js .= $sku;
				$js .= "]";
				$i++;
				
				if (count($skus) > $i)
				{
					$js .= ',';
				}
				$js .= "\n";
			}
			
			$js .= "\t\t],\n";
			
			$js .= "\n";
			
			/*
				skus: [
					["1", "4", "6"],
					["2", "4", "7"],
					["3", "5", "6"],
					["2", "5", "8"],
					["2", "5", "7"]
				],
			*/
			
			$skuPrices .= "],\n";			
			$js .= $skuPrices;
			
			$js .= "\n";
			
			$inventory .= "],\n";
			$js .= $inventory;
			
			$js .= "\n";
			
			/*
				skuPrices: ["10", "5", "7"],
			*/				
			
			// Generate ops
			$js .= "\t\tops: [\n";
			
			$i = 0;
			foreach ($ops as $oId => $data)
			{
				$options = $data['options'];
				$js .=  "\t\t\t[";
				
				$optionIds = '';
				foreach ($options as $option)
				{			
					if ($optionIds)		
					{
						$optionIds .= ', ';
					}
					$optionIds .= '"' . $option->oId . '"';	
				}
				$js .= $optionIds;	
				$js .= "]";
				$i++;
				
				if (count($ops) > $i)
				{
					$js .= ',';
				}
				$js .= "\n";	
			}
			
			$js .= "\t\t],\n";
				
			/*
			ops: [
				["1", "2", "3"],
				["4", "5"],
				["6", "7", "8"]
			]
			*/
				
		$js .= "\t}";
		return $js;		
	}

}

