# @package      hubzero-chuse
# @file         env_files.tcl
# @author       Derrick Kearney <dsk@purdue.edu>
# @copyright    Copyright (c) 2005-2012 Purdue University. All rights reserved.
# @license      http://www.gnu.org/licenses/lgpl-3.0.html LGPLv3
#
# Copyright (c) 2005-2012 Purdue University
# All rights reserved.
#
# This file is part of: The HUBzero(R) Platform for Scientific Collaboration
#
# The HUBzero(R) Platform for Scientific Collaboration (HUBzero) is free
# software: you can redistribute it and/or modify it under the terms of
# the GNU Lesser General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any
# later version.
#
# HUBzero is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# HUBzero is a registered trademark of Purdue University.
#

proc parse_env_dir {args} {
    global conflictDB

    set flist ""
    set envdata ""

    # grab all file names first
    foreach dirname $args {
        if {![file exists $dirname] || ![file isdirectory $dirname]} {
            continue
        }

        set flist [concat $flist [glob $dirname/*]]
    }

    # sort based on tail name
    # process files
    foreach f [lsort -command parse_compare $flist] {
        set environinfo [parse_env $f]
        if {[llength $environinfo] == 0} {
            continue
        }
        foreach {fname conflict desc help ver tags} $environinfo break
        lappend envdata $fname $conflict $desc $help $ver $tags
        lappend conflictDB($conflict) $fname
        lappend conflictDB($fname) $conflict
    }

    return $envdata
}

proc parse_compare {a b} {
    set a0 [file tail $a]
    set b0 [file tail $b]
    return [string compare $a0 $b0]
}

proc parse_active_envs {fname} {
    if {![file exists $fname] || ![file isfile $fname] || ![file readable $fname]} {
        return ""
    }

    if {[catch {open $fname r} fid]} {
        puts stderr "Warning: $fid"
        return ""
    }
    set envtext [split [read $fid] "\n"]
    close $fid
    return $envtext
}

# FIXME: use a tcl safe interp to parse the env files instead of regexp's
proc parse_env {fname} {
    if {![file exists $fname] || ![file isfile $fname] || ![file readable $fname]} {
        return ""
    }

    if {[catch {open $fname r} fid]} {
        puts stderr "Warning: $fid"
        return ""
    }
    set envtext [read $fid]
    close $fid

    set conflict ""
    set desc ""
    set help ""
    set version ""
    set tags ""

    regexp -nocase {\nversion=([\w[:punct:]]+)} $envtext match version
    regsub -all {\$\{version\}} $envtext $version envtext
    regexp -nocase {conflict\s(\w+)} $envtext match conflict
    regexp -nocase {desc\s\"([^\"]+)\"} $envtext match desc
    regexp -nocase {help\s\"([^\"]+)\"} $envtext match help
    regexp -nocase {tags\s([\s\w]+)\n} $envtext match tags

    return [list [file tail $fname] $conflict $desc $help $version $tags]
}

proc env_parse_test {} {

    foreach f [glob environ/*] {
        lappend envdata [parse_env $f]
    }

    puts $envdata
}
